package com.hollingsworth.nuggets.client.gui;

import com.hollingsworth.nuggets.client.BlitInfo;
import org.lwjgl.glfw.GLFW;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class VerticalSlider extends BaseSlider {
    public Consumer<Integer> onChange;
    public BlitInfo scrollBar;
    public BlitInfo scrollContainer;

    public VerticalSlider(int x, int y, int width, int height, BlitInfo scrollBar, BlitInfo scrollContainer, double maxValue, double stepSize, int precision, Consumer<Integer> onChange) {
        super(x, y, width, height, class_2561.method_43473(), class_2561.method_43473(), 0, maxValue, 0, stepSize, precision, false);
        this.onChange = onChange;
        this.scrollBar = scrollBar;
        this.scrollContainer = scrollContainer;
    }

    public VerticalSlider(int x, int y, int width, int height, BlitInfo scrollBar, BlitInfo scrollContainer, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        super(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, drawString);
        this.scrollBar = scrollBar;
        this.scrollContainer = scrollContainer;
    }

    @Override
    protected void method_25344() {
        super.method_25344();
        onChange.accept(this.getValueInt());
    }


    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        GuiHelpers.blit(guiGraphics, scrollContainer, method_46426(), method_46427());
        GuiHelpers.blit(guiGraphics, scrollBar, method_46426() + 3, method_46427() + (int) (this.field_22753 * (double) (this.field_22759 - 3)));
    }

    @Override
    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if(pScrollY != 0){
            this.method_25347(this.getValue() + (pScrollY > 0 ? -1 : 1) * stepSize);
            method_25344();
            return true;
        }
        return super.method_25401(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean flag = keyCode == GLFW.GLFW_KEY_LEFT;
        if (flag || keyCode == GLFW.GLFW_KEY_RIGHT) {
            if (this.minValue > this.maxValue)
                flag = !flag;
            float f = flag ? -1F : 1F;
            if (stepSize <= 0D)
                this.setSliderValue(this.field_22753 + (f / (this.field_22759 - 8)));
            else
                this.method_25347(this.getValue() + f * this.stepSize);
        }

        return false;
    }

    @Override
    public void setValueFromMouse(double mouseX, double mouseY) {
        this.setSliderValue((mouseY - (this.method_46427() + 4)) / (this.field_22759 - 8));
    }
}
