package com.hollingsworth.nuggets.client.area_capture;


import com.hollingsworth.nuggets.client.NuggetClientData;
import com.hollingsworth.nuggets.common.util.RaycastHelper;
import com.hollingsworth.nuggets.common.util.VecHelper;
import org.joml.Matrix4f;

import java.util.function.BiConsumer;
import net.minecraft.class_1041;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3341;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import net.minecraft.class_761;


public class AreaCaptureHandler {

    public class_2338 firstTarget;
    public class_2338 secondTarget;
    public boolean showBoundary;
    public class_2350 selectedFace = null;
    BiConsumer<class_3341, AreaCaptureHandler> onConfirmedRegion;
    CaptureSchematicScreen captureSchematicScreen;
    private final String modId;
    private final class_304 focusKey;

    public AreaCaptureHandler(String modId, class_304 focusKey, BiConsumer<class_3341, AreaCaptureHandler> onConfirmedRegion){
        this.modId = modId;
        this.focusKey = focusKey;
        this.onConfirmedRegion = onConfirmedRegion;
        this.captureSchematicScreen = new CaptureSchematicScreen(modId, focusKey, onConfirmedRegion, this);
    }

    // Right click event
    public void rightClickEvent() {
        if (!showBoundary) {
            return;
        }
        captureSchematicScreen.getSelectedElement().onClick();
    }

    // Bound tool key pressed event
    public void toolKeyHit(boolean keyPressed){
        if (!showBoundary) {
            return;
        }
        if (keyPressed && !captureSchematicScreen.focused)
            captureSchematicScreen.focused = true;
        if (!keyPressed && captureSchematicScreen.focused) {
            captureSchematicScreen.focused = false;
            captureSchematicScreen.method_25419();
        }
    }

    public boolean mouseScrolled(double delta) {
        if (!showBoundary) {
            return false;
        }
        return captureSchematicScreen.scroll(delta);
    }

    // RenderGuiLayerEvent.Post event
    public void renderInstructions(class_332 graphics, class_1041 window) {
        if (!showBoundary)
            return;
        captureSchematicScreen.renderPassive(graphics, 0);
    }


    public void startCapture(){
        showBoundary = true;
        firstTarget = null;
        secondTarget = null;
        this.captureSchematicScreen = new CaptureSchematicScreen(modId, focusKey, onConfirmedRegion, this);
    }

    public void cancelCapture(){
        showBoundary = false;
        firstTarget = null;
        secondTarget = null;
    }

    public class_2338 selectedPos = null;

    public void renderBoundary(class_4587 poseStack, Matrix4f modelViewMatrix) {
        if (!showBoundary)
            return;
        class_2338 firstPos = firstTarget;
        class_746 player = class_310.method_1551().field_1724;
        class_3965 trace = RaycastHelper.rayTraceRange(player.method_37908(), player, 75);
        if (trace.method_17783() == class_239.class_240.field_1332) {

            class_2338 hit = trace.method_17777();
            boolean replaceable = player.method_37908().method_8320(hit)
                    .method_26166(new class_1750(new class_1838(player, class_1268.field_5808, trace)));
            if (trace.method_17780()
                    .method_10166()
                    .method_10178() && !replaceable)
                hit = hit.method_10093(trace.method_17780());
            selectedPos = hit;
        } else {
            selectedPos = null;
        }
        if (firstPos == null && selectedPos != null) {
            renderBbox(new class_238(selectedPos), poseStack, modelViewMatrix);
            return;
        }
        class_2338 secondPos = secondTarget;
        if (secondPos == null) {
            secondPos = selectedPos;
        }
        class_238 currentSelectionBox = null;
        if (secondPos == null) {
            if (firstPos == null) {
                currentSelectionBox = selectedPos == null ? null : new class_238(selectedPos);
            } else {
                currentSelectionBox = selectedPos == null ? new class_238(firstPos) : class_238.method_54784(firstPos, selectedPos).method_1012(1, 1, 1);
            }
        } else {
            currentSelectionBox = class_238.method_54784(firstPos, secondPos).method_1012(1, 1, 1);
        }

        renderBbox(currentSelectionBox, poseStack, modelViewMatrix);
    }

    public void renderBbox(class_238 currentSelectionBox, class_4587 poseStack, Matrix4f modelViewMatrix) {
        if (currentSelectionBox == null) {
            return;
        }
        class_243 camera = class_310.method_1551().field_1773.method_19418()
                .method_19326();

        currentSelectionBox.method_997(camera.method_1021(-1));
        currentSelectionBox = currentSelectionBox.method_989(-camera.field_1352, -camera.field_1351, -camera.field_1350);

        poseStack.method_22903();
        poseStack.method_34425(modelViewMatrix);
        class_4588 vertexconsumer = NuggetClientData.bufferSource.getBuffer(class_1921.method_23594());
        class_761.method_22982(poseStack, vertexconsumer, currentSelectionBox, 0.9F, 0.9F, 0.9F, 1.0f);
        NuggetClientData.bufferSource.method_22993();
        poseStack.method_22909();
    }

    public void tick(){
        if(!showBoundary){
            return;
        }
        captureSchematicScreen.update();
        selectedFace = null;
        if (secondTarget != null) {
            class_1657 player = class_310.method_1551().field_1724;
            class_238 bb = class_238.method_54784(firstTarget, secondTarget).method_1012(1, 1, 1)
                    .method_1014(.45f);
            class_243 projectedView = class_310.method_1551().field_1773.method_19418()
                    .method_19326();
            boolean inside = bb.method_1006(projectedView);
            RaycastHelper.PredicateTraceResult result =
                    RaycastHelper.rayTraceUntil(player, 70, pos -> inside ^ bb.method_1006(VecHelper.getCenterOf(pos)));
            selectedFace = result.missed() ? null
                    : inside ? result.getFacing()
                    .method_10153() : result.getFacing();
        }

    }
}
