/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.common.util;

import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import org.jetbrains.annotations.NotNull;

public class BlockPosHelpers {
    public static final BiPredicate<class_1922, class_2338> TWO_HIGH_AIR_POS_SELECTOR = (world, pos) -> (world.method_8320(pos).method_26225() || world.method_8320(pos).method_51176()) && world.method_8320(pos.method_10084()).method_26215() && world.method_8320(pos.method_10086(2)).method_26215();

    private static class_2338 findSpawnPointInDirections(class_1937 level, class_2338 start, class_2338 advancePos) {
        class_2338 spawnPos = new class_2338((class_2382)start);
        class_243 tempPos = new class_243((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260());
        int xDiff = Math.abs(start.method_10263() - advancePos.method_10263());
        int zDiff = Math.abs(start.method_10260() - advancePos.method_10260());
        class_243 xzRatio = new class_243((double)(xDiff * (start.method_10263() < advancePos.method_10263() ? 1 : -1)), 0.0, (double)(zDiff * (start.method_10260() < advancePos.method_10260() ? 1 : -1)));
        xzRatio = xzRatio.method_1029().method_1021(3.0);
        int validChunkCount = 0;
        for (int i = 0; i < 10 && level.method_8477(class_2338.method_49638((class_2374)tempPos)) && level.method_8477(class_2338.method_49638((class_2374)(tempPos = tempPos.method_1031(16.0 * xzRatio.field_1352, 0.0, 16.0 * xzRatio.field_1350)))); ++i) {
            spawnPos = class_2338.method_49638((class_2374)tempPos);
            if (++validChunkCount <= 5) continue;
            return spawnPos;
        }
        if (!spawnPos.equals((Object)start)) {
            return spawnPos;
        }
        return null;
    }

    public static class_2338 getRandomSpawn(class_2338 calcCenter, class_1937 level) {
        int degree = level.field_9229.method_43048(360);
        int x = (int)Math.round(20.0 * Math.cos(Math.toRadians(degree)));
        int z = (int)Math.round(20.0 * Math.sin(Math.toRadians(degree)));
        class_2338 advanceTowards = calcCenter.method_10069(x, 0, z);
        class_2338 spawnPos = null;
        for (int i = 0; i < 8 && (spawnPos = BlockPosHelpers.findSpawnPointInDirections(level, new class_2338(calcCenter.method_10263(), calcCenter.method_10264(), calcCenter.method_10260()), advanceTowards)) == null; ++i) {
        }
        if (spawnPos == null) {
            return null;
        }
        return BlockPosHelpers.findAround(level, BlockPosHelpers.getFloor(spawnPos, level), 3, 30, TWO_HIGH_AIR_POS_SELECTOR);
    }

    @NotNull
    public static class_2338 getFloor(@NotNull class_2338 position, @NotNull class_1937 world) {
        class_2338 floor = BlockPosHelpers.getFloor(new class_2338.class_2339(position.method_10263(), position.method_10264(), position.method_10260()), 0, world);
        if (floor == null) {
            return position;
        }
        return floor;
    }

    @Nullable
    public static class_2338 getFloor(class_2338.class_2339 position, int depth, @NotNull class_1937 world) {
        if (!BlockPosHelpers.solidOrLiquid(world, (class_2338)position)) {
            return BlockPosHelpers.getFloor(position.method_10103(position.method_10263(), position.method_10264() - 1, position.method_10260()), depth + 1, world);
        }
        if (!BlockPosHelpers.solidOrLiquid(world, (class_2338)position.method_10103(position.method_10263(), position.method_10264() + 1, position.method_10260())) && !BlockPosHelpers.solidOrLiquid(world, (class_2338)position.method_10103(position.method_10263(), position.method_10264() + 2, position.method_10260()))) {
            return position.method_10062();
        }
        return BlockPosHelpers.getFloor(position.method_10103(position.method_10263(), position.method_10264() + 1, position.method_10260()), depth + 1, world);
    }

    public static boolean solidOrLiquid(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        class_2680 state = world.method_8320(blockPos);
        return state.method_26215() || state.method_51176();
    }

    public static class_2338 findAround(class_1937 world, class_2338 start, int verticalRange, int horizontalRange, BiPredicate<class_1922, class_2338> predicate) {
        if (horizontalRange < 1 && verticalRange < 1) {
            return null;
        }
        if (predicate.test((class_1922)world, start)) {
            return start;
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < verticalRange + 2; ++i) {
            for (int steps = 1; steps <= horizontalRange; ++steps) {
                int z;
                int x;
                class_2338 temp = start.method_10069(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((class_1922)world, temp = temp.method_10069(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((class_1922)world, temp = temp.method_10069(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((class_1922)world, temp = temp.method_10069(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((class_1922)world, temp = temp.method_10069(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (BlockPosHelpers.isInWorldHeight(start.method_10264() + (y += (y_offset *= -1)), world)) continue;
            return null;
        }
        return null;
    }

    public static boolean isInWorldHeight(int yBlock, class_1937 world) {
        class_2874 dimensionType = world.method_8597();
        return yBlock > BlockPosHelpers.getDimensionMinHeight(dimensionType) && yBlock < BlockPosHelpers.getDimensionMaxHeight(dimensionType);
    }

    public static int getDimensionMaxHeight(class_2874 dimensionType) {
        return dimensionType.comp_653() + dimensionType.comp_651();
    }

    public static int getDimensionMinHeight(class_2874 dimensionType) {
        return dimensionType.comp_651();
    }

    public static double distanceBetween(class_2338 blockPos, class_2338 blockPos2) {
        return Math.sqrt(Math.pow(blockPos.method_10263() - blockPos2.method_10263(), 2.0) + Math.pow(blockPos.method_10264() - blockPos2.method_10264(), 2.0) + Math.pow(blockPos.method_10260() - blockPos2.method_10260(), 2.0));
    }
}

