/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.area_capture.AreaCaptureHandler;
import com.hollingsworth.nuggets.client.area_capture.BaseSchematicScreen;
import com.hollingsworth.nuggets.client.area_capture.ToolType;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_437;

public class CaptureSchematicScreen
extends BaseSchematicScreen {
    public AreaCaptureHandler areaCaptureHandler;
    public SelectPositionTool selectPositionTool;
    public HorizontalMoveTool horizontalMoveTool;
    public VerticalMoveTool verticalMoveTool;
    public ExpandTool expandTool;
    public ConfirmTool confirmTool;
    public CancelTool cancelTool;
    public BiConsumer<class_3341, AreaCaptureHandler> onConfirmed;

    protected CaptureSchematicScreen(String modId, class_304 focusKey, BiConsumer<class_3341, AreaCaptureHandler> onConfirmed, AreaCaptureHandler areaCaptureHandler) {
        super(modId, focusKey, (class_2561)class_2561.method_43470((String)"Capture Schematic Screen"));
        this.areaCaptureHandler = areaCaptureHandler;
        this.onConfirmed = onConfirmed;
        this.selectPositionTool = new SelectPositionTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_place.png"));
        this.horizontalMoveTool = new HorizontalMoveTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_horizontal.png"));
        this.verticalMoveTool = new VerticalMoveTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_vertical.png"));
        this.expandTool = new ExpandTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_resize.png"));
        this.confirmTool = new ConfirmTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_confirm.png"));
        this.cancelTool = new CancelTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_trash.png"));
        this.tools.add(this.selectPositionTool);
        this.tools.add(this.cancelTool);
    }

    public void onBoundarySet() {
        this.tools.clear();
        this.tools.add(this.horizontalMoveTool);
        this.tools.add(this.verticalMoveTool);
        this.tools.add(this.expandTool);
        this.tools.add(this.confirmTool);
        this.tools.add(this.cancelTool);
    }

    public static class SelectPositionTool
    extends ToolType<CaptureSchematicScreen> {
        public SelectPositionTool(CaptureSchematicScreen captureSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.place_tool"), icon, captureSchematicScreen);
        }

        @Override
        public void onClick() {
            AreaCaptureHandler captureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            class_2338 pos = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler.selectedPos;
            if (pos == null) {
                return;
            }
            if (captureHandler.firstTarget == null) {
                captureHandler.firstTarget = pos.method_10062();
            } else if (captureHandler.secondTarget == null && !captureHandler.firstTarget.equals((Object)pos)) {
                captureHandler.secondTarget = pos.method_10062();
                ((CaptureSchematicScreen)this.placeSchematicScreen).onBoundarySet();
            }
        }

        @Override
        List<class_2561> getDescription() {
            return List.of(class_2561.method_43471((String)"nuggets.select_position_tool_description"));
        }
    }

    public static class HorizontalMoveTool
    extends ToolType<CaptureSchematicScreen> {
        public HorizontalMoveTool(CaptureSchematicScreen captureSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.move_horizontal_tool"), icon, captureSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            AreaCaptureHandler areaCaptureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            if (delta > 0.0) {
                areaCaptureHandler.firstTarget = areaCaptureHandler.firstTarget.method_10078();
                areaCaptureHandler.secondTarget = areaCaptureHandler.secondTarget.method_10078();
            } else {
                areaCaptureHandler.firstTarget = areaCaptureHandler.firstTarget.method_10067();
                areaCaptureHandler.secondTarget = areaCaptureHandler.secondTarget.method_10067();
            }
            return true;
        }

        @Override
        public List<class_2561> getDescription() {
            return List.of(class_2561.method_43471((String)"nuggets.move_horizontal_description"));
        }
    }

    public static class VerticalMoveTool
    extends ToolType<CaptureSchematicScreen> {
        public VerticalMoveTool(CaptureSchematicScreen captureSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.move_vertical_tool"), icon, captureSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            AreaCaptureHandler areaCaptureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            if (delta > 0.0) {
                areaCaptureHandler.firstTarget = areaCaptureHandler.firstTarget.method_10084();
                areaCaptureHandler.secondTarget = areaCaptureHandler.secondTarget.method_10084();
            } else {
                areaCaptureHandler.firstTarget = areaCaptureHandler.firstTarget.method_10074();
                areaCaptureHandler.secondTarget = areaCaptureHandler.secondTarget.method_10074();
            }
            return true;
        }

        @Override
        public List<class_2561> getDescription() {
            return List.of(class_2561.method_43471((String)"nuggets.move_vertical_description"));
        }
    }

    public static class ExpandTool
    extends ToolType<CaptureSchematicScreen> {
        public ExpandTool(CaptureSchematicScreen captureSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.expand_tool"), icon, captureSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            AreaCaptureHandler areaCaptureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            boolean showBoundary = areaCaptureHandler.showBoundary;
            class_2338 firstTarget = areaCaptureHandler.firstTarget;
            class_2338 secondTarget = areaCaptureHandler.secondTarget;
            class_2350 selectedFace = areaCaptureHandler.selectedFace;
            if (!showBoundary || firstTarget == null || secondTarget == null) {
                return false;
            }
            if (!class_437.method_25441()) {
                return false;
            }
            if (selectedFace == null) {
                return true;
            }
            class_238 bb = new class_238((double)firstTarget.method_10263(), (double)firstTarget.method_10264(), (double)firstTarget.method_10260(), (double)secondTarget.method_10263(), (double)secondTarget.method_10264(), (double)secondTarget.method_10260());
            class_2382 vec = selectedFace.method_10163();
            class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
            if (bb.method_1006(projectedView)) {
                delta *= -1.0;
            }
            int x = (int)((double)vec.method_10263() * delta);
            int y = (int)((double)vec.method_10264() * delta);
            int z = (int)((double)vec.method_10260() * delta);
            class_2350.class_2352 axisDirection = selectedFace.method_10171();
            if (axisDirection == class_2350.class_2352.field_11060) {
                bb = bb.method_989((double)(-x), (double)(-y), (double)(-z));
            }
            double maxX = Math.max(bb.field_1320 - (double)(x * axisDirection.method_10181()), bb.field_1323);
            double maxY = Math.max(bb.field_1325 - (double)(y * axisDirection.method_10181()), bb.field_1322);
            double maxZ = Math.max(bb.field_1324 - (double)(z * axisDirection.method_10181()), bb.field_1321);
            bb = new class_238(bb.field_1323, bb.field_1322, bb.field_1321, maxX, maxY, maxZ);
            areaCaptureHandler.firstTarget = class_2338.method_49637((double)bb.field_1323, (double)bb.field_1322, (double)bb.field_1321);
            areaCaptureHandler.secondTarget = class_2338.method_49637((double)bb.field_1320, (double)bb.field_1325, (double)bb.field_1324);
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            return List.of(class_2561.method_43471((String)"nuggets.expand_tool.description"), class_2561.method_43471((String)"nuggets.expand_tool.description2"));
        }
    }

    public static class ConfirmTool
    extends ToolType<CaptureSchematicScreen> {
        public ConfirmTool(CaptureSchematicScreen captureSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.confirm_tool_capture"), icon, captureSchematicScreen);
        }

        @Override
        public void onClick() {
            AreaCaptureHandler areaCaptureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            areaCaptureHandler.showBoundary = false;
            if (areaCaptureHandler.firstTarget != null && areaCaptureHandler.secondTarget != null) {
                ((CaptureSchematicScreen)this.placeSchematicScreen).onConfirmed.accept(class_3341.method_34390((class_2382)areaCaptureHandler.firstTarget, (class_2382)areaCaptureHandler.secondTarget), areaCaptureHandler);
            }
        }

        @Override
        List<class_2561> getDescription() {
            return List.of(class_2561.method_43471((String)"nuggets.capture_confirm_tool"));
        }
    }

    public static class CancelTool
    extends ToolType<CaptureSchematicScreen> {
        public CancelTool(CaptureSchematicScreen captureSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.delete_tool"), icon, captureSchematicScreen);
        }

        @Override
        public void onClick() {
            AreaCaptureHandler areaCaptureHandler = ((CaptureSchematicScreen)this.placeSchematicScreen).areaCaptureHandler;
            areaCaptureHandler.cancelCapture();
        }

        @Override
        List<class_2561> getDescription() {
            return List.of(class_2561.method_43471((String)"nuggets.delete_description"));
        }
    }
}

