package com.hollingsworth.nuggets.datagen;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import org.jetbrains.annotations.NotNull;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_7403;

public abstract class SimpleDataProvider implements class_2405 {
    public ImmutableList.Builder<CompletableFuture<?>> futuresBuilder = new ImmutableList.Builder<>();
    public Path output;
    public final class_2403 generator;
    public SimpleDataProvider(class_2403 dataGenerator, Path outputPath){
        this.generator = dataGenerator;
        this.output = outputPath;
    }

    // Save stable to jsons
    public abstract void collectJsons(class_7403 pOutput);

    @Override
    public @NotNull CompletableFuture<?> method_10319(@NotNull class_7403 pOutput) {
        collectJsons(pOutput);
        return CompletableFuture.allOf(futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    public void saveStable(class_7403 pOutput, JsonElement jsonElement, Path path){
        futuresBuilder.add(class_2405.method_10320(pOutput, jsonElement, path));
    }

}
