package com.hollingsworth.nuggets.common.util;

import net.minecraft.class_1267;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3499;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

/**
 * Class which has world related util functions like chunk load checks
 */
public class WorldHelpers {

    public static class_3499 getStructure(class_1937 level, class_2338 first, class_2338 second){
        class_3341 bb = class_3341.method_34390(first, second);
        class_2338 origin = new class_2338(bb.method_35415(), bb.method_35416(), bb.method_35417());
        class_2338 bounds = new class_2338(bb.method_35414(), bb.method_14660(), bb.method_14663());

        class_3499 structure = new class_3499();
        structure.method_15174(level, origin, bounds, true, class_2246.field_10124);
        return structure;
    }

    /**
     * Checks if the block is loaded for block access
     *
     * @param world world to use
     * @param pos   position to check
     * @return true if block is accessible/loaded
     */
    public static boolean isBlockLoaded(final class_1936 world, final class_2338 pos) {
        return isChunkLoaded(world, pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    /**
     * Returns whether a chunk is fully loaded
     *
     * @param world world to check on
     * @param x     chunk position
     * @param z     chunk position
     * @return true if loaded
     */
    public static boolean isChunkLoaded(final class_1936 world, final int x, final int z) {
        if (world.method_8398() instanceof class_3215) {
            return ((class_3215) world.method_8398()).method_17299(x, z, class_2806.field_12803, false).isDone();
        }
        return world.method_8402(x, z, class_2806.field_12803, false) != null;
    }

    /**
     * Mark a chunk at a position dirty if loaded.
     *
     * @param world the world to mark it dirty in.
     * @param pos   the position within the chunk.
     */
    public static void markChunkDirty(final class_1937 world, final class_2338 pos) {
        if (WorldHelpers.isBlockLoaded(world, pos)) {
            world.method_8497(pos.method_10263() >> 4, pos.method_10260() >> 4).method_12008(true);
            final class_2680 state = world.method_8320(pos);
            world.method_8413(pos, state, state, 3);
        }
    }

    /**
     * Returns whether a chunk is fully loaded
     *
     * @param world world to check on
     * @param pos   chunk position
     * @return true if loaded
     */
    public static boolean isChunkLoaded(final class_1936 world, final class_1923 pos) {
        return isChunkLoaded(world, pos.field_9181, pos.field_9180);
    }

    /**
     * Checks if the block is loaded for ticking entities(not all chunks tick entities)
     *
     * @param world world to use
     * @param pos   position to check
     * @return true if block is accessible/loaded
     */
    public static boolean isEntityBlockLoaded(final class_1936 world, final class_2338 pos) {
        return isEntityChunkLoaded(world, pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    /**
     * Returns whether an entity ticking chunk is loaded at the position
     *
     * @param world world to check on
     * @param x     chunk position
     * @param z     chunk position
     * @return true if loaded
     */
    public static boolean isEntityChunkLoaded(final class_1936 world, final int x, final int z) {
        return isEntityChunkLoaded(world, new class_1923(x, z));
    }

    /**
     * Returns whether an entity ticking chunk is loaded at the position
     *
     * @param world world to check on
     * @param pos   chunk position
     * @return true if loaded
     */
    public static boolean isEntityChunkLoaded(final class_1936 world, final class_1923 pos) {
        if (world instanceof class_3218) {
            return ((class_3218) world).method_37118(pos.method_8323());
        }
        return isChunkLoaded(world, pos);
    }

    /**
     * Returns whether an axis aligned bb is entirely loaded.
     *
     * @param world world to check on.
     * @param box   the box.
     * @return true if loaded.
     */
    public static boolean isAABBLoaded(final class_1937 world, final class_238 box) {
        return isChunkLoaded(world, ((int) box.field_1323) >> 4, ((int) box.field_1321) >> 4) && isChunkLoaded(world, ((int) box.field_1320) >> 4, ((int) box.field_1324) >> 4);
    }

    /**
     * Check if it's currently day inn the world.
     *
     * @param world the world to check.
     * @return true if so.
     */
    public static boolean isPastTime(final class_1937 world, final int pastTime) {
        return world.method_8532() % 24000 <= pastTime;
    }


    /**
     * Check if a world has a specific dimension type.
     *
     * @param world the world to check.
     * @param type  the type to compare.
     * @return true if it matches.
     */
    public static boolean isOfWorldType(@NotNull final class_1937 world, @NotNull final class_5321<class_2874> type) {
        class_5455 dynRegistries = world.method_30349();
        class_2960 loc = dynRegistries.method_33310(class_7924.field_41241).get().method_10221(world.method_8597());
        if (loc == null) {
            if (world.field_9236) {
                return world.method_8597().comp_655().equals(type.method_29177());
            }
            return false;
        }
        class_5321<class_2874> regKey = class_5321.method_29179(class_7924.field_41241, loc);
        return regKey == type;
    }

    /**
     * Check to see if the world is peaceful.
     * <p>
     * There are several checks performed here, currently both gamerule and difficulty.
     *
     * @param world world to check
     * @return true if peaceful
     */
    public static boolean isPeaceful(@NotNull final class_1937 world) {
        return !world.method_8401().method_146().method_8355(class_1928.field_19390) || world.method_8407().equals(class_1267.field_5801);
    }

}