package com.hollingsworth.nuggets.client.gui.radial;

import com.hollingsworth.nuggets.mixin.KeyMappingAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_744;
import net.minecraft.class_757;
import net.minecraft.class_918;

public class GuiRadialMenu<T> extends class_437 {
    private static final float PRECISION = 5.0f;
    private static final int MAX_SLOTS = 20;

    private boolean closing;
    private RadialMenu<T> radialMenu;
    private List<RadialMenuSlot<T>> radialMenuSlots;
    final float OPEN_ANIMATION_LENGTH = 0.40f;
    private float totalTime;
    private float prevTick;
    private float extraTick;
    /**
     * Zero-Based index
     */
    private int selectedItem;
    public class_918 itemRenderer;

    public GuiRadialMenu(RadialMenu<T> radialMenu) {
        super(class_2561.method_43470(""));
        this.radialMenu = radialMenu;
        this.radialMenuSlots = this.radialMenu.getRadialMenuSlots();
        this.closing = false;
        this.field_22787 = class_310.method_1551();
        this.selectedItem = -1;
        itemRenderer = class_310.method_1551().method_1480();
    }

    public static void updateInputEvent(class_744 eInput) {
        if (class_310.method_1551().field_1755 instanceof GuiRadialMenu) {

            class_315 settings = class_310.method_1551().field_1690;
            long window = class_310.method_1551().method_22683().method_4490();
            eInput.field_3910 = class_3675.method_15987(window, ((KeyMappingAccessor)settings.field_1894).getKey().method_1444());
            eInput.field_3909 = class_3675.method_15987(window, ((KeyMappingAccessor)settings.field_1881).getKey().method_1444());
            eInput.field_3908 = class_3675.method_15987(window, ((KeyMappingAccessor)settings.field_1913).getKey().method_1444());
            eInput.field_3906 = class_3675.method_15987(window, ((KeyMappingAccessor)settings.field_1849).getKey().method_1444());

            eInput.field_3905 = eInput.field_3910 == eInput.field_3909 ? 0.0F : (eInput.field_3910 ? 1.0F : -1.0F);
            eInput.field_3907 = eInput.field_3908 == eInput.field_3906 ? 0.0F : (eInput.field_3908 ? 1.0F : -1.0F);
            eInput.field_3904 = class_3675.method_15987(window, ((KeyMappingAccessor)settings.field_1903).getKey().method_1444());
            eInput.field_3903 = class_3675.method_15987(window, ((KeyMappingAccessor)settings.field_1832).getKey().method_1444());
            if (class_310.method_1551().field_1724.method_20303()) {
                eInput.field_3907 = (float) ((double) eInput.field_3907 * 0.3D);
                eInput.field_3905 = (float) ((double) eInput.field_3905 * 0.3D);
            }
        }
    }

    @Override
    public void method_25393() {
        if (totalTime != OPEN_ANIMATION_LENGTH){
            extraTick++;
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        class_4587 ms = graphics.method_51448();
        float openAnimation = closing ? 1.0f - totalTime / OPEN_ANIMATION_LENGTH : totalTime / OPEN_ANIMATION_LENGTH;

        float currTick = field_22787.method_47600();
        totalTime += (currTick + extraTick - prevTick)/20f;
        extraTick = 0;
        prevTick = currTick;


        float animProgress = class_3532.method_15363(openAnimation, 0, 1);
        animProgress = (float) (1 - Math.pow(1 - animProgress, 3));
        float radiusIn = Math.max(0.1f, 45 * animProgress);
        float radiusOut = radiusIn * 2;
        float itemRadius = (radiusIn + radiusOut) * 0.5f;

        int centerOfScreenX = field_22789 / 2;
        int centerOfScreenY = field_22790 / 2;
        int numberOfSlices = Math.min(MAX_SLOTS, radialMenuSlots.size());

        double mousePositionInDegreesInRelationToCenterOfScreen = Math.toDegrees(Math.atan2(mouseY - centerOfScreenY, mouseX - centerOfScreenX));
        double mouseDistanceToCenterOfScreen = Math.sqrt(Math.pow(mouseX - centerOfScreenX, 2) + Math.pow(mouseY - centerOfScreenY, 2));
        float slot0 = (((0 - 0.5f) / (float) numberOfSlices) + 0.25f) * 360;
        if (mousePositionInDegreesInRelationToCenterOfScreen < slot0) {
            mousePositionInDegreesInRelationToCenterOfScreen += 360;
        }

        ms.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);


        class_287 tessellator = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        boolean hasMouseOver = false;
        int mousedOverSlot = -1;

        if (!closing) {
            selectedItem = -1;
            for (int i = 0; i < numberOfSlices; i++) {
                float sliceBorderLeft = (((i - 0.5f) / (float) numberOfSlices) + 0.25f) * 360;
                float sliceBorderRight = (((i + 0.5f) / (float) numberOfSlices) + 0.25f) * 360;
                if (mousePositionInDegreesInRelationToCenterOfScreen >= sliceBorderLeft && mousePositionInDegreesInRelationToCenterOfScreen < sliceBorderRight && mouseDistanceToCenterOfScreen >= radiusIn && mouseDistanceToCenterOfScreen < radiusOut) {
                    selectedItem = i;
                    break;
                }
            }
        }


        for (int i = 0; i < numberOfSlices; i++) {
            float sliceBorderLeft = (((i - 0.5f) / (float) numberOfSlices) + 0.25f) * 360;
            float sliceBorderRight = (((i + 0.5f) / (float) numberOfSlices) + 0.25f) * 360;
            if (selectedItem == i) {
                drawSlice(tessellator, centerOfScreenX, centerOfScreenY, 10, radiusIn, radiusOut, sliceBorderLeft, sliceBorderRight, 63, 161, 191, 60);
                hasMouseOver = true;
                mousedOverSlot = selectedItem;
            } else
                drawSlice(tessellator, centerOfScreenX, centerOfScreenY, 10, radiusIn, radiusOut, sliceBorderLeft, sliceBorderRight, 0, 0, 0, 64);
        }

        class_286.method_43433(tessellator.method_60800());
        RenderSystem.disableBlend();
        if (hasMouseOver && mousedOverSlot != -1) {
            int adjusted = ((mousedOverSlot + (numberOfSlices / 2 + 1)) % numberOfSlices) - 1;
            adjusted = adjusted == -1 ? numberOfSlices - 1 : adjusted;
            graphics.method_25300(field_22793, radialMenuSlots.get(adjusted).slotName(), field_22789 / 2, (field_22790 - field_22793.field_2000) / 2, 16777215);
        }

        ms.method_22909();
        for (int i = 0; i < numberOfSlices; i++) {
            class_1799 stack = new class_1799(class_2246.field_10566);
            float angle1 = ((i / (float) numberOfSlices) - 0.25f) * 2 * (float) Math.PI;
            if (numberOfSlices % 2 != 0) {
                angle1 += Math.PI / numberOfSlices;
            }
            float posX = centerOfScreenX - 8 + itemRadius * (float) Math.cos(angle1);
            float posY = centerOfScreenY - 8 + itemRadius * (float) Math.sin(angle1);
            RenderSystem.disableDepthTest();

//            graphics.renderItem(new ItemStack(Items.DIAMOND_PICKAXE), (int) posX, (int) posY);
            T primarySlotIcon = radialMenuSlots.get(i).primarySlotIcon();
            List<T> secondarySlotIcons = radialMenuSlots.get(i).secondarySlotIcons();
            if (primarySlotIcon != null) {
                radialMenu.drawIcon(primarySlotIcon, graphics, (int) posX, (int) posY, 16);
                if (secondarySlotIcons != null && !secondarySlotIcons.isEmpty()) {
                    drawSecondaryIcons(graphics, (int) posX, (int) posY, secondarySlotIcons);
                }
            }
            ms.method_22903();
            ms.method_46416(0, 0, 9999);
            drawSliceName(graphics, String.valueOf(i + 1), stack, (int) posX, (int) posY);
            ms.method_22909();
        }

        if (mousedOverSlot != -1) {
            int adjusted = ((mousedOverSlot + (numberOfSlices / 2 + 1)) % numberOfSlices) - 1;
            adjusted = adjusted == -1 ? numberOfSlices - 1 : adjusted;
            selectedItem = adjusted;
        }
    }

    public void drawSecondaryIcons(class_332 ms, int positionXOfPrimaryIcon, int positionYOfPrimaryIcon, List<T> secondarySlotIcons) {
        if (!radialMenu.isShowMoreSecondaryItems()) {
            drawSecondaryIcon(ms, secondarySlotIcons.get(0), positionXOfPrimaryIcon, positionYOfPrimaryIcon, radialMenu.getSecondaryIconStartingPosition());
        } else {
            SecondaryIconPosition currentSecondaryIconPosition = radialMenu.getSecondaryIconStartingPosition();
            for (T secondarySlotIcon : secondarySlotIcons) {
                drawSecondaryIcon(ms, secondarySlotIcon, positionXOfPrimaryIcon, positionYOfPrimaryIcon, currentSecondaryIconPosition);
                currentSecondaryIconPosition = SecondaryIconPosition.getNextPositon(currentSecondaryIconPosition);
            }
        }
    }

    public void drawSecondaryIcon(class_332 poseStack, T item, int positionXOfPrimaryIcon, int positionYOfPrimaryIcon, SecondaryIconPosition secondaryIconPosition) {
        int offset = radialMenu.getOffset();
        switch (secondaryIconPosition) {
            case NORTH ->
                    radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon + offset, positionYOfPrimaryIcon - 14 + offset, 10);
            case EAST ->
                    radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon + 14 + offset, positionYOfPrimaryIcon + offset, 10);
            case SOUTH ->
                    radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon + offset, positionYOfPrimaryIcon + 14 + offset, 10);
            case WEST ->
                    radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon - 14 + offset, positionYOfPrimaryIcon + offset, 10);
        }
    }

    public void drawSliceName(class_332 graphics, String sliceName, class_1799 stack, int posX, int posY) {
        if (!radialMenu.isShowMoreSecondaryItems()) {
            graphics.method_51432(field_22793, stack, posX + 5, posY, sliceName);
        } else {
            graphics.method_51432(field_22793, stack, posX + 5, posY + 5, sliceName);
        }
    }

    @Override
    public boolean method_25404(int key, int scanCode, int modifiers) {
        int adjustedKey = key - 48;
        if (adjustedKey >= 0 && adjustedKey < radialMenuSlots.size()) {
            selectedItem = adjustedKey == 0 ? radialMenuSlots.size() : adjustedKey;
            selectedItem = selectedItem - 1; // Offset by 1 because 0 based indexing but users see 1 indexed
            method_25402(0, 0, 0);
            return true;
        }
        return super.method_25404(key, scanCode, modifiers);
    }

    @Override
    public boolean method_25402(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.selectedItem != -1) {
            radialMenu.setCurrentSlot(selectedItem);
            field_22787.field_1724.method_7346();
        }
        return true;
    }

    public void drawSlice(
            class_287 buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, class_3532.method_15386(angle / PRECISION));

        startAngle = (float) Math.toRadians(startAngle);
        endAngle = (float) Math.toRadians(endAngle);
        angle = endAngle - startAngle;

        for (int i = 0; i < sections; i++) {
            float angle1 = startAngle + (i / (float) sections) * angle;
            float angle2 = startAngle + ((i + 1) / (float) sections) * angle;

            float pos1InX = x + radiusIn * (float) Math.cos(angle1);
            float pos1InY = y + radiusIn * (float) Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float) Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float) Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float) Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float) Math.sin(angle2);
            float pos2InX = x + radiusIn * (float) Math.cos(angle2);
            float pos2InY = y + radiusIn * (float) Math.sin(angle2);

            buffer.method_22912(pos1OutX, pos1OutY, z).method_1336(r, g, b, a);
            buffer.method_22912(pos1InX, pos1InY, z).method_1336(r, g, b, a);
            buffer.method_22912(pos2InX, pos2InY, z).method_1336(r, g, b, a);
            buffer.method_22912(pos2OutX, pos2OutY, z).method_1336(r, g, b, a);
        }
    }

    @Override
    public boolean method_25421() {
        return false;
    }
}

/*
Note: This code has been modified from David Quintana's solution.
Below is the required copyright notice.
Copyright (c) 2015, David Quintana <gigaherz@gmail.com>
All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the author nor the
      names of the contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/