package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.rendering.StatePos;
import com.hollingsworth.nuggets.mixin.StructureTemplateAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_3341;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3499.class_5162;

public class StructureRenderData {
    public List<StatePos> statePosCache;
    public class_2338 anchorPos;
    public class_2338 lastRenderPos;
    public double distanceFromCameraCast = 25;
    public class_3499 structureTemplate;
    public class_2470 rotation = class_2470.field_11467;
    public class_2415 mirror = class_2415.field_11302;
    public boolean flipped = false;
    public class_3341 boundingBox;
    public class_3492 structurePlaceSettings;

    public StructureRenderData(class_3499 template){
        this.structureTemplate = template;
        var accessor = (StructureTemplateAccessor)template;
        var palettes = accessor.getPalettes();
        if(palettes.isEmpty()){
            return;
        }
        var palette = palettes.get(0);
        statePosCache = new ArrayList<>();
        for(class_3499.class_3501 blockInfo : palette.method_27125()){
            statePosCache.add(new StatePos(blockInfo.comp_1342(), blockInfo.comp_1341()));
        }
        structurePlaceSettings = new class_3492();
        boundingBox = structureTemplate.method_16187(structurePlaceSettings, new class_2338(0, 0, 0));
    }

    public void rotate(class_2470 rotateBy){
        rotation = rotation.method_10501(rotateBy);
        statePosCache = StatePos.rotate(statePosCache, new ArrayList<>(), rotateBy);
        boundingBox = structureTemplate.method_16187(structurePlaceSettings.method_15123(rotation), new class_2338(0, 0, 0));
    }

    public void mirror(boolean mirror){
        this.mirror = mirror ? class_2415.field_11301 : class_2415.field_11302;

        boundingBox = structureTemplate.method_16187(structurePlaceSettings.method_15125(this.mirror), new class_2338(0, 0, 0));
    }

    public void flip(){
        flipped = !flipped;
        this.mirror(flipped);
    }

}
