/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.nuggets.common.registry.RegistryHelper;
import com.hollingsworth.nuggets.datagen.SimpleDataProvider;
import com.hollingsworth.nuggets.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.nuggets.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.nuggets.datagen.patchouli.PatchouliRecord;
import com.hollingsworth.nuggets.datagen.patchouli.TextPage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1935;
import net.minecraft.class_2403;
import net.minecraft.class_2960;
import net.minecraft.class_7403;

public abstract class PatchouliProvider
extends SimpleDataProvider {
    public List<PatchouliRecord> pages = new ArrayList<PatchouliRecord>();
    public String modId;
    public String bookName;

    public PatchouliProvider(String modId, String bookName, class_2403 generatorIn, Path outputPath) {
        super(generatorIn, outputPath);
        this.modId = modId;
    }

    public abstract void addEntries(List<PatchouliRecord> var1);

    public String getLangPath(String name, int count) {
        return this.modId + ".page" + count + "." + name;
    }

    public String getLangPath(String name) {
        return this.modId + ".page." + name;
    }

    public PatchouliRecord addPage(PatchouliBuilder builder, Path path) {
        return this.addPage(new PatchouliRecord(builder, path));
    }

    public PatchouliRecord addPage(PatchouliRecord patchouliPage) {
        this.pages.add(patchouliPage);
        return patchouliPage;
    }

    public PatchouliBuilder buildBasicItem(class_1935 item, class_2960 category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = new PatchouliBuilder(category, item.method_8389().method_7876()).withIcon((class_1935)item.method_8389()).withPage(new TextPage("ars_nouveau.page." + RegistryHelper.getRegistryName(item.method_8389()).method_12832()));
        if (recipePage != null) {
            builder.withPage(recipePage);
        }
        return builder;
    }

    public PatchouliRecord addBasicItem(class_1935 item, class_2960 category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = this.buildBasicItem(item, category, recipePage);
        return this.addPage(new PatchouliRecord(builder, this.getPath(category, RegistryHelper.getRegistryName(item.method_8389()))));
    }

    public Path getPath(class_2960 category, class_2960 fileName) {
        return this.output.resolve("assets/" + this.modId + "/patchouli_books/" + this.bookName + "/en_us/entries/" + category.method_12832() + "/" + fileName.method_12832() + ".json");
    }

    public Path getPath(class_2960 category, String fileName) {
        return this.output.resolve("assets/" + this.modId + "/patchouli_books/" + this.bookName + "/en_us/entries/" + category.method_12832() + "/" + fileName + ".json");
    }

    @Override
    public void collectJsons(class_7403 pOutput) {
        this.addEntries(this.pages);
        for (PatchouliRecord patchouliPage : this.pages) {
            this.saveStable(pOutput, (JsonElement)patchouliPage.build(), patchouliPage.path());
        }
    }

    public String method_10321() {
        return "Patchouli";
    }
}

