/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.overlay;

import com.hollingsworth.nuggets.client.Color;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.client.overlay.ITooltipConsumer;
import com.hollingsworth.nuggets.client.overlay.IWorldTooltipProvider;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_9779;
import net.minecraft.class_9799;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class InWorldTooltip {
    public static class_4597.class_4598 renderType = class_4597.method_22991((class_9799)new class_9799(1536));
    public static int hoverTicks = 0;
    public static Object lastHovered = null;
    public static Map<class_1299<?>, List<ITooltipConsumer>> ENTITY_CALLBACKS = new ConcurrentHashMap();
    public static final Color VANILLA_TOOLTIP_BORDER_1 = new Color(0x505000FF, true);
    public static final Color VANILLA_TOOLTIP_BORDER_2 = new Color(1344798847, true);
    public static final Color VANILLA_TOOLTIP_BACKGROUND = new Color(-267386864, true);

    public static void registerEntityCallback(class_1299<?> type, ITooltipConsumer callback) {
        ENTITY_CALLBACKS.computeIfAbsent(type, k -> new ArrayList()).add(callback);
    }

    public static void renderOverlay(class_332 graphics, class_9779 tracker) {
        class_4587 poseStack = graphics.method_51448();
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        int xOffset = 20;
        int yOffset = 0;
        class_239 objectMouseOver = mc.field_1765;
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        class_2338 hovering = null;
        if (objectMouseOver instanceof class_3965) {
            class_3965 hitResult = (class_3965)objectMouseOver;
            hovering = hitResult.method_17777();
            var12_11 = mc.field_1687.method_8321(hitResult.method_17777());
            if (var12_11 instanceof IWorldTooltipProvider) {
                IWorldTooltipProvider iWorldTooltipProvider = (IWorldTooltipProvider)var12_11;
                iWorldTooltipProvider.getTooltip(tooltip);
            }
        } else if (objectMouseOver instanceof class_3966) {
            List<ITooltipConsumer> list;
            class_3966 result = (class_3966)objectMouseOver;
            var12_11 = result.method_17782();
            if (var12_11 instanceof IWorldTooltipProvider) {
                IWorldTooltipProvider iWorldTooltipProvider = (IWorldTooltipProvider)var12_11;
                iWorldTooltipProvider.getTooltip(tooltip);
            }
            if ((list = ENTITY_CALLBACKS.get(result.method_17782().method_5864())) != null) {
                for (ITooltipConsumer consumer : list) {
                    consumer.accept(result, tooltip);
                }
            }
            hovering = result.method_17782();
        }
        if (hovering == null || lastHovered != null && !lastHovered.equals(hovering)) {
            lastHovered = null;
            hoverTicks = 0;
        }
        hoverTicks = lastHovered == null || lastHovered.equals(hovering) ? ++hoverTicks : 0;
        lastHovered = hovering;
        if (tooltip.isEmpty()) {
            return;
        }
        poseStack.method_22903();
        int tooltipTextWidth = 0;
        for (class_5348 class_53482 : tooltip) {
            int textLineWidth = mc.field_1772.method_27525(class_53482);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        int n = class_310.method_1551().method_22683().method_4486();
        int height = class_310.method_1551().method_22683().method_4502();
        int posX = n / 2 + xOffset;
        int posY = height / 2 + yOffset;
        posX = Math.min(posX, n - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);
        float fade = class_3532.method_15363((float)(((float)hoverTicks + tracker.method_60636()) / 12.0f), (float)0.0f, (float)1.0f);
        Color colorBackground = VANILLA_TOOLTIP_BACKGROUND.scaleAlpha(0.75f);
        Color colorBorderTop = VANILLA_TOOLTIP_BORDER_1;
        Color colorBorderBot = VANILLA_TOOLTIP_BORDER_2;
        if (fade < 1.0f) {
            poseStack.method_46416((1.0f - fade) * Math.signum((float)xOffset + 0.5f) * 4.0f, 0.0f, 0.0f);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        InWorldTooltip.drawHoveringText(class_1799.field_8037, graphics, tooltip, posX, posY, n, height, -1, colorBackground.getRGB(), colorBorderTop.getRGB(), colorBorderBot.getRGB(), mc.field_1772);
        poseStack.method_22909();
    }

    public static void drawHoveringText(@NotNull class_1799 stack, class_332 graphics, List<? extends class_5348> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, class_327 font) {
        int n;
        if (textLines.isEmpty()) {
            return;
        }
        class_4587 pStack = graphics.method_51448();
        List<class_5684> list = GuiHelpers.gatherTooltipComponents(textLines, stack.method_32347(), mouseX, screenWidth, screenHeight, font);
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;
        for (class_5348 class_53482 : textLines) {
            int textLineWidth = font.method_27525(class_53482);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends class_5348> wrappedTextLines = new ArrayList<class_5348>();
            for (int i = 0; i < textLines.size(); ++i) {
                class_5348 textLine = textLines.get(i);
                List wrappedLine = font.method_27527().method_27495(textLine, tooltipTextWidth, class_2583.field_24360);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (class_5348 line : wrappedLine) {
                    int lineWidth = font.method_27525(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((class_5348)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int zLevel = 400;
        pStack.method_22903();
        Matrix4f mat = pStack.method_23760().method_23761();
        graphics.method_25296(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
        graphics.method_25296(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
        graphics.method_25296(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        graphics.method_25296(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        graphics.method_25296(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        graphics.method_25296(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        graphics.method_25296(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        graphics.method_25296(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        graphics.method_25296(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        pStack.method_22904(0.0, 0.0, 400.0);
        for (int lineNumber = 0; lineNumber < list.size(); ++lineNumber) {
            class_5684 line = list.get(lineNumber);
            if (line != null) {
                line.method_32665(font, tooltipX, tooltipY, mat, renderType);
            }
            if (lineNumber + 1 == n) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.method_22993();
        pStack.method_22909();
        RenderSystem.enableDepthTest();
    }
}

