/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.gui;

import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.client.gui.ITooltipRenderer;
import com.hollingsworth.nuggets.client.gui.NestedWidgets;
import com.hollingsworth.nuggets.mixin.ScreenAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5632;

public class BaseScreen
extends class_437 {
    public int maxScale;
    public float scaleFactor;
    public int screenLeft;
    public int screenTop;
    public int screenRight;
    public int screenBottom;
    public int fullWidth;
    public int fullHeight;
    public class_2960 background;
    protected Map<NestedWidgets, List<class_339>> nestedWidgetMap = new Reference2ObjectOpenHashMap();

    public BaseScreen(class_2561 titleIn, int fullWidth, int fullHeight, class_2960 background) {
        super(titleIn);
        this.fullHeight = fullHeight;
        this.fullWidth = fullWidth;
        this.background = background;
    }

    public void method_25426() {
        super.method_25426();
        this.maxScale = this.getMaxAllowedScale();
        this.scaleFactor = 1.0f;
        this.screenLeft = this.field_22789 / 2 - this.fullWidth / 2;
        this.screenTop = this.field_22790 / 2 - this.fullHeight / 2;
        this.screenRight = this.field_22789 / 2 + this.fullWidth / 2;
        this.screenBottom = this.field_22790 / 2 + this.fullHeight / 2;
    }

    public void drawTooltip(class_332 stack, int mouseX, int mouseY) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        this.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (!tooltip.isEmpty()) {
            stack.method_51437(this.field_22793, tooltip, Optional.ofNullable(this.getClientImageTooltip(mouseX, mouseY)), mouseX, mouseY);
        }
    }

    public void collectTooltips(class_332 stack, int mouseX, int mouseY, List<class_2561> tooltip) {
        for (class_4068 renderable : this.renderablesList()) {
            if (!(renderable instanceof class_339)) continue;
            class_339 widget = (class_339)renderable;
            if (!(renderable instanceof ITooltipRenderer)) continue;
            ITooltipRenderer tooltipProvider = (ITooltipRenderer)renderable;
            if (!GuiHelpers.isMouseInRelativeRange(mouseX, mouseY, widget) || !widget.field_22764) continue;
            tooltipProvider.gatherTooltips(stack, mouseX, mouseY, tooltip);
        }
    }

    protected class_5632 getClientImageTooltip(int mouseX, int mouseY) {
        return null;
    }

    public void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawScreenAfterScale(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)this.screenLeft, (float)this.screenTop, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        this.drawForegroundElements(mouseX, mouseY, partialTicks);
        poseStack.method_22909();
        for (class_4068 renderable : this.renderablesList()) {
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        this.drawTooltip(graphics, mouseX, mouseY);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrixStack = graphics.method_51448();
        matrixStack.method_22903();
        if (this.scaleFactor != 1.0f) {
            matrixStack.method_22905(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(graphics, mouseX, mouseY, partialTicks);
        matrixStack.method_22909();
    }

    public void drawBackgroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25290(this.background, 0, 0, 0.0f, 0.0f, this.fullWidth, this.fullHeight, this.fullWidth, this.fullHeight);
    }

    public boolean method_25421() {
        return false;
    }

    private int getMaxAllowedScale() {
        return this.field_22787.method_22683().method_4476(0, this.field_22787.method_1573());
    }

    protected void method_57734(float pPartialTick) {
    }

    public List<class_4068> renderablesList() {
        return ((ScreenAccessor)((Object)this)).getRenderables();
    }

    protected <T extends class_364 & class_4068> T method_37063(T widget) {
        ArrayList<class_339> afterParent = new ArrayList<class_339>();
        ArrayList<class_339> beforeParent = new ArrayList<class_339>();
        if (widget instanceof NestedWidgets) {
            NestedWidgets nestedRenderables = (NestedWidgets)widget;
            nestedRenderables.addBeforeParent(beforeParent);
            for (class_339 renderable : beforeParent) {
                super.method_37063((class_364)renderable);
            }
            nestedRenderables.addAfterParent(afterParent);
            ArrayList<class_339> allWidgets = new ArrayList<class_339>();
            allWidgets.addAll(afterParent);
            allWidgets.addAll(beforeParent);
            this.nestedWidgetMap.put(nestedRenderables, allWidgets);
        }
        class_364 added = super.method_37063(widget);
        for (class_339 renderable : afterParent) {
            super.method_37063((class_364)renderable);
        }
        return (T)added;
    }

    protected void method_37066(class_364 pListener) {
        if (pListener instanceof NestedWidgets) {
            NestedWidgets nestedWidgets = (NestedWidgets)pListener;
            List<class_339> children = this.nestedWidgetMap.get(nestedWidgets);
            if (children != null) {
                for (class_339 renderable : children) {
                    if (renderable == null) continue;
                    super.method_37066((class_364)renderable);
                }
            }
            this.nestedWidgetMap.remove(nestedWidgets);
        }
        super.method_37066(pListener);
    }
}

