package com.hollingsworth.nuggets.common.util;

import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import java.util.function.BiPredicate;

public class BlockPosHelpers {


    /**
     * Selects a solid position with air above
     */
    public static final BiPredicate<class_1922, class_2338> TWO_HIGH_AIR_POS_SELECTOR = (world, pos) -> {
        return (world.method_8320(pos).method_26225() || world.method_8320(pos).method_51176()) && world.method_8320(
                pos.method_10084()).method_26215() && world.method_8320(pos.method_10086(2)).method_26215();
    };

    /**
     * Finds a spawnpoint randomly in a circular shape around the center Advances
     *
     * @param start      the center of the area to search for a spawn point
     * @param advancePos The position we advance towards
     * @return the calculated position
     */
    private static class_2338 findSpawnPointInDirections(
            class_1937 level,
            final class_2338 start,
            final class_2338 advancePos) {
        class_2338 spawnPos = new class_2338(start);
        class_243 tempPos = new class_243(spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260());

        final int xDiff = Math.abs(start.method_10263() - advancePos.method_10263());
        final int zDiff = Math.abs(start.method_10260() - advancePos.method_10260());

        class_243 xzRatio = new class_243(xDiff * (start.method_10263() < advancePos.method_10263() ? 1 : -1), 0, zDiff * (start.method_10260() < advancePos.method_10260() ? 1 : -1));
        // Reduce ratio to 3 chunks a step
        xzRatio = xzRatio.method_1029().method_1021(3);

        int validChunkCount = 0;
        for (int i = 0; i < 10; i++) {
            if (level.method_8477(class_2338.method_49638(tempPos))) {
                tempPos = tempPos.method_1031(16 * xzRatio.field_1352, 0, 16 * xzRatio.field_1350);

                if (level.method_8477(class_2338.method_49638(tempPos))) {
                    spawnPos = class_2338.method_49638(tempPos);
                    validChunkCount++;
                    if (validChunkCount > 5) {
                        return spawnPos;
                    }
                } else {
                    break;
                }
            } else {
                break;
            }
        }

        if (!spawnPos.equals(start)) {
            return spawnPos;
        }

        return null;
    }

    public static class_2338 getRandomSpawn(class_2338 calcCenter, class_1937 level) {

        // Get a random point on a circle around the colony,far out for the direction
        final int degree = level.field_9229.method_43048(360);
        int x = (int) Math.round(20 * Math.cos(Math.toRadians(degree)));
        int z = (int) Math.round(20 * Math.sin(Math.toRadians(degree)));
        final class_2338 advanceTowards = calcCenter.method_10069(x, 0, z);

        class_2338 spawnPos = null;

        // 8 Tries
        for (int i = 0; i < 8; i++) {
            spawnPos = findSpawnPointInDirections(level, new class_2338(calcCenter.method_10263(), calcCenter.method_10264(), calcCenter.method_10260()), advanceTowards);
            if (spawnPos != null) {
                break;
            }
        }

        if (spawnPos == null) {
            return null;
        }


        return findAround(level, getFloor(spawnPos, level), 3, 30, TWO_HIGH_AIR_POS_SELECTOR);
    }


    /**
     * Calculates the floor level.
     *
     * @param position input position.
     * @param world    the world the position is in.
     * @return returns BlockPos position with air above.
     */
    @NotNull
    public static class_2338 getFloor(@NotNull final class_2338 position, @NotNull final class_1937 world) {
        final class_2338 floor = getFloor(new class_2338.class_2339(position.method_10263(), position.method_10264(), position.method_10260()), 0, world);
        if (floor == null) {
            return position;
        }
        return floor;
    }


    /**
     * Calculates the floor level.
     *
     * @param position input position.
     * @param depth    the iteration depth.
     * @param world    the world the position is in.
     * @return returns BlockPos position with air above.
     */
    @Nullable
    public static class_2338 getFloor(class_2338.class_2339 position, int depth, @NotNull final class_1937 world) {
        //If the position is floating in Air go downwards
        if (!solidOrLiquid(world, position)) {
            return getFloor(position.method_10103(position.method_10263(), position.method_10264() - 1, position.method_10260()), depth + 1, world);
        }
        //If there is no air above the block go upwards
        if (!solidOrLiquid(world, position.method_10103(position.method_10263(), position.method_10264() + 1, position.method_10260())) &&
                !solidOrLiquid(world, position.method_10103(position.method_10263(), position.method_10264() + 2, position.method_10260()))) {
            return position.method_10062();
        }
        return getFloor(position.method_10103(position.method_10263(), position.method_10264() + 1, position.method_10260()), depth + 1, world);
    }

    /**
     * Checks if a blockPos in a world is solid or liquid.
     * <p>
     * Useful to find a suitable Place to stand. (avoid these blocks to find one)
     *
     * @param world    the world to look in
     * @param blockPos the blocks position
     * @return true if solid or liquid
     */
    public static boolean solidOrLiquid(@NotNull final class_1937 world, @NotNull final class_2338 blockPos)
    {
        var state = world.method_8320(blockPos);
        return state.method_26215() || state.method_51176();
    }


    /**
     * Returns the first air position near the given start. Advances vertically first then horizontally
     *
     * @param start           start position
     * @param horizontalRange horizontal search range
     * @param verticalRange   vertical search range
     * @param predicate       check predicate for the right block
     * @return position or null
     */
    public static class_2338 findAround(final class_1937 world, final class_2338 start, final int verticalRange, final int horizontalRange, final BiPredicate<class_1922, class_2338> predicate) {
        if (horizontalRange < 1 && verticalRange < 1) {
            return null;
        }

        if (predicate.test(world, start)) {
            return start;
        }

        class_2338 temp;
        int y = 0;
        int y_offset = 1;

        for (int i = 0; i < verticalRange + 2; i++) {
            for (int steps = 1; steps <= horizontalRange; steps++) {
                // Start topleft of middle point
                temp = start.method_10069(-steps, y, -steps);

                // X ->
                for (int x = 0; x <= steps; x++) {
                    temp = temp.method_10069(1, 0, 0);
                    if (predicate.test(world, temp)) {
                        return temp;
                    }
                }

                // X
                // |
                // v
                for (int z = 0; z <= steps; z++) {
                    temp = temp.method_10069(0, 0, 1);
                    if (predicate.test(world, temp)) {
                        return temp;
                    }
                }

                // < - X
                for (int x = 0; x <= steps; x++) {
                    temp = temp.method_10069(-1, 0, 0);
                    if (predicate.test(world, temp)) {
                        return temp;
                    }
                }

                // ^
                // |
                // X
                for (int z = 0; z <= steps; z++) {
                    temp = temp.method_10069(0, 0, -1);
                    if (predicate.test(world, temp)) {
                        return temp;
                    }
                }
            }

            y += y_offset;
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            y_offset *= -1;

            if (!isInWorldHeight(start.method_10264() + y, world)) {
                return null;
            }
        }

        return null;
    }

    /**
     * Check if a given block y is within world bounds
     *
     * @param yBlock
     * @param world
     * @return
     */
    public static boolean isInWorldHeight(final int yBlock, final class_1937 world)
    {
        final class_2874 dimensionType = world.method_8597();
        return yBlock > getDimensionMinHeight(dimensionType) && yBlock < getDimensionMaxHeight(dimensionType);
    }


    /**
     * Returns a dimensions max height
     *
     * @param dimensionType
     * @return
     */
    public static int getDimensionMaxHeight(final class_2874 dimensionType)
    {
        return dimensionType.comp_653() + dimensionType.comp_651();
    }

    /**
     * Returns a dimension min height
     *
     * @param dimensionType
     * @return
     */
    public static int getDimensionMinHeight(final class_2874 dimensionType)
    {
        return dimensionType.comp_651();
    }

    public static double distanceBetween(class_2338 blockPos, class_2338 blockPos2) {
        return Math.sqrt(Math.pow(blockPos.method_10263() - blockPos2.method_10263(), 2) + Math.pow(blockPos.method_10264() - blockPos2.method_10264(), 2) + Math.pow(blockPos.method_10260() - blockPos2.method_10260(), 2));
    }
}
