package com.hollingsworth.nuggets.client.gui;

import com.hollingsworth.nuggets.client.BlitInfo;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class NuggetImageButton extends BaseButton {

    public class_2960 image;
    public class_2960 hoveredImage;
    public int u, v, image_width, image_height;
    public boolean soundDisabled = false;
    public int xOffset, yOffset;

    public NuggetImageButton(int x, int y, BlitInfo blitInfo, class_4185.class_4241 onPress) {
        this(x, y, 0, 0, blitInfo.width(), blitInfo.height(), blitInfo.width(), blitInfo.height(), blitInfo.location(), onPress);
        this.xOffset = blitInfo.xOffset();
        this.yOffset = blitInfo.yOffset();
    }

    public NuggetImageButton(int x, int y, int w, int h, class_2960 image, class_4185.class_4241 onPress) {
        this(x, y, 0, 0, w, h, w, h, image, onPress);
    }

    public NuggetImageButton(int x, int y, int w, int h, class_2960 image, class_2960 hoveredImage, class_4185.class_4241 onPress) {
        this(x, y, 0, 0, w, h, w, h, image, hoveredImage, onPress);
    }

    public NuggetImageButton(int x, int y, int u, int v, int w, int h, int image_width, int image_height, class_2960 image, class_2960 hoveredImage, class_4185.class_4241 onPress) {
        this(x, y, u, v, w, h, image_width, image_height, image, onPress);
        this.hoveredImage = hoveredImage;
    }


    public NuggetImageButton(int x, int y, int u, int v, int w, int h, int image_width, int image_height, class_2960 image, class_4185.class_4241 onPress) {
        super(x, y, w, h, class_2561.method_43473(), onPress);
        this.u = u;
        this.v = v;
        this.image_height = image_height;
        this.image_width = image_width;
        this.image = image;
        this.hoveredImage = null;
    }

    @Override
    protected void method_48579(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        class_2960 image = GuiHelpers.isMouseInRelativeRange(pMouseX, pMouseY, this) && hoveredImage != null ? hoveredImage : this.image;
        graphics.method_25290(image, method_46426() + xOffset, method_46427() + yOffset, u, v, field_22758, field_22759, image_width, image_height);
    }

    @Override
    public void method_25354(class_1144 pHandler) {
        if (soundDisabled)
            return;
        super.method_25354(pHandler);
    }
}