package com.hollingsworth.nuggets.client.gui;

import com.hollingsworth.nuggets.client.NuggetClientData;
import com.hollingsworth.nuggets.client.rendering.RenderHelpers;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5684;

public class ItemButton extends BaseButton{
    public class_1856 ingredient;
    public class_437 screen;
    public int scale = 16;

    public ItemButton(int x, int y, int w, int h, @NotNull class_2561 text, class_4241 onPress, class_1856 ingredient, class_437 screen) {
        super(x, y, w, h, text, onPress);
        this.ingredient = ingredient;
        this.screen = screen;
    }

    public ItemButton(int x, int y, int w, int h, @NotNull class_2561 text, class_4241 onPress, class_1799 stack, class_437 screen) {
        this(x, y, w, h, text, onPress, class_1856.method_8101(stack), screen);
    }

    public ItemButton withScale(int scale){
        this.scale = scale;
        return this;
    }

    @Override
    protected void method_48579(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (ingredient != null && ingredient.method_8105().length != 0) {
            class_1799 stack = ingredient.method_8105()[(NuggetClientData.ticksInGame / 20) % ingredient.method_8105().length];
            RenderHelpers.drawItemAsIcon(stack, graphics, method_46426(), method_46427(), scale, false);
        }
    }

    @Override
    public void gatherTooltips(class_332 graphics, int mouseX, int mouseY, List<class_2561> tooltip) {
        super.gatherTooltips(graphics, mouseX, mouseY, tooltip);
        if (ingredient != null && ingredient.method_8105().length != 0) {
            class_1799 stack = ingredient.method_8105()[(NuggetClientData.ticksInGame / 20) % ingredient.method_8105().length];
            class_327 font = class_310.method_1551().field_1772;
            List<class_5684> components = new ArrayList<>(GuiHelpers.gatherTooltipComponents(class_437.method_25408(class_310.method_1551(), stack), mouseX, screen.field_22789, screen.field_22790, font));
            RenderHelpers.renderTooltipInternal(graphics, components, mouseX, mouseY, screen);
        }
    }
}
