package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.common.util.RaycastHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;

public class PlaceSchematicScreen extends BaseSchematicScreen {


    public RenderStructureHandler renderStructureHandler;

    public PlaceTool placeTool;
    public RotateTool rotateTool;
    public MoveHorizontalTool moveHorizontalTool;
    public MoveVerticalTool moveVerticalTool;
    public ConfirmTool confirmTool;
    public PrintTool printTool;
    public DeleteTool deleteTool;
    public MirrorTool mirrorTool;

    public PlaceSchematicScreen(String modId, class_304 focusKey, RenderStructureHandler<?> renderStructureHandler) {
        super(modId, focusKey, class_2561.method_43470("Tool Selection"));
        this.renderStructureHandler = renderStructureHandler;

        placeTool = new PlaceTool(() -> renderStructureHandler.placingData, this, class_2960.method_60655(modId, "textures/gui/visualizer_icon_place.png"));
        rotateTool = new RotateTool(() -> renderStructureHandler.placingData,this, class_2960.method_60655(modId, "textures/gui/visualizer_icon_rotate.png"));
        moveHorizontalTool = new MoveHorizontalTool(() -> renderStructureHandler.placingData,this, class_2960.method_60655(modId, "textures/gui/visualizer_icon_horizontal.png"));
        moveVerticalTool = new MoveVerticalTool(() -> renderStructureHandler.placingData,this, class_2960.method_60655(modId, "textures/gui/visualizer_icon_vertical.png"));
        confirmTool = new ConfirmTool(this, class_2960.method_60655(modId, "textures/gui/visualizer_icon_confirm.png"));
        printTool = new PrintTool(this, class_2960.method_60655(modId, "textures/gui/visualizer_print.png"));
        deleteTool = new DeleteTool(this, class_2960.method_60655(modId, "textures/gui/visualizer_trash.png"));
        mirrorTool = new MirrorTool(() -> renderStructureHandler.placingData,this, class_2960.method_60655(modId, "textures/gui/visualizer_icon_mirror.png"));

        tools.add(placeTool);
    }

    public void setupManipulationTools(){
        tools.clear();
        tools.add(moveHorizontalTool);
        tools.add(moveVerticalTool);
        tools.add(rotateTool);
        tools.add(confirmTool);
        if(renderStructureHandler.onPrint != null) {
            tools.add(printTool);
        }
        tools.add(deleteTool);
    }

    public static class DeleteTool extends ToolType<PlaceSchematicScreen> {
        public DeleteTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super(class_2561.method_43471("nuggets.delete_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            placeSchematicScreen.renderStructureHandler.onDelete.accept(placeSchematicScreen.renderStructureHandler);
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.delete_description"));
            return list;
        }
    }

    public static class MoveHorizontalTool extends ToolType {
        Supplier<StructureRenderData> getStructure;
        public MoveHorizontalTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super(class_2561.method_43471("nuggets.move_horizontal_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = getStructure.get();
            class_2350 direction = class_310.method_1551().field_1724.method_58149();
            class_2338 offset = new class_2338((int) delta * direction.method_10148(), 0, (int) delta * direction.method_10165());
            structureData.anchorPos = structureData.anchorPos.method_10081(offset);
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.move_horizontal_description"));
            return list;
        }
    }

    public static class MoveVerticalTool extends ToolType {
        Supplier<StructureRenderData> getStructure;
        public MoveVerticalTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super(class_2561.method_43471("nuggets.move_vertical_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = getStructure.get();
            if(structureData == null || structureData.anchorPos == null){
                return false;
            }
            structureData.anchorPos = structureData.anchorPos.method_10081(new class_2338(0, (int) delta, 0));
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.move_vertical_description"));
            return list;
        }
    }

    public static class MirrorTool extends ToolType {
        Supplier<StructureRenderData> getStructure;
        public MirrorTool(Supplier<StructureRenderData> getStructure,PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super(class_2561.method_43471("nuggets.mirror_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = getStructure.get();
            structureData.flip();
            structureData.lastRenderPos = null;
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.mirror_description"));
            return list;
        }
    }


    public static class ConfirmTool extends ToolType<PlaceSchematicScreen>{

        public ConfirmTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super(class_2561.method_43471("nuggets.confirm_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            placeSchematicScreen.renderStructureHandler.onConfirm.accept(placeSchematicScreen.renderStructureHandler);
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.confirm_description"));
            return list;
        }
    }

    public static class PrintTool extends ToolType<PlaceSchematicScreen>{
        public PrintTool(PlaceSchematicScreen placeSchematicScreen , class_2960 icon) {
            super(class_2561.method_43471("nuggets.print_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            placeSchematicScreen.renderStructureHandler.onPrint.accept(placeSchematicScreen.renderStructureHandler);
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.print_description"));
            return list;
        }
    }


    public static class RotateTool extends ToolType{
        Supplier<StructureRenderData> getStructure;
        public RotateTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super(class_2561.method_43471("nuggets.rotate_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.rotate_description"));
            return list;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = getStructure.get();
            if (structureData == null) {
                return false;
            }
            structureData.rotate(delta > 0 ? class_2470.field_11463 : class_2470.field_11465);
            structureData.lastRenderPos = null;
            return true;
        }
    }

    public static class PlaceTool extends ToolType<PlaceSchematicScreen>{
        public Supplier<StructureRenderData> getStructure;

        public PlaceTool(Supplier<StructureRenderData> getStructure, PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super(class_2561.method_43471("nuggets.place_tool"), icon, placeSchematicScreen);
            this.getStructure = getStructure;
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.place_description"));
            return list;
        }

        @Override
        public void onClick() {
            StructureRenderData structureData = getStructure.get();
            structureData.anchorPos = RaycastHelper.getLookingAt(structureData.distanceFromCameraCast, class_310.method_1551().field_1724, true).method_17777();
            placeSchematicScreen.setupManipulationTools();
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            StructureRenderData structureData = getStructure.get();
            if(structureData == null){
                return false;
            }
            if(delta > 0){
                structureData.distanceFromCameraCast += 1;
            }else{
                structureData.distanceFromCameraCast -= 1;
            }
            return true;
        }
    }
}
