package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class BaseSchematicScreen extends class_437 {
    public final String holdToFocus = "nuggets.gui.toolmenu.focusKey";
    public String modId;
    public class_304 focusKey;
    public List<ToolType> tools = new ArrayList<>();

    public boolean focused;
    protected float yOffset;
    protected int selection;
    protected boolean initialized;

    protected int w;
    protected int h;


    protected BaseSchematicScreen(String modId, class_304 focusKey, class_2561 pTitle) {
        super(pTitle);
        this.field_22787 = class_310.method_1551();
        this.modId = modId;
        this.focusKey = focusKey;
        focused = false;
        yOffset = 0;
        selection = 0;
        initialized = false;
        h = 34;
    }

    public ToolType getSelectedElement() {
        return tools.get(selection);
    }

    public void cycle(int direction) {
        selection += (direction < 0) ? 1 : -1;
        selection = (selection + tools.size()) % tools.size();
    }

    private void draw(class_332 graphics, float partialTicks) {
        final int cellW = 50;

        final int padX = 14;
        final int minW = 260;

        int count = tools.size();
        int rowW = count * cellW;

        w = Math.max(rowW + padX * 2, minW);

        class_4587 matrixStack = graphics.method_51448();
        class_1041 mainWindow = field_22787.method_22683();
        if (!initialized)
            method_25423(field_22787, mainWindow.method_4486(), mainWindow.method_4502());

        int panelX = (mainWindow.method_4486() - w) / 2;
        int y = mainWindow.method_4502() - h - 34;

        matrixStack.method_22903();
        matrixStack.method_46416(0, -yOffset, focused ? 100 : 0);

        graphics.method_25290(class_2960.method_60655(modId, "textures/gui/hud_background.png"),
                panelX - 15 + padX, y, 0, 0, w, h, 16, 16);

        float toolTipAlpha = yOffset / 10;
        List<class_2561> toolTip = tools.get(selection).getDescription();

        if (toolTipAlpha > 0.25f) {
            graphics.method_25290(class_2960.method_60655(modId, "textures/gui/hud_background.png"),
                    panelX - 15 + padX, y + 32, 0, 0, w, h, 16, 16);
            if (!toolTip.isEmpty())
                GuiHelpers.drawOutlinedText(field_22787.field_1772, graphics, toolTip.get(0), panelX + 10, y + 38);
            if (toolTip.size() > 1)
                GuiHelpers.drawOutlinedText(field_22787.field_1772, graphics, toolTip.get(1), panelX + 10, y + 50);
        }

        int width = field_22787.method_22683().method_4486();
        String keyName = focusKey.method_16007().getString();
        if (!focused)
            GuiHelpers.drawCenteredOutlinedText(field_22787.field_1772, graphics, class_2561.method_43469(holdToFocus, keyName),
                    width / 2, y - 10);
        else
            GuiHelpers.drawCenteredOutlinedText(field_22787.field_1772, graphics, class_2561.method_43471("nuggets.scroll"),
                    width / 2, y - 10);

        int startX = panelX + Math.max(padX, (w - rowW) / 2);

        for (int i = 0; i < count; i++) {
            matrixStack.method_22903();

            int cellX = startX + i * cellW;

            if (i == selection) {
                matrixStack.method_46416(0, -10, 0);
                GuiHelpers.drawCenteredOutlinedText(
                        field_22787.field_1772, graphics,
                        tools.get(i).getDisplayName(),
                        cellX + 26, y + 28
                );
            }

            class_2960 icon = tools.get(i).getIcon();
            graphics.method_25290(icon, cellX + 16, y + 11, 0, 0, 16, 16, 16, 16);

            matrixStack.method_22909();
        }

        matrixStack.method_22909();
    }

    public void update() {
        if (focused)
            yOffset += (10 - yOffset) * .1f;
        else
            yOffset *= .9f;
    }

    public boolean scroll(double delta) {
        if (focused) {
            cycle((int) delta);
            return true;
        } else if (method_25441()) {
            return tools.get(selection)
                    .handleMouseWheel(delta);
        }
        return false;
    }

    public void renderPassive(class_332 graphics, float partialTicks) {
        draw(graphics, partialTicks);
    }

    @Override
    public void method_25419() {

    }

    @Override
    protected void method_25426() {
        super.method_25426();
        initialized = true;
    }

}
