/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.area_capture.RenderStructureHandler;
import com.hollingsworth.nuggets.client.area_capture.StructureRenderData;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.common.util.RaycastHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class PlaceSchematicScreen
extends class_437 {
    public final String holdToFocus = "nuggets.gui.toolmenu.focusKey";
    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;
    public List<ToolType> tools = new ArrayList<ToolType>();
    public RenderStructureHandler renderStructureHandler;
    public class_304 focusKey;
    public PlaceTool placeTool;
    public RotateTool rotateTool;
    public MoveHorizontalTool moveHorizontalTool;
    public MoveVerticalTool moveVerticalTool;
    public ConfirmTool confirmTool;
    public PrintTool printTool;
    public DeleteTool deleteTool;
    public MirrorTool mirrorTool;
    public String modId;

    public PlaceSchematicScreen(String modId, class_304 focusKey, RenderStructureHandler<?> renderStructureHandler) {
        super((class_2561)class_2561.method_43470((String)"Tool Selection"));
        this.modId = modId;
        this.focusKey = focusKey;
        this.renderStructureHandler = renderStructureHandler;
        this.field_22787 = class_310.method_1551();
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        this.h = 34;
        this.placeTool = new PlaceTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_place.png"));
        this.rotateTool = new RotateTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_rotate.png"));
        this.moveHorizontalTool = new MoveHorizontalTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_horizontal.png"));
        this.moveVerticalTool = new MoveVerticalTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_vertical.png"));
        this.confirmTool = new ConfirmTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_confirm.png"));
        this.printTool = new PrintTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_print.png"));
        this.deleteTool = new DeleteTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_trash.png"));
        this.mirrorTool = new MirrorTool(this, class_2960.method_60655((String)modId, (String)"textures/gui/visualizer_icon_mirror.png"));
        this.tools.add(this.placeTool);
    }

    public void setupManipulationTools() {
        this.tools.clear();
        this.tools.add(this.moveHorizontalTool);
        this.tools.add(this.moveVerticalTool);
        this.tools.add(this.rotateTool);
        this.tools.add(this.confirmTool);
        if (this.renderStructureHandler.onPrint != null) {
            this.tools.add(this.printTool);
        }
        this.tools.add(this.deleteTool);
    }

    public ToolType getSelectedElement() {
        return this.tools.get(this.selection);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(class_332 graphics, float partialTicks) {
        this.w = Math.max(this.tools.size() * 50 + 32, 220);
        class_4587 matrixStack = graphics.method_51448();
        class_1041 mainWindow = this.field_22787.method_22683();
        if (!this.initialized) {
            this.method_25423(this.field_22787, mainWindow.method_4486(), mainWindow.method_4502());
        }
        int x = (mainWindow.method_4486() - this.w) / 2 + 14;
        int y = mainWindow.method_4502() - this.h - 34;
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, -this.yOffset, this.focused ? 100.0f : 0.0f);
        graphics.method_25290(class_2960.method_60655((String)this.modId, (String)"textures/gui/hud_background.png"), x - 15, y, 0.0f, 0.0f, this.w, this.h, 16, 16);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<class_2561> toolTip = this.tools.get(this.selection).getDescription();
        if (toolTipAlpha > 0.25f) {
            graphics.method_25290(class_2960.method_60655((String)this.modId, (String)"textures/gui/hud_background.png"), x - 15, y + 16, 0.0f, 0.0f, this.w, this.h, 16, 16);
            if (!toolTip.isEmpty()) {
                GuiHelpers.drawOutlinedText(this.field_22787.field_1772, graphics, toolTip.get(0), x - 10, y + 38);
            }
            if (toolTip.size() > 1) {
                GuiHelpers.drawOutlinedText(this.field_22787.field_1772, graphics, toolTip.get(1), x - 10, y + 50);
            }
        }
        if (this.tools.size() > 1) {
            String keyName = this.focusKey.method_16007().getString();
            int width = this.field_22787.method_22683().method_4486();
            if (!this.focused) {
                GuiHelpers.drawCenteredOutlinedText(this.field_22787.field_1772, graphics, (class_2561)class_2561.method_43469((String)"nuggets.gui.toolmenu.focusKey", (Object[])new Object[]{keyName}), width / 2, y - 10);
            } else {
                GuiHelpers.drawCenteredOutlinedText(this.field_22787.field_1772, graphics, (class_2561)class_2561.method_43471((String)"nuggets.scroll"), width / 2, y - 10);
            }
        } else {
            GuiHelpers.drawCenteredOutlinedText(this.field_22787.field_1772, graphics, (class_2561)class_2561.method_43471((String)"nuggets.place_description"), this.field_22789 / 2, y - 10);
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            matrixStack.method_22903();
            if (i == this.selection) {
                matrixStack.method_46416(0.0f, -10.0f, 0.0f);
                GuiHelpers.drawCenteredOutlinedText(this.field_22787.field_1772, graphics, this.tools.get(i).getDisplayName(), x + i * 50 + 26, y + 28);
            }
            class_2960 icon = this.tools.get(i).getIcon();
            graphics.method_25290(icon, x + i * 50 + 16, y + 11, 0.0f, 0.0f, 16, 16, 16, 16);
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public boolean scroll(double delta) {
        if (this.focused) {
            this.cycle((int)delta);
            return true;
        }
        if (PlaceSchematicScreen.method_25441()) {
            return this.tools.get(this.selection).handleMouseWheel(delta);
        }
        return false;
    }

    public void renderPassive(class_332 graphics, float partialTicks) {
        this.draw(graphics, partialTicks);
    }

    public void method_25419() {
    }

    protected void method_25426() {
        super.method_25426();
        this.initialized = true;
    }

    public static class PlaceTool
    extends ToolType {
        public PlaceTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.place_tool"), icon, placeSchematicScreen);
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.place_description"));
            return list;
        }

        @Override
        public void onClick() {
            Object structureData = this.placeSchematicScreen.renderStructureHandler.placingData;
            ((StructureRenderData)structureData).anchorPos = RaycastHelper.getLookingAt(((StructureRenderData)structureData).distanceFromCameraCast, (class_1657)class_310.method_1551().field_1724, true).method_17777();
            this.placeSchematicScreen.setupManipulationTools();
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            Object structureData = this.placeSchematicScreen.renderStructureHandler.placingData;
            if (structureData == null) {
                return false;
            }
            ((StructureRenderData)structureData).distanceFromCameraCast = delta > 0.0 ? (((StructureRenderData)structureData).distanceFromCameraCast += 1.0) : (((StructureRenderData)structureData).distanceFromCameraCast -= 1.0);
            return true;
        }
    }

    public static class RotateTool
    extends ToolType {
        public RotateTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.rotate_tool"), icon, placeSchematicScreen);
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.rotate_description"));
            return list;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            Object structureData = this.placeSchematicScreen.renderStructureHandler.placingData;
            if (structureData == null) {
                return false;
            }
            ((StructureRenderData)structureData).rotate(delta > 0.0 ? class_2470.field_11463 : class_2470.field_11465);
            ((StructureRenderData)structureData).lastRenderPos = null;
            return true;
        }
    }

    public static class MoveHorizontalTool
    extends ToolType {
        public MoveHorizontalTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.move_horizontal_tool"), icon, placeSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            Object structureData = this.placeSchematicScreen.renderStructureHandler.placingData;
            class_2350 direction = class_310.method_1551().field_1724.method_58149();
            class_2338 offset = new class_2338((int)delta * direction.method_10148(), 0, (int)delta * direction.method_10165());
            ((StructureRenderData)structureData).anchorPos = ((StructureRenderData)structureData).anchorPos.method_10081((class_2382)offset);
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.move_horizontal_description"));
            return list;
        }
    }

    public static class MoveVerticalTool
    extends ToolType {
        public MoveVerticalTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.move_vertical_tool"), icon, placeSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            Object structureData = this.placeSchematicScreen.renderStructureHandler.placingData;
            if (structureData == null || ((StructureRenderData)structureData).anchorPos == null) {
                return false;
            }
            ((StructureRenderData)structureData).anchorPos = ((StructureRenderData)structureData).anchorPos.method_10081((class_2382)new class_2338(0, (int)delta, 0));
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.move_vertical_description"));
            return list;
        }
    }

    public static class ConfirmTool
    extends ToolType {
        public ConfirmTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.confirm_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            this.placeSchematicScreen.renderStructureHandler.onConfirm.accept(this.placeSchematicScreen.renderStructureHandler);
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.confirm_description"));
            return list;
        }
    }

    public static class PrintTool
    extends ToolType {
        public PrintTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.print_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            this.placeSchematicScreen.renderStructureHandler.onPrint.accept(this.placeSchematicScreen.renderStructureHandler);
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.print_description"));
            return list;
        }
    }

    public static class DeleteTool
    extends ToolType {
        public DeleteTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.delete_tool"), icon, placeSchematicScreen);
        }

        @Override
        public void onClick() {
            this.placeSchematicScreen.renderStructureHandler.onDelete.accept(this.placeSchematicScreen.renderStructureHandler);
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.delete_description"));
            return list;
        }
    }

    public static class MirrorTool
    extends ToolType {
        public MirrorTool(PlaceSchematicScreen placeSchematicScreen, class_2960 icon) {
            super((class_2561)class_2561.method_43471((String)"nuggets.mirror_tool"), icon, placeSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            Object structureData = this.placeSchematicScreen.renderStructureHandler.placingData;
            ((StructureRenderData)structureData).flip();
            ((StructureRenderData)structureData).lastRenderPos = null;
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"nuggets.mirror_description"));
            return list;
        }
    }

    public static abstract class ToolType {
        public class_2561 name;
        public class_2960 icon;
        public PlaceSchematicScreen placeSchematicScreen;

        public ToolType(class_2561 name, class_2960 icon, PlaceSchematicScreen placeSchematicScreen) {
            this.name = name;
            this.icon = icon;
            this.placeSchematicScreen = placeSchematicScreen;
        }

        public void onClick() {
        }

        public class_2561 getDisplayName() {
            return this.name;
        }

        abstract List<class_2561> getDescription();

        public class_2960 getIcon() {
            return this.icon;
        }

        public boolean handleMouseWheel(double delta) {
            return false;
        }
    }
}

