/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.common.state_machine;

import com.hollingsworth.nuggets.Constants;
import com.hollingsworth.nuggets.common.state_machine.IState;
import com.hollingsworth.nuggets.common.state_machine.IStateEvent;
import javax.annotation.Nonnull;

public class SimpleStateMachine<State extends IState, Event extends IStateEvent> {
    protected State currentState;
    public boolean debug;

    public SimpleStateMachine(@Nonnull State initialState) {
        this.currentState = initialState;
        this.currentState.onStart();
    }

    protected void changeState(@Nonnull State nextState) {
        if (this.debug) {
            Constants.LOG.debug("Changing state from {} to {}", this.currentState, nextState);
        }
        this.currentState.onEnd();
        this.currentState = nextState;
        this.currentState.onStart();
    }

    public void tick() {
        if (this.currentState == null) {
            return;
        }
        Object nextState = this.currentState.tick();
        if (nextState != null) {
            this.changeState(nextState);
        }
    }

    public void onEvent(Event event) {
        Object nextState = this.currentState.onEvent((IStateEvent)event);
        if (nextState != null) {
            this.changeState(nextState);
        }
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public SimpleStateMachine<State, Event> setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }
}

