package com.hollingsworth.nuggets.client.rendering;

import I;
import com.hollingsworth.nuggets.client.Color;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import org.joml.Matrix4f;

import java.util.List;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class RenderHelpers {

    private static final class_1921 TRANSLUCENT = class_1921.method_23580(class_1059.field_5275);

    public static void drawItemAsIcon(class_1799 itemStack, class_332 graphics, int positionX, int positionY, int size, boolean renderTransparent) {
        renderFakeItemTransparent(graphics.method_51448(), itemStack, positionX, positionY, size, 0, renderTransparent,150);
    }

    public static void renderFakeItemTransparent(class_4587 poseStack, class_1799 stack, int x, int y, int scale, int alpha, boolean transparent, int zIndex) {
        if (stack.method_7960()) {
            return;
        }

        class_918 renderer = class_310.method_1551().method_1480();

        class_1087 model = renderer.method_4019(stack, null, class_310.method_1551().field_1724, 0);
        renderItemModel(poseStack, stack, x, y, scale, alpha, model, renderer, transparent, zIndex);
    }

    private static final Matrix4f SCALE_INVERT_Y = new Matrix4f().scaling(1F, -1F, 1F);

    public static void renderItemModel(class_4587 poseStack, class_1799 stack, int x, int y, int scale, int alpha, class_1087 model, class_918 renderer, boolean transparent, int zIndex) {
        poseStack.method_22903();
        poseStack.method_46416(x + 8F, y + 8F, zIndex);
        poseStack.method_34425(SCALE_INVERT_Y);
        poseStack.method_22905(scale, scale, scale);

        boolean flatLight = !model.method_24304();
        if (flatLight) {
            class_308.method_24210();
        }

        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        renderer.method_23179(
                stack,
                class_811.field_4317,
                false,
                poseStack,
                transparent ? transparentBuffer(buffer) : buffer,
                class_765.field_32767,
                class_4608.field_21444,
                model
        );
        buffer.method_22993();

        RenderSystem.enableDepthTest();

        if (flatLight) {
            class_308.method_24211();
        }

        poseStack.method_22909();
    }


    private static class_4597 transparentBuffer(class_4597 buffer) {
        return renderType -> new TintedVertexConsumer(buffer.getBuffer(TRANSLUCENT), 1.0f, 1.0f, 1.0f, 0.25f);
    }

    /*
     * Adapted from Eidolon, Elucent
     */
    public static void colorBlit(class_4587 mStack, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight, Color color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34543);
        Matrix4f matrix = mStack.method_23760().method_23761();
        int maxX = x + width, maxY = y + height;
        float minU = (float) uOffset / textureWidth, minV = (float) vOffset / textureHeight;
        float maxU = minU + (float) width / textureWidth, maxV = minV + (float) height / textureHeight;
        int r = color.getRed(), g = color.getGreen(), b = color.getBlue(), alpha = color.getAlpha();
        class_287 bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22918(matrix, (float) x, (float) maxY, 0).method_22913(minU, maxV).method_1336(r, g, b, alpha);
        bufferbuilder.method_22918(matrix, (float) maxX, (float) maxY, 0).method_22913(maxU, maxV).method_1336(r, g, b, alpha);
        bufferbuilder.method_22918(matrix, (float) maxX, (float) y, 0).method_22913(maxU, minV).method_1336(r, g, b, alpha);
        bufferbuilder.method_22918(matrix, (float) x, (float) y, 0).method_22913(minU, minV).method_1336(r, g, b, alpha);
        class_286.method_43433(bufferbuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void renderTooltipInternal(class_332 graphics, List<class_5684> pClientTooltipComponents, int pMouseX, int pMouseY, class_437 parentScreen) {
        var font = class_310.method_1551().field_1772;
        var parentWidth = parentScreen.field_22789;
        var parentHeight = parentScreen.field_22790;
        if (!pClientTooltipComponents.isEmpty()) {
            class_4587 pPoseStack = graphics.method_51448();

            int i = 0;
            int j = pClientTooltipComponents.size() == 1 ? -2 : 0;

            for (class_5684 clienttooltipcomponent : pClientTooltipComponents) {
                int k = clienttooltipcomponent.method_32664(font);
                if (k > i) {
                    i = k;
                }

                j += clienttooltipcomponent.method_32661();
            }

            int j2 = pMouseX + 12;
            int k2 = pMouseY - 12;
            if (j2 + i > parentWidth) {
                j2 -= 28 + i;
            }

            if (k2 + j + 6 > parentHeight) {
                k2 = parentHeight - j - 6;
            }
            pPoseStack.method_22903();
            RenderSystem.setShader(class_757::method_34540);
            Matrix4f matrix4f = pPoseStack.method_23760().method_23761();

            int backgroundColor = 0xf0100010;
            int borderStart = 0x505000FF;
            int borderEnd = 0x5028007f;

            graphics.method_33284(j2 - 3, k2 - 4, j2 + i + 3, k2 - 3, 400, backgroundColor,backgroundColor);
            graphics.method_33284(j2 - 3, k2 + j + 3, j2 + i + 3, k2 + j + 4, 400, backgroundColor, backgroundColor);
            graphics.method_33284(j2 - 3, k2 - 3, j2 + i + 3, k2 + j + 3, 400, backgroundColor, backgroundColor);
            graphics.method_33284(j2 - 4, k2 - 3, j2 - 3, k2 + j + 3, 400, backgroundColor, backgroundColor);
            graphics.method_33284(j2 + i + 3, k2 - 3, j2 + i + 4, k2 + j + 3, 400, backgroundColor, backgroundColor);
            graphics.method_33284(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + j + 3 - 1, 400, borderStart, borderEnd);
            graphics.method_33284(j2 + i + 2, k2 - 3 + 1, j2 + i + 3, k2 + j + 3 - 1, 400, borderStart, borderEnd);
            graphics.method_33284(j2 - 3, k2 - 3, j2 + i + 3, k2 - 3 + 1, 400, borderStart, borderStart);
            graphics.method_33284(j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 3, 400, borderEnd, borderEnd);

            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            class_4597.class_4598 multibuffersource$buffersource = graphics.method_51450();
            pPoseStack.method_22904(0.0D, 0.0D, 400.0D);
            int l1 = k2;

            for (int i2 = 0; i2 < pClientTooltipComponents.size(); ++i2) {
                class_5684 clienttooltipcomponent1 = pClientTooltipComponents.get(i2);
                clienttooltipcomponent1.method_32665(font, j2, l1, matrix4f, multibuffersource$buffersource);
                l1 += clienttooltipcomponent1.method_32661() + (i2 == 0 ? 2 : 0);
            }
            l1 = k2;

            pPoseStack.method_46416(0, 0, 600);
            for (int l2 = 0; l2 < pClientTooltipComponents.size(); ++l2) {
                class_5684 clienttooltipcomponent2 = pClientTooltipComponents.get(l2);
                clienttooltipcomponent2.method_32666(font, j2, l1, graphics);
                l1 += clienttooltipcomponent2.method_32661() + (l2 == 0 ? 2 : 0);
            }
            pPoseStack.method_22909();

        }
    }
}
