package com.hollingsworth.nuggets.client.gui;


import com.hollingsworth.nuggets.mixin.AbstractSliderButtonAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;

/**
 * Slider widget implementation which allows inputting values in a certain range with optional step size.
 * Copy of ExtendedSlider
 */
public abstract class BaseSlider extends class_357 {
    protected class_2561 prefix;
    protected class_2561 suffix;
    protected double minValue;
    protected double maxValue;
    protected double stepSize;
    protected boolean drawString;
    private final DecimalFormat format;

    public BaseSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, class_2561.method_43473(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.field_22753 = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }

            while(precision-- > 0) {
                builder.append('0');
            }

            this.format = new DecimalFormat(builder.toString());
        } else if (class_3532.method_20390(this.stepSize, Math.floor(this.stepSize))) {
            this.format = new DecimalFormat("0");
        } else {
            this.format = new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }

        this.method_25346();
    }

    public BaseSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, 1.0, 0, drawString);
    }

    public double getValue() {
        return this.field_22753 * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void method_25347(double value) {
        this.field_22753 = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.method_25346();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX, mouseY);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        super.method_25349(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX, mouseY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean flag = keyCode == 263;
        if (flag || keyCode == 262) {
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }

            float f = flag ? -1.0F : 1.0F;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.field_22753 + (double)(f / (float)(this.field_22758 - 8)));
            } else {
                this.method_25347(this.getValue() + (double)f * this.stepSize);
            }
        }

        return false;
    }

    public abstract void setValueFromMouse(double mouseX, double mouseY);

    public void setSliderValue(double value) {
        double oldValue = this.field_22753;
        this.field_22753 = this.snapToNearest(value);
        if (!class_3532.method_20390(oldValue, this.field_22753)) {
            this.method_25344();
        }

        this.method_25346();
    }

    private double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return class_3532.method_15350(value, 0.0, 1.0);
        } else {
            value = class_3532.method_16436(class_3532.method_15350(value, 0.0, 1.0), this.minValue, this.maxValue);
            value = this.stepSize * (double)Math.round(value / this.stepSize);
            if (this.minValue > this.maxValue) {
                value = class_3532.method_15350(value, this.maxValue, this.minValue);
            } else {
                value = class_3532.method_15350(value, this.minValue, this.maxValue);
            }

            return class_3532.method_33722(value, this.minValue, this.maxValue, 0.0, 1.0);
        }
    }

    protected void method_25346() {
        if (this.drawString) {
            this.method_25355(class_2561.method_43470("").method_10852(this.prefix).method_27693(this.getValueString()).method_10852(this.suffix));
        } else {
            this.method_25355(class_2561.method_43473());
        }

    }

    protected void method_25344() {
    }


    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_310 minecraft = class_310.method_1551();
        guiGraphics.method_51422(1.0F, 1.0F, 1.0F, this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        AbstractSliderButtonAccessor accessor = (AbstractSliderButtonAccessor)this;
        guiGraphics.method_52706(accessor.callGetSprite(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        guiGraphics.method_52706(accessor.callGetHandleSprite(), this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364());
        guiGraphics.method_51422(1.0F, 1.0F, 1.0F, 1.0F);
        int i = this.field_22763 ? 16777215 : 10526880;
        this.method_49604(guiGraphics, minecraft.field_1772, 2, i | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
    }
}
