package com.hollingsworth.nuggets.client.gui;

import com.hollingsworth.nuggets.mixin.ScreenAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5632;
import net.minecraft.class_6379;

public class BaseScreen extends class_437 {

    public int maxScale;
    public float scaleFactor;
    public int screenLeft;
    public int screenTop;
    public int screenRight;
    public int screenBottom;

    public int fullWidth;
    public int fullHeight;

    public class_2960 background;

    public BaseScreen(class_2561 titleIn, int fullWidth, int fullHeight, class_2960 background) {
        super(titleIn);
        this.fullHeight = fullHeight;
        this.fullWidth = fullWidth;
        this.background = background;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.maxScale = this.getMaxAllowedScale();
        this.scaleFactor = 1.0F;
        screenLeft = field_22789 / 2 - fullWidth / 2;
        screenTop = field_22790 / 2 - fullHeight / 2;
        screenRight = field_22789 / 2 + fullWidth / 2;
        screenBottom = field_22790 / 2 + fullHeight / 2;
    }

    public void drawTooltip(class_332 stack, int mouseX, int mouseY) {
        List<class_2561> tooltip = new ArrayList<>();
        collectTooltips(stack, mouseX, mouseY, tooltip);
        if (!tooltip.isEmpty()) {
            stack.method_51437(field_22793, tooltip, Optional.ofNullable(getClientImageTooltip(mouseX, mouseY)), mouseX, mouseY);
        }
    }

    public void collectTooltips(class_332 stack, int mouseX, int mouseY, List<class_2561> tooltip){
        for(class_4068 renderable : renderablesList()){
            if(renderable instanceof class_339 widget && renderable instanceof ITooltipRenderer tooltipProvider){
                if(GuiHelpers.isMouseInRelativeRange(mouseX, mouseY, widget) && widget.field_22764){
                    tooltipProvider.gatherTooltips(stack, mouseX, mouseY, tooltip);
                }
            }
        }
    }

    protected class_5632 getClientImageTooltip(int mouseX, int mouseY) {
        return null;
    }

    public void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
    }

    public void drawScreenAfterScale(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        method_25420(graphics, mouseX, mouseY, partialTicks);
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(screenLeft, screenTop, 0);
        RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
        drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        drawForegroundElements(mouseX, mouseY, partialTicks);
        poseStack.method_22909();
        for (class_4068 renderable : this.renderablesList()) {
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        drawTooltip(graphics, mouseX, mouseY);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrixStack = graphics.method_51448();
        matrixStack.method_22903();
        if (scaleFactor != 1) {
            matrixStack.method_22905(scaleFactor, scaleFactor, scaleFactor);
            mouseX /= scaleFactor;
            mouseY /= scaleFactor;
        }
        drawScreenAfterScale(graphics, mouseX, mouseY, partialTicks);
        matrixStack.method_22909();
    }

    public void drawBackgroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25290(background, 0, 0, 0, 0, fullWidth, fullHeight, fullWidth, fullHeight);
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    private int getMaxAllowedScale() {
        return this.field_22787.method_22683().method_4476(0, this.field_22787.method_1573());
    }

    @Override
    protected void method_57734(float pPartialTick) {

    }

    public List<class_4068> renderablesList() {
        return ((ScreenAccessor)this).getRenderables();
    }

    protected Map<NestedWidgets, List<class_339>> nestedWidgetMap = new Reference2ObjectOpenHashMap<>();

    @Override
    protected <T extends class_364 & class_4068 & class_6379> T method_37063(T widget) {
        List<class_339> afterParent = new ArrayList<>();
        List<class_339> beforeParent = new ArrayList<>();

        if (widget instanceof NestedWidgets nestedRenderables) {
            nestedRenderables.addBeforeParent(beforeParent);

            for (class_339 renderable : beforeParent) {
                super.method_37063(renderable);
            }

            nestedRenderables.addAfterParent(afterParent);
            List<class_339> allWidgets = new ArrayList<>();
            allWidgets.addAll(afterParent);
            allWidgets.addAll(beforeParent);
            nestedWidgetMap.put(nestedRenderables, allWidgets);
        }
        T added = super.method_37063(widget);
        for(class_339 renderable : afterParent) {
            super.method_37063(renderable);
        }
        return added;
    }

    @Override
    protected void method_37066(class_364 pListener) {
        if(pListener instanceof NestedWidgets nestedWidgets){
            var children = nestedWidgetMap.get(nestedWidgets);
            if(children != null){
                for(class_339 renderable : children){
                    if(renderable != null){
                        super.method_37066(renderable);
                    }
                }
            }
            nestedWidgetMap.remove(nestedWidgets);
        }
        super.method_37066(pListener);
    }
}
