package com.hollingsworth.nuggets.client.area_capture;


import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_304;
import net.minecraft.class_332;


public class RenderStructureHandler {
    private StructureRenderData placingData;
    private PlaceSchematicScreen schematicTools;

    public RenderStructureHandler(class_304 focusKey, StructureRenderData placingData, BiFunction<class_1657, StructureRenderData, List<PlaceSchematicScreen.ToolType>> setupTools){
        this.placingData = placingData;
        schematicTools = new PlaceSchematicScreen(focusKey, this, placingData, setupTools);
    }
    // Client tick event
    public void tick(){
        if(placingData == null){
            return;
        }
        schematicTools.update();
    }

    // Right click event
    public void rightClickEvent() {
        if (placingData == null) {
            return;
        }
        schematicTools.getSelectedElement().onClick();
    }

    // Bound tool key pressed event
    public void toolKeyHit(boolean keyPressed){
        if (placingData == null) {
            return;
        }
        if (keyPressed && !schematicTools.focused)
            schematicTools.focused = true;
        if (!keyPressed && schematicTools.focused) {
            schematicTools.focused = false;
            schematicTools.method_25419();
        }
    }

    public boolean mouseScrolled(double delta) {
        if (placingData == null) {
            return false;
        }
        return schematicTools.scroll(delta);
    }

    // RenderGuiLayerEvent.Post event
    public void renderInstructions(class_332 graphics, class_1041 window) {
        if (placingData == null)
            return;
        schematicTools.renderPassive(graphics, 0);
    }
}
