package com.hollingsworth.nuggets.client.area_capture;


import com.hollingsworth.nuggets.client.NuggetClientData;
import com.hollingsworth.nuggets.common.util.RaycastHelper;
import com.hollingsworth.nuggets.common.util.VecHelper;
import com.hollingsworth.nuggets.common.util.WorldHelpers;
import org.apache.commons.lang3.function.TriConsumer;
import org.joml.Matrix4f;

import java.util.function.BiConsumer;
import net.minecraft.class_1041;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3499;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import net.minecraft.class_761;


public class AreaCaptureHandler {

    public class_2338 firstTarget;
    public class_2338 secondTarget;
    public boolean showBoundary;
    public class_2350 selectedFace = null;
    public TriConsumer<class_332, class_1041, AreaCaptureHandler> onRender;
    public BiConsumer<class_3499, AreaCaptureHandler> onConfirmedStructure;

    public AreaCaptureHandler(TriConsumer<class_332, class_1041, AreaCaptureHandler> onRender, BiConsumer<class_3499, AreaCaptureHandler> onConfirmedStructure){
        this.onRender = onRender;
        this.onConfirmedStructure = onConfirmedStructure;
    }

    public void startCapture(){
        showBoundary = true;
        firstTarget = null;
        secondTarget = null;
    }

    public void cancelCapture(){
        showBoundary = false;
        firstTarget = null;
        secondTarget = null;
    }

    public void onConfirmHit() {
        if (!showBoundary) {
            return;
        }
        showBoundary = false;
        if (firstTarget != null && secondTarget != null) {
            class_3499 structure = WorldHelpers.getStructure(class_310.method_1551().field_1687, firstTarget, secondTarget);
            this.onConfirmedStructure.accept(structure, this);
        }
    }

    public void onCancelHit() {
        if (!showBoundary) {
            return;
        }
        cancelCapture();
    }

    public class_2338 selectedPos = null;

    public void renderBoundary(class_4587 poseStack, Matrix4f modelViewMatrix) {
        if (!showBoundary)
            return;
        class_2338 firstPos = firstTarget;
        class_746 player = class_310.method_1551().field_1724;
        class_3965 trace = RaycastHelper.rayTraceRange(player.method_37908(), player, 75);
        if (trace.method_17783() == class_239.class_240.field_1332) {

            class_2338 hit = trace.method_17777();
            boolean replaceable = player.method_37908().method_8320(hit)
                    .method_26166(new class_1750(new class_1838(player, class_1268.field_5808, trace)));
            if (trace.method_17780()
                    .method_10166()
                    .method_10178() && !replaceable)
                hit = hit.method_10093(trace.method_17780());
            selectedPos = hit;
        } else {
            selectedPos = null;
        }
        if (firstPos == null && selectedPos != null) {
            renderBbox(new class_238(selectedPos), poseStack, modelViewMatrix);
            return;
        }
        class_2338 secondPos = secondTarget;
        if (secondPos == null) {
            secondPos = selectedPos;
        }
        class_238 currentSelectionBox = null;
        if (secondPos == null) {
            if (firstPos == null) {
                currentSelectionBox = selectedPos == null ? null : new class_238(selectedPos);
            } else {
                currentSelectionBox = selectedPos == null ? new class_238(firstPos) : class_238.method_54784(firstPos, selectedPos).method_1012(1, 1, 1);
            }
        } else {
            currentSelectionBox = class_238.method_54784(firstPos, secondPos).method_1012(1, 1, 1);
        }

        renderBbox(currentSelectionBox, poseStack, modelViewMatrix);
    }

    public void renderBbox(class_238 currentSelectionBox, class_4587 poseStack, Matrix4f modelViewMatrix) {
        if (currentSelectionBox == null) {
            return;
        }
        class_243 camera = class_310.method_1551().field_1773.method_19418()
                .method_19326();

        currentSelectionBox.method_997(camera.method_1021(-1));
        currentSelectionBox = currentSelectionBox.method_989(-camera.field_1352, -camera.field_1351, -camera.field_1350);

        poseStack.method_22903();
        poseStack.method_34425(modelViewMatrix);
        class_4588 vertexconsumer = NuggetClientData.bufferSource.getBuffer(class_1921.method_23594());
        class_761.method_22982(poseStack, vertexconsumer, currentSelectionBox, 0.9F, 0.9F, 0.9F, 1.0f);
        NuggetClientData.bufferSource.method_22993();
        poseStack.method_22909();
    }

    public boolean positionClicked() {
        if (!showBoundary) {
            return false;
        }
        class_2338 pos = selectedPos;
        if (pos == null) {
            return false;
        }
        if (firstTarget == null) {
            firstTarget = pos.method_10062();
            return true;
        } else if (secondTarget == null && !firstTarget.equals(pos)) {
            secondTarget = pos.method_10062();
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double delta){
        if (!showBoundary || firstTarget == null || secondTarget == null) {
            return false;
        }

        if (!class_437.method_25441())
            return false;

        if (selectedFace == null)
            return true;

        class_238 bb = new class_238(firstTarget.method_10263(), firstTarget.method_10264(), firstTarget.method_10260(), secondTarget.method_10263(), secondTarget.method_10264(), secondTarget.method_10260());
        class_2382 vec = selectedFace.method_10163();
        class_243 projectedView = class_310.method_1551().field_1773.method_19418()
                .method_19326();
        if (bb.method_1006(projectedView))
            delta *= -1;

        int x = (int) (vec.method_10263() * delta);
        int y = (int) (vec.method_10264() * delta);
        int z = (int) (vec.method_10260() * delta);

        class_2350.class_2352 axisDirection = selectedFace.method_10171();
        if (axisDirection == class_2350.class_2352.field_11060)
            bb = bb.method_989(-x, -y, -z);

        double maxX = Math.max(bb.field_1320 - x * axisDirection.method_10181(), bb.field_1323);
        double maxY = Math.max(bb.field_1325 - y * axisDirection.method_10181(), bb.field_1322);
        double maxZ = Math.max(bb.field_1324 - z * axisDirection.method_10181(), bb.field_1321);
        bb = new class_238(bb.field_1323, bb.field_1322, bb.field_1321, maxX, maxY, maxZ);

        firstTarget = net.minecraft.class_2338.method_49637(bb.field_1323, bb.field_1322, bb.field_1321);
        secondTarget = net.minecraft.class_2338.method_49637(bb.field_1320, bb.field_1325, bb.field_1324);
        class_746 player = class_310.method_1551().field_1724;
        player.method_7353(class_2561.method_43469("nuggets.dimensions", (int) bb.method_17939() + 1, (int) bb.method_17940() + 1,
                        (int) bb.method_17941() + 1), true);


        return true;
    }

    public void tick(){
        selectedFace = null;
        if (secondTarget != null) {
            class_1657 player = class_310.method_1551().field_1724;
            class_238 bb = class_238.method_54784(firstTarget, secondTarget).method_1012(1, 1, 1)
                    .method_1014(.45f);
            class_243 projectedView = class_310.method_1551().field_1773.method_19418()
                    .method_19326();
            boolean inside = bb.method_1006(projectedView);
            RaycastHelper.PredicateTraceResult result =
                    RaycastHelper.rayTraceUntil(player, 70, pos -> inside ^ bb.method_1006(VecHelper.getCenterOf(pos)));
            selectedFace = result.missed() ? null
                    : inside ? result.getFacing()
                    .method_10153() : result.getFacing();
        }

    }

    public void renderBoundaryUI(class_332 graphics, class_1041 window) {
        if (!showBoundary || class_310.method_1551().field_1690.field_1842)
            return;
        onRender.accept(graphics, window, this);
    }

}
