/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.NuggetClientData;
import com.hollingsworth.nuggets.common.util.RaycastHelper;
import com.hollingsworth.nuggets.common.util.VecHelper;
import com.hollingsworth.nuggets.common.util.WorldHelpers;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3499;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import net.minecraft.class_761;
import org.joml.Matrix4f;

public class AreaCaptureHandler {
    public class_2338 firstTarget;
    public class_2338 secondTarget;
    public boolean showBoundary;
    public class_2350 selectedFace = null;
    public BiConsumer<class_332, class_1041> onRender;
    Consumer<class_3499> onConfirmedStructure;
    public class_2338 selectedPos = null;

    public AreaCaptureHandler(BiConsumer<class_332, class_1041> onRender, Consumer<class_3499> onConfirmedStructure) {
        this.onRender = onRender;
        this.onConfirmedStructure = onConfirmedStructure;
    }

    public void startCapture() {
        this.showBoundary = true;
        this.firstTarget = null;
        this.secondTarget = null;
    }

    public void cancelCapture() {
        this.showBoundary = false;
        this.firstTarget = null;
        this.secondTarget = null;
    }

    public void onConfirmHit() {
        if (!this.showBoundary) {
            return;
        }
        this.showBoundary = false;
        if (this.firstTarget != null && this.secondTarget != null) {
            class_3499 structure = WorldHelpers.getStructure((class_1937)class_310.method_1551().field_1687, this.firstTarget, this.secondTarget);
            this.onConfirmedStructure.accept(structure);
        }
    }

    public void onCancelHit() {
        if (!this.showBoundary) {
            return;
        }
        this.cancelCapture();
    }

    public void renderBoundary(class_4587 poseStack, Matrix4f modelViewMatrix) {
        if (!this.showBoundary) {
            return;
        }
        class_2338 firstPos = this.firstTarget;
        class_746 player = class_310.method_1551().field_1724;
        class_3965 trace = RaycastHelper.rayTraceRange(player.method_37908(), (class_1657)player, 75.0);
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 hit = trace.method_17777();
            boolean replaceable = player.method_37908().method_8320(hit).method_26166(new class_1750(new class_1838((class_1657)player, class_1268.field_5808, trace)));
            if (trace.method_17780().method_10166().method_10178() && !replaceable) {
                hit = hit.method_10093(trace.method_17780());
            }
            this.selectedPos = hit;
        } else {
            this.selectedPos = null;
        }
        if (firstPos == null && this.selectedPos != null) {
            this.renderBbox(new class_238(this.selectedPos), poseStack, modelViewMatrix);
            return;
        }
        class_2338 secondPos = this.secondTarget;
        if (secondPos == null) {
            secondPos = this.selectedPos;
        }
        class_238 currentSelectionBox = null;
        currentSelectionBox = secondPos == null ? (firstPos == null ? (this.selectedPos == null ? null : new class_238(this.selectedPos)) : (this.selectedPos == null ? new class_238(firstPos) : class_238.method_54784((class_2338)firstPos, (class_2338)this.selectedPos).method_1012(1.0, 1.0, 1.0))) : class_238.method_54784((class_2338)firstPos, (class_2338)secondPos).method_1012(1.0, 1.0, 1.0);
        this.renderBbox(currentSelectionBox, poseStack, modelViewMatrix);
    }

    public void renderBbox(class_238 currentSelectionBox, class_4587 poseStack, Matrix4f modelViewMatrix) {
        if (currentSelectionBox == null) {
            return;
        }
        class_243 camera = class_310.method_1551().field_1773.method_19418().method_19326();
        currentSelectionBox.method_997(camera.method_1021(-1.0));
        currentSelectionBox = currentSelectionBox.method_989(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        poseStack.method_22903();
        poseStack.method_34425(modelViewMatrix);
        class_4588 vertexconsumer = NuggetClientData.bufferSource.getBuffer(class_1921.method_23594());
        class_761.method_22982((class_4587)poseStack, (class_4588)vertexconsumer, (class_238)currentSelectionBox, (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        NuggetClientData.bufferSource.method_22993();
        poseStack.method_22909();
    }

    public boolean positionClicked() {
        if (!this.showBoundary) {
            return false;
        }
        class_2338 pos = this.selectedPos;
        if (pos == null) {
            return false;
        }
        if (this.firstTarget == null) {
            this.firstTarget = pos.method_10062();
            return true;
        }
        if (this.secondTarget == null && !this.firstTarget.equals((Object)pos)) {
            this.secondTarget = pos.method_10062();
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double delta) {
        if (!this.showBoundary || this.firstTarget == null || this.secondTarget == null) {
            return false;
        }
        if (!class_437.method_25441()) {
            return false;
        }
        if (this.selectedFace == null) {
            return true;
        }
        class_238 bb = new class_238((double)this.firstTarget.method_10263(), (double)this.firstTarget.method_10264(), (double)this.firstTarget.method_10260(), (double)this.secondTarget.method_10263(), (double)this.secondTarget.method_10264(), (double)this.secondTarget.method_10260());
        class_2382 vec = this.selectedFace.method_10163();
        class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
        if (bb.method_1006(projectedView)) {
            delta *= -1.0;
        }
        int x = (int)((double)vec.method_10263() * delta);
        int y = (int)((double)vec.method_10264() * delta);
        int z = (int)((double)vec.method_10260() * delta);
        class_2350.class_2352 axisDirection = this.selectedFace.method_10171();
        if (axisDirection == class_2350.class_2352.field_11060) {
            bb = bb.method_989((double)(-x), (double)(-y), (double)(-z));
        }
        double maxX = Math.max(bb.field_1320 - (double)(x * axisDirection.method_10181()), bb.field_1323);
        double maxY = Math.max(bb.field_1325 - (double)(y * axisDirection.method_10181()), bb.field_1322);
        double maxZ = Math.max(bb.field_1324 - (double)(z * axisDirection.method_10181()), bb.field_1321);
        bb = new class_238(bb.field_1323, bb.field_1322, bb.field_1321, maxX, maxY, maxZ);
        this.firstTarget = class_2338.method_49637((double)bb.field_1323, (double)bb.field_1322, (double)bb.field_1321);
        this.secondTarget = class_2338.method_49637((double)bb.field_1320, (double)bb.field_1325, (double)bb.field_1324);
        class_746 player = class_310.method_1551().field_1724;
        player.method_7353((class_2561)class_2561.method_43469((String)"blockprints.dimensions", (Object[])new Object[]{(int)bb.method_17939() + 1, (int)bb.method_17940() + 1, (int)bb.method_17941() + 1}), true);
        return true;
    }

    public void tick() {
        this.selectedFace = null;
        if (this.secondTarget != null) {
            class_243 projectedView;
            class_746 player = class_310.method_1551().field_1724;
            class_238 bb = class_238.method_54784((class_2338)this.firstTarget, (class_2338)this.secondTarget).method_1012(1.0, 1.0, 1.0).method_1014((double)0.45f);
            boolean inside = bb.method_1006(projectedView = class_310.method_1551().field_1773.method_19418().method_19326());
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((class_1657)player, 70.0, pos -> inside ^ bb.method_1006(VecHelper.getCenterOf((class_2382)pos)));
            this.selectedFace = result.missed() ? null : (inside ? result.getFacing().method_10153() : result.getFacing());
        }
    }

    public void renderBoundaryUI(class_332 graphics, class_1041 window) {
        if (!this.showBoundary || class_310.method_1551().field_1690.field_1842) {
            return;
        }
        this.onRender.accept(graphics, window);
    }
}

