package com.hollingsworth.nuggets.datagen.patchouli;

import com.hollingsworth.nuggets.common.registry.RegistryHelper;
import net.minecraft.class_1299;
import net.minecraft.class_2960;

public class EntityPage extends AbstractPage {

    public EntityPage(String entity) {
        object.addProperty("entity", entity);
    }

    public EntityPage(class_1299 type){
        this(RegistryHelper.getRegistryName(type).toString());
    }

    public EntityPage withScale(float scale) {
        object.addProperty("scale", scale);
        return this;
    }

    public EntityPage withOffset(float offset) {
        object.addProperty("offset", offset);
        return this;
    }

    public EntityPage withRotate(boolean rotate) {
        object.addProperty("rotate", rotate);
        return this;
    }

    public EntityPage withDefaultRotation(float rotation) {
        object.addProperty("default_rotation", rotation);
        return this;
    }

    public EntityPage withText(String text) {
        object.addProperty("text", text);
        return this;
    }

    public EntityPage withName(String name){
        object.addProperty("name", name);
        return this;
    }

    @Override
    public class_2960 getType() {
        return class_2960.method_12829("patchouli:entity");
    }
}
