package com.hollingsworth.nuggets.client.rendering;


import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class StatePos {
    public static class_9139<class_9129, StatePos> STREAM = class_9139.method_56438((val, buf) ->{
        class_9135.field_48556.encode(buf, val.tag);
        class_2338.field_48404.encode(buf, val.pos);
    }, (buf) -> new StatePos(class_9135.field_48556.decode(buf), class_2338.field_48404.decode(buf)));

    public static class_9139<class_9129, List<StatePos>> STREAM_LIST = STREAM.method_56433(class_9135.method_56363());

    public class_2680 state;
    public class_2338 pos;
    private class_2487 tag;


    public StatePos(class_2680 state, class_2338 pos) {
        this.state = state;
        this.pos = pos;
    }

    public StatePos(class_2487 tag, class_2338 pos){
        this.state = null;
        this.tag = tag;
        this.pos = pos;
    }

    public static ArrayList<class_2680> getBlockStateMap(ArrayList<StatePos> list) {
        ArrayList<class_2680> blockStateMap = new ArrayList<>();
        for (StatePos statePos : list) {
            if (!blockStateMap.contains(statePos.state))
                blockStateMap.add(statePos.state);
        }
        return blockStateMap;
    }

    public static ArrayList<StatePos> rotate(ArrayList<StatePos> list, ArrayList<TagPos> tagListMutable, class_2470 rotation) {
        ArrayList<StatePos> rotatedList = new ArrayList<>();
        if (list == null || list.isEmpty()) {
            return rotatedList;
        }
        boolean tags = !(tagListMutable == null || tagListMutable.isEmpty()); //If not empty or null, it has tags!

        Map<class_2338, class_2487> tagMap = new HashMap<>();
        if (tags)
            tagMap = tagListMutable.stream().collect(Collectors.toMap(e -> e.pos, e -> e.tag));

        for (StatePos statePos : list) {
            class_2338 oldPos = statePos.pos;
            class_2680 oldState = statePos.state;
            class_2680 newState = oldState.method_26186(rotation);
            class_2338 newPos = oldPos.method_10070(rotation);

            if (tags && tagMap.get(statePos.pos) != null) {
                class_2487 tempTag = tagMap.get(statePos.pos);
                tagMap.remove(statePos.pos);
                tagMap.put(newPos, tempTag);
            }

            rotatedList.add(new StatePos(newState, newPos));
        }

        if (tags) {
            tagListMutable.clear();
            for (Map.Entry<class_2338, class_2487> entry : tagMap.entrySet())
                tagListMutable.add(new TagPos(entry.getValue(), entry.getKey()));
        }

        return rotatedList;
    }

    public static class_2499 getBlockStateNBT(ArrayList<class_2680> blockStateMap) {
        class_2499 listTag = new class_2499();
        for (class_2680 blockState : blockStateMap) {
            listTag.add(class_2512.method_10686(blockState));
        }
        return listTag;
    }

    public static ArrayList<class_2680> getBlockStateMapFromNBT(class_2499 listTag) {
        ArrayList<class_2680> blockStateMap = new ArrayList<>();
        for (int i = 0; i < listTag.size(); i++) {
            class_2680 blockState = class_2512.method_10681(class_7923.field_41175.method_46771(), listTag.method_10602(i));
            blockStateMap.add(blockState);
        }
        return blockStateMap;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StatePos) {
            return ((StatePos) obj).state.equals(this.state) && ((StatePos) obj).pos.equals(this.pos);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(state, pos);
    }
}