package com.hollingsworth.nuggets.client.gui;

import javax.annotation.Nullable;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8666;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;

/**
 * A duplicate of the vanilla EditBox class with public variables.
 */
public class CopyEditBox extends class_339 implements class_4068 {
    public static final class_8666 SPRITES = new class_8666(class_2960.method_60656("widget/text_field"), class_2960.method_60656("widget/text_field_highlighted"));
    public static final int BACKWARDS = -1;
    public static final int FORWARDS = 1;
    public static final int CURSOR_INSERT_WIDTH = 1;
    public static final int CURSOR_INSERT_COLOR = -3092272;
    public static final String CURSOR_APPEND_CHARACTER = "_";
    public static final int DEFAULT_TEXT_COLOR = 14737632;
    public static final int CURSOR_BLINK_INTERVAL_MS = 300;
    public final class_327 font;
    public String value;
    public int maxLength;
    public boolean bordered;
    public boolean canLoseFocus;
    public boolean isEditable;
    public int displayPos;
    public int cursorPos;
    public int highlightPos;
    public int textColor;
    public int textColorUneditable;
    @Nullable
    public String suggestion;
    @Nullable
    public Consumer<String> responder;
    public Predicate<String> filter;
    public BiFunction<String, Integer, class_5481> formatter;
    @Nullable
    public class_2561 hint;
    public long focusedTime;
    public boolean textShadow;

    public CopyEditBox(class_327 font, int width, int height, class_2561 message) {
        this(font, 0, 0, width, height, message);
    }

    public CopyEditBox(class_327 font, int x, int y, int width, int height, class_2561 message) {
        this(font, x, y, width, height, (net.minecraft.class_342) null, message);
    }

    public CopyEditBox(class_327 font, int x, int y, int width, int height, @Nullable net.minecraft.class_342 editBox, class_2561 message) {
        super(x, y, width, height, message);
        this.value = "";
        this.maxLength = 32;
        this.bordered = true;
        this.canLoseFocus = true;
        this.isEditable = true;
        this.textColor = 14737632;
        this.textColorUneditable = 7368816;
        this.filter = Objects::nonNull;
        this.formatter = (p_94147_, p_94148_) -> {
            return class_5481.method_30747(p_94147_, class_2583.field_24360);
        };
        this.focusedTime = class_156.method_658();
        this.textShadow = true;
        this.font = font;
        if (editBox != null) {
            this.setValue(editBox.method_1882());
        }

    }

    public void setResponder(Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFormatter(BiFunction<String, Integer, class_5481> textFormatter) {
        this.formatter = textFormatter;
    }

    protected class_5250 method_25360() {
        class_2561 component = this.method_25369();
        return class_2561.method_43469("gui.narrate.editBox", new Object[]{component, this.value});
    }

    public void setValue(String text) {
        if (this.filter.test(text)) {
            if (text.length() > this.maxLength) {
                this.value = text.substring(0, this.maxLength);
            } else {
                this.value = text;
            }

            this.moveCursorToEnd(false);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(text);
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> validator) {
        this.filter = validator;
    }

    public void insertText(String textToWrite) {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k > 0) {
            String s = class_3544.method_57180(textToWrite);
            int l = s.length();
            if (k < l) {
                if (Character.isHighSurrogate(s.charAt(k - 1))) {
                    --k;
                }

                s = s.substring(0, k);
                l = k;
            }

            String s1 = (new StringBuilder(this.value)).replace(i, j, s).toString();
            this.setValue(s1);
        }

    }

    private void onValueChange(String newText) {
        if (this.responder != null) {
            this.responder.accept(newText);
        }

    }

    private void deleteText(int count) {
        if (class_437.method_25441()) {
            this.deleteWords(count);
        } else {
            this.deleteChars(count);
        }

    }

    public void deleteWords(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteCharsToPos(this.getWordPosition(num));
            }
        }

    }

    public void deleteChars(int num) {
        this.deleteCharsToPos(this.getCursorPos(num));
    }

    public void deleteCharsToPos(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                int i = Math.min(num, this.cursorPos);
                int j = Math.max(num, this.cursorPos);
                if (i != j) {
                    String s = (new StringBuilder(this.value)).delete(i, j).toString();
                    if (this.filter.test(s)) {
                        this.value = s;
                        this.moveCursorTo(i, false);
                    }
                }
            }
        }

    }

    public int getWordPosition(int numWords) {
        return this.getWordPosition(numWords, this.getCursorPosition());
    }

    private int getWordPosition(int numWords, int pos) {
        return this.getWordPosition(numWords, pos, true);
    }

    private int getWordPosition(int numWords, int pos, boolean skipConsecutiveSpaces) {
        int i = pos;
        boolean flag = numWords < 0;
        int j = Math.abs(numWords);

        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.value.length();
                i = this.value.indexOf(32, i);
                if (i == -1) {
                    i = l;
                } else {
                    while (skipConsecutiveSpaces && i < l && this.value.charAt(i) == ' ') {
                        ++i;
                    }
                }
            } else {
                while (skipConsecutiveSpaces && i > 0 && this.value.charAt(i - 1) == ' ') {
                    --i;
                }

                while (i > 0 && this.value.charAt(i - 1) != ' ') {
                    --i;
                }
            }
        }

        return i;
    }

    public void moveCursor(int delta, boolean select) {
        this.moveCursorTo(this.getCursorPos(delta), select);
    }

    private int getCursorPos(int delta) {
        return class_156.method_27761(this.value, this.cursorPos, delta);
    }

    public void moveCursorTo(int delta, boolean select) {
        this.setCursorPosition(delta);
        if (!select) {
            this.setHighlightPos(this.cursorPos);
        }

        this.onValueChange(this.value);
    }

    public void setCursorPosition(int pos) {
        this.cursorPos = class_3532.method_15340(pos, 0, this.value.length());
        this.scrollTo(this.cursorPos);
    }

    public void moveCursorToStart(boolean select) {
        this.moveCursorTo(0, select);
    }

    public void moveCursorToEnd(boolean select) {
        this.moveCursorTo(this.value.length(), select);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.method_37303() && this.method_25370()) {
            switch (keyCode) {
                case 259:
                    if (this.isEditable) {
                        this.deleteText(-1);
                    }

                    return true;
                case 260:
                case 264:
                case 265:
                case 266:
                case 267:
                default:
                    if (class_437.method_25439(keyCode)) {
                        this.moveCursorToEnd(false);
                        this.setHighlightPos(0);
                        return true;
                    } else if (class_437.method_25438(keyCode)) {
                        class_310.method_1551().field_1774.method_1455(this.getHighlighted());
                        return true;
                    } else if (class_437.method_25437(keyCode)) {
                        if (this.isEditable()) {
                            this.insertText(class_310.method_1551().field_1774.method_1460());
                        }

                        return true;
                    } else {
                        if (class_437.method_25436(keyCode)) {
                            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
                            if (this.isEditable()) {
                                this.insertText("");
                            }

                            return true;
                        }

                        return false;
                    }
                case 261:
                    if (this.isEditable) {
                        this.deleteText(1);
                    }

                    return true;
                case 262:
                    if (class_437.method_25441()) {
                        this.moveCursorTo(this.getWordPosition(1), class_437.method_25442());
                    } else {
                        this.moveCursor(1, class_437.method_25442());
                    }

                    return true;
                case 263:
                    if (class_437.method_25441()) {
                        this.moveCursorTo(this.getWordPosition(-1), class_437.method_25442());
                    } else {
                        this.moveCursor(-1, class_437.method_25442());
                    }

                    return true;
                case 268:
                    this.moveCursorToStart(class_437.method_25442());
                    return true;
                case 269:
                    this.moveCursorToEnd(class_437.method_25442());
                    return true;
            }
        } else {
            return false;
        }
    }

    public boolean canConsumeInput() {
        return this.method_37303() && this.method_25370() && this.isEditable();
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        } else if (class_3544.method_57175(codePoint)) {
            if (this.isEditable) {
                this.insertText(Character.toString(codePoint));
            }

            return true;
        } else {
            return false;
        }
    }

    public void method_25348(double mouseX, double mouseY) {
        int i = class_3532.method_15357(mouseX) - this.method_46426();
        if (this.bordered) {
            i -= 4;
        }

        String s = this.font.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
        this.moveCursorTo(this.font.method_27523(s, i).length() + this.displayPos, class_437.method_25442());
    }

    public void method_25354(class_1144 handler) {
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible()) {
            if (this.isBordered()) {
                class_2960 resourcelocation = SPRITES.method_52729(this.method_37303(), this.method_25370());
                guiGraphics.method_52706(resourcelocation, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            }

            int l1 = this.isEditable ? this.textColor : this.textColorUneditable;
            int i = this.cursorPos - this.displayPos;
            String s = this.font.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
            boolean flag = i >= 0 && i <= s.length();
            boolean flag1 = this.method_25370() && (class_156.method_658() - this.focusedTime) / 300L % 2L == 0L && flag;
            int j = this.bordered ? this.method_46426() + 4 : this.method_46426();
            int k = this.bordered ? this.method_46427() + (this.field_22759 - 8) / 2 : this.method_46427();
            int l = j;
            int i1 = class_3532.method_15340(this.highlightPos - this.displayPos, 0, s.length());
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, i) : s;
                l = guiGraphics.method_51430(this.font, (class_5481) this.formatter.apply(s1, this.displayPos), j, k, l1, this.textShadow);
            }

            boolean flag2 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
            int j1 = l;
            if (!flag) {
                j1 = i > 0 ? j + this.field_22758 : j;
            } else if (flag2) {
                j1 = l - 1;
                --l;
            }

            if (!s.isEmpty() && flag && i < s.length()) {
                guiGraphics.method_51430(this.font, (class_5481) this.formatter.apply(s.substring(i), this.cursorPos), l, k, l1, this.textShadow);
            }

            if (this.hint != null && s.isEmpty() && !this.method_25370()) {
                guiGraphics.method_51439(this.font, this.hint, l, k, l1, this.textShadow);
            }

            if (!flag2 && this.suggestion != null) {
                guiGraphics.method_51433(this.font, this.suggestion, j1 - 1, k, -8355712, this.textShadow);
            }

            if (flag1) {
                if (flag2) {
                    guiGraphics.method_51739(class_1921.method_51785(), j1, k - 1, j1 + 1, k + 1 + 9, -3092272);
                } else {
                    guiGraphics.method_51433(this.font, "_", j1, k, l1, this.textShadow);
                }
            }

            if (i1 != i) {
                int k1 = j + this.font.method_1727(s.substring(0, i1));
                this.renderHighlight(guiGraphics, j1, k - 1, k1 - 1, k + 1 + 9);
            }
        }

    }

    private void renderHighlight(class_332 guiGraphics, int minX, int minY, int maxX, int maxY) {
        int j;
        if (minX < maxX) {
            j = minX;
            minX = maxX;
            maxX = j;
        }

        if (minY < maxY) {
            j = minY;
            minY = maxY;
            maxY = j;
        }

        if (maxX > this.method_46426() + this.field_22758) {
            maxX = this.method_46426() + this.field_22758;
        }

        if (minX > this.method_46426() + this.field_22758) {
            minX = this.method_46426() + this.field_22758;
        }

        guiGraphics.method_51739(class_1921.method_51786(), minX, minY, maxX, maxY, -16776961);
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        if (this.value.length() > length) {
            this.value = this.value.substring(0, length);
            this.onValueChange(this.value);
        }

    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean enableBackgroundDrawing) {
        this.bordered = enableBackgroundDrawing;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setTextColorUneditable(int color) {
        this.textColorUneditable = color;
    }

    public void method_25365(boolean focused) {
        if (this.canLoseFocus || focused) {
            super.method_25365(focused);
            if (focused) {
                this.focusedTime = class_156.method_658();
            }
        }

    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean enabled) {
        this.isEditable = enabled;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.field_22758 - 8 : this.field_22758;
    }

    public void setHighlightPos(int position) {
        this.highlightPos = class_3532.method_15340(position, 0, this.value.length());
        this.scrollTo(this.highlightPos);
    }

    private void scrollTo(int position) {
        if (this.font != null) {
            this.displayPos = Math.min(this.displayPos, this.value.length());
            int i = this.getInnerWidth();
            String s = this.font.method_27523(this.value.substring(this.displayPos), i);
            int j = s.length() + this.displayPos;
            if (position == this.displayPos) {
                this.displayPos -= this.font.method_27524(this.value, i, true).length();
            }

            if (position > j) {
                this.displayPos += position - j;
            } else if (position <= this.displayPos) {
                this.displayPos -= this.displayPos - position;
            }

            this.displayPos = class_3532.method_15340(this.displayPos, 0, this.value.length());
        }

    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void setVisible(boolean isVisible) {
        this.field_22764 = isVisible;
    }

    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public int getScreenX(int charNum) {
        return charNum > this.value.length() ? this.method_46426() : this.method_46426() + this.font.method_1727(this.value.substring(0, charNum));
    }

    public void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, this.method_25360());
    }

    public void setHint(class_2561 hint) {
        this.hint = hint;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public boolean getTextShadow() {
        return this.textShadow;
    }


}
