package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.Constants;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.common.util.RaycastHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class PlaceSchematicScreen extends class_437 {

    public final String holdToFocus = "nuggets.gui.toolmenu.focusKey";

    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;

    protected int w;
    protected int h;
    public List<ToolType> tools = new ArrayList<>();
    public RenderStructureHandler renderStructureHandler;
    public BiFunction<class_1657, StructureRenderData, List<ToolType>> setupToolsFunc;
    public class_304 focusKey;

    public PlaceSchematicScreen(class_304 focusKey, RenderStructureHandler renderStructureHandler, StructureRenderData data, BiFunction<class_1657, StructureRenderData, List<ToolType>> setupToolsFunc) {
        super(class_2561.method_43470("Tool Selection"));
        this.focusKey = focusKey;
        this.renderStructureHandler = renderStructureHandler;
        this.field_22787 = class_310.method_1551();
        focused = false;
        yOffset = 0;
        selection = 0;
        initialized = false;
        h = 34;
        tools.add(new PlaceTool(data, this));
        this.setupToolsFunc = setupToolsFunc;
    }

    public void setTools(List<ToolType> tools){
        this.tools = tools;
    }

    public void setSelectedElement(ToolType tool) {
        if (!tools.contains(tool))
            return;
        selection = tools.indexOf(tool);
    }

    public ToolType getSelectedElement(){
        return tools.get(selection);
    }

    public void cycle(int direction) {
        selection += (direction < 0) ? 1 : -1;
        selection = (selection + tools.size()) % tools.size();
    }

    private void draw(class_332 graphics, float partialTicks) {
        w = Math.max(tools.size() * 50 + 32, 220);
        class_4587 matrixStack = graphics.method_51448();
        class_1041 mainWindow = field_22787.method_22683();
        if (!initialized)
            method_25423(field_22787, mainWindow.method_4486(), mainWindow.method_4502());

        int x = (mainWindow.method_4486() - w) / 2 + 14;
        int y = mainWindow.method_4502() - h - 34;

        matrixStack.method_22903();
        matrixStack.method_46416(0, -yOffset, focused ? 100 : 0);

        graphics.method_25290(Constants.prefix("textures/gui/hud_background.png"), x - 15, y, 0, 0, w, h, 16, 16);

        float toolTipAlpha = yOffset / 10;
        List<class_2561> toolTip = tools.get(selection)
                .getDescription();

        if (toolTipAlpha > 0.25f) {
            graphics.method_25290(Constants.prefix("textures/gui/hud_background.png"), x - 15, y + 16, 0, 0, w, h, 16, 16);
            if (!toolTip.isEmpty())
                GuiHelpers.drawOutlinedText(field_22787.field_1772, graphics, toolTip.get(0), x - 10, y + 38);
            if (toolTip.size() > 1)
                GuiHelpers.drawOutlinedText(field_22787.field_1772, graphics, toolTip.get(1), x - 10, y + 50);
        }

        if (tools.size() > 1) {
            String keyName = focusKey.method_16007().getString();
            int width = field_22787.method_22683().method_4486();
            if (!focused)
                GuiHelpers.drawCenteredOutlinedText(field_22787.field_1772, graphics, class_2561.method_43469(holdToFocus, keyName), width / 2, y - 10);
            else {
                GuiHelpers.drawCenteredOutlinedText(field_22787.field_1772, graphics, class_2561.method_43471("nuggets.scroll"), width / 2, y - 10);
            }
        } else {
            GuiHelpers.drawCenteredOutlinedText(field_22787.field_1772, graphics, class_2561.method_43471("nuggets.place_description"), field_22789 / 2, y - 10);
            x += 65;
        }


        for (int i = 0; i < tools.size(); i++) {
            matrixStack.method_22903();

            if (i == selection) {
                matrixStack.method_46416(0, -10, 0);

                GuiHelpers.drawCenteredOutlinedText(field_22787.field_1772, graphics, tools.get(i)
                        .getDisplayName(), x + i * 50 + 26, y + 28);
            }
            class_2960 icon = tools.get(i)
                    .getIcon();

            graphics.method_25290(icon,  x + i * 50 + 16, y + 11, 0, 0, 16, 16, 16, 16);

            matrixStack.method_22909();
        }

        matrixStack.method_22909();
    }

    public void update() {
        if (focused)
            yOffset += (10 - yOffset) * .1f;
        else
            yOffset *= .9f;
    }

    public boolean scroll(double delta) {
        if(focused){
            cycle((int) delta);
            return true;
        }else if(method_25441()){
            return tools.get(selection)
                    .handleMouseWheel(delta);
        }
        return false;
    }

    public void renderPassive(class_332 graphics, float partialTicks) {
        draw(graphics, partialTicks);
    }

    @Override
    public void method_25419() {
       // callback.accept(tools.get(selection));
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        initialized = true;
    }

    public static class DeleteTool extends ToolType {
        public Consumer<DeleteTool> onClickConsumer;
        public DeleteTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen, Consumer<DeleteTool> onClickConsumer) {
            super(class_2561.method_43471("nuggets.delete_tool"), Constants.prefix("textures/gui/visualizer_trash.png"), structureData, placeSchematicScreen);
            this.onClickConsumer = onClickConsumer;
        }

        @Override
        public void onClick() {
            onClickConsumer.accept(this);
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.delete_description"));
            return list;
        }
    }

    public static class MoveHorizontalTool extends ToolType {

        public MoveHorizontalTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            super(class_2561.method_43471("nuggets.move_horizontal_tool"), Constants.prefix("textures/gui/visualizer_icon_horizontal.png"), structureData, placeSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            class_2350 direction = class_310.method_1551().field_1724.method_58149();
            class_2338 offset = new class_2338((int) delta * direction.method_10148(), 0, (int) delta * direction.method_10165());
            structureData.anchorPos = structureData.anchorPos.method_10081(offset);
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.move_horizontal_description"));
            return list;
        }
    }

    public static class MoveVerticalTool extends ToolType {

        public MoveVerticalTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            super(class_2561.method_43471("nuggets.move_vertical_tool"), Constants.prefix("textures/gui/visualizer_icon_vertical.png"), structureData, placeSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            if(structureData == null || structureData.anchorPos == null){
                return false;
            }
            structureData.anchorPos = structureData.anchorPos.method_10081(new class_2338(0, (int) delta, 0));
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.move_vertical_description"));
            return list;
        }
    }

    public static class MirrorTool extends ToolType {

        public MirrorTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            super(class_2561.method_43471("nuggets.mirror_tool"), Constants.prefix("textures/gui/visualizer_icon_mirror.png"), structureData, placeSchematicScreen);
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            structureData.flip();
            structureData.lastRenderPos = null;
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.mirror_description"));
            return list;
        }
    }


    public static class ConfirmTool extends ToolType{
        public Consumer<ConfirmTool> onClickConsumer;

        public ConfirmTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen, Consumer<ConfirmTool> onClickConsumer) {
            super(class_2561.method_43471("nuggets.confirm_tool"), Constants.prefix("textures/gui/visualizer_icon_confirm.png"), structureData, placeSchematicScreen);
            this.onClickConsumer = onClickConsumer;
        }

        @Override
        public void onClick() {
            onClickConsumer.accept(this);
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.confirm_description"));
            return list;
        }
    }

    public static class PrintTool extends ToolType{
        public Consumer<PrintTool> onClickConsumer;
        public PrintTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen, Consumer<PrintTool> onClickConsumer) {
            super(class_2561.method_43471("nuggets.print_tool"), Constants.prefix("textures/gui/visualizer_print.png"), structureData, placeSchematicScreen);
            this.onClickConsumer = onClickConsumer;
        }

        @Override
        public void onClick() {
            onClickConsumer.accept(this);
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.print_description"));
            return list;
        }
    }


    public static class RotateTool extends ToolType{

        public RotateTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            super(class_2561.method_43471("nuggets.rotate_tool"), Constants.prefix("textures/gui/visualizer_icon_rotate.png"), structureData, placeSchematicScreen);
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.rotate_description"));
            return list;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            if (structureData == null) {
                return false;
            }
            structureData.rotate(delta > 0 ? class_2470.field_11463 : class_2470.field_11465);
            structureData.lastRenderPos = null;
            return true;
        }
    }

    public static class PlaceTool extends ToolType{


        public PlaceTool(StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen) {
            super(class_2561.method_43471("nuggets.place_tool"), Constants.prefix("textures/gui/visualizer_icon_place.png"), structureData, placeSchematicScreen);
        }

        @Override
        List<class_2561> getDescription() {
            List<class_2561> list = new ArrayList<>();
            list.add(class_2561.method_43471("nuggets.place_description"));
            return list;
        }

        @Override
        public void onClick() {
            structureData.anchorPos = RaycastHelper.getLookingAt(structureData.distanceFromCameraCast, class_310.method_1551().field_1724, true).method_17777();
            placeSchematicScreen.setTools(placeSchematicScreen.setupToolsFunc.apply(class_310.method_1551().field_1724, structureData));
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            if(structureData == null){
                return false;
            }
            if(delta > 0){
                structureData.distanceFromCameraCast += 1;
            }else{
                structureData.distanceFromCameraCast -= 1;
            }
            return true;
        }
    }



    public abstract static class ToolType{

        public class_2561 name;
        public class_2960 icon;
        public StructureRenderData structureData;
        public PlaceSchematicScreen placeSchematicScreen;

        public ToolType(class_2561 name, class_2960 icon, StructureRenderData structureData, PlaceSchematicScreen placeSchematicScreen){
            this.name = name;
            this.icon = icon;
            this.structureData = structureData;
            this.placeSchematicScreen = placeSchematicScreen;
        }

        public void onClick(){

        }


        public class_2561 getDisplayName(){
            return name;
        }

        abstract List<class_2561> getDescription();

        public class_2960 getIcon(){
            return icon;
        }

        public boolean handleMouseWheel(double delta){
            return false;
        }
    }

}
