/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.common.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;

public class NuggetCodecs {
    public static final StreamCodec<RegistryFriendlyByteBuf, Vec3> VEC_STREAM = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeDouble(pValue.x);
        pBuffer.writeDouble(pValue.y);
        pBuffer.writeDouble(pValue.z);
    }, pBuffer -> new Vec3(pBuffer.readDouble(), pBuffer.readDouble(), pBuffer.readDouble()));

    public static <T> Tag encode(HolderLookup.Provider provider, Codec<T> codec, T value) {
        return (Tag)codec.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), value).getOrThrow();
    }

    public static <T> Tag encode(Codec<T> codec, T value) {
        return (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, value).getOrThrow();
    }

    public static <T> T decode(Codec<T> codec, Tag tag) {
        return (T)codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow();
    }

    public static <T> T decode(HolderLookup.Provider provider, Codec<T> codec, Tag tag) {
        return (T)codec.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow();
    }
}

