/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.nuggets.common.registry.RegistryHelper;
import com.hollingsworth.nuggets.datagen.SimpleDataProvider;
import com.hollingsworth.nuggets.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.nuggets.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.nuggets.datagen.patchouli.PatchouliRecord;
import com.hollingsworth.nuggets.datagen.patchouli.TextPage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public abstract class PatchouliProvider
extends SimpleDataProvider {
    public List<PatchouliRecord> pages = new ArrayList<PatchouliRecord>();
    public String modId;
    public String bookName;

    public PatchouliProvider(String modId, String bookName, DataGenerator generatorIn, Path outputPath) {
        super(generatorIn, outputPath);
        this.modId = modId;
    }

    public abstract void addEntries(List<PatchouliRecord> var1);

    public String getLangPath(String name, int count) {
        return this.modId + ".page" + count + "." + name;
    }

    public String getLangPath(String name) {
        return this.modId + ".page." + name;
    }

    public PatchouliRecord addPage(PatchouliBuilder builder, Path path) {
        return this.addPage(new PatchouliRecord(builder, path));
    }

    public PatchouliRecord addPage(PatchouliRecord patchouliPage) {
        this.pages.add(patchouliPage);
        return patchouliPage;
    }

    public PatchouliBuilder buildBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = new PatchouliBuilder(category, item.asItem().getDescriptionId()).withIcon((ItemLike)item.asItem()).withPage(new TextPage("ars_nouveau.page." + RegistryHelper.getRegistryName(item.asItem()).getPath()));
        if (recipePage != null) {
            builder.withPage(recipePage);
        }
        return builder;
    }

    public PatchouliRecord addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = this.buildBasicItem(item, category, recipePage);
        return this.addPage(new PatchouliRecord(builder, this.getPath(category, RegistryHelper.getRegistryName(item.asItem()))));
    }

    public Path getPath(ResourceLocation category, ResourceLocation fileName) {
        return this.output.resolve("assets/" + this.modId + "/patchouli_books/" + this.bookName + "/en_us/entries/" + category.getPath() + "/" + fileName.getPath() + ".json");
    }

    public Path getPath(ResourceLocation category, String fileName) {
        return this.output.resolve("assets/" + this.modId + "/patchouli_books/" + this.bookName + "/en_us/entries/" + category.getPath() + "/" + fileName + ".json");
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addEntries(this.pages);
        for (PatchouliRecord patchouliPage : this.pages) {
            this.saveStable(pOutput, (JsonElement)patchouliPage.build(), patchouliPage.path());
        }
    }

    public String getName() {
        return "Patchouli";
    }
}

