/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.gui;

import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.client.gui.ITooltipRenderer;
import com.hollingsworth.nuggets.client.gui.NestedWidgets;
import com.hollingsworth.nuggets.mixin.ScreenAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class BaseScreen
extends Screen {
    public int maxScale;
    public float scaleFactor;
    public int screenLeft;
    public int screenTop;
    public int screenRight;
    public int screenBottom;
    public int fullWidth;
    public int fullHeight;
    public ResourceLocation background;
    protected Map<NestedWidgets, List<AbstractWidget>> nestedWidgetMap = new Reference2ObjectOpenHashMap();

    public BaseScreen(Component titleIn, int fullWidth, int fullHeight, ResourceLocation background) {
        super(titleIn);
        this.fullHeight = fullHeight;
        this.fullWidth = fullWidth;
        this.background = background;
    }

    public void init() {
        super.init();
        this.maxScale = this.getMaxAllowedScale();
        this.scaleFactor = 1.0f;
        this.screenLeft = this.width / 2 - this.fullWidth / 2;
        this.screenTop = this.height / 2 - this.fullHeight / 2;
        this.screenRight = this.width / 2 + this.fullWidth / 2;
        this.screenBottom = this.height / 2 + this.fullHeight / 2;
    }

    public void drawTooltip(GuiGraphics stack, int mouseX, int mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (!tooltip.isEmpty()) {
            stack.renderTooltip(this.font, tooltip, Optional.ofNullable(this.getClientImageTooltip(mouseX, mouseY)), mouseX, mouseY);
        }
    }

    public void collectTooltips(GuiGraphics stack, int mouseX, int mouseY, List<Component> tooltip) {
        for (Renderable renderable : this.renderablesList()) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)renderable;
            if (!(renderable instanceof ITooltipRenderer)) continue;
            ITooltipRenderer tooltipProvider = (ITooltipRenderer)renderable;
            if (!GuiHelpers.isMouseInRelativeRange(mouseX, mouseY, widget) || !widget.visible) continue;
            tooltipProvider.gatherTooltips(stack, mouseX, mouseY, tooltip);
        }
    }

    protected TooltipComponent getClientImageTooltip(int mouseX, int mouseY) {
        return null;
    }

    public void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawScreenAfterScale(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)this.screenLeft, (float)this.screenTop, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        this.drawForegroundElements(mouseX, mouseY, partialTicks);
        poseStack.popPose();
        for (Renderable renderable : this.renderablesList()) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.drawTooltip(graphics, mouseX, mouseY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        if (this.scaleFactor != 1.0f) {
            matrixStack.scale(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(graphics, mouseX, mouseY, partialTicks);
        matrixStack.popPose();
    }

    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blit(this.background, 0, 0, 0.0f, 0.0f, this.fullWidth, this.fullHeight, this.fullWidth, this.fullHeight);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private int getMaxAllowedScale() {
        return this.minecraft.getWindow().calculateScale(0, this.minecraft.isEnforceUnicode());
    }

    protected void renderBlurredBackground(float pPartialTick) {
    }

    public List<Renderable> renderablesList() {
        return ((ScreenAccessor)((Object)this)).getRenderables();
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        ArrayList<AbstractWidget> afterParent = new ArrayList<AbstractWidget>();
        ArrayList<AbstractWidget> beforeParent = new ArrayList<AbstractWidget>();
        if (widget instanceof NestedWidgets) {
            NestedWidgets nestedRenderables = (NestedWidgets)widget;
            nestedRenderables.addBeforeParent(beforeParent);
            for (AbstractWidget renderable : beforeParent) {
                super.addRenderableWidget((GuiEventListener)renderable);
            }
            nestedRenderables.addAfterParent(afterParent);
            ArrayList<AbstractWidget> allWidgets = new ArrayList<AbstractWidget>();
            allWidgets.addAll(afterParent);
            allWidgets.addAll(beforeParent);
            this.nestedWidgetMap.put(nestedRenderables, allWidgets);
        }
        GuiEventListener added = super.addRenderableWidget(widget);
        for (AbstractWidget renderable : afterParent) {
            super.addRenderableWidget((GuiEventListener)renderable);
        }
        return (T)added;
    }

    protected void removeWidget(GuiEventListener pListener) {
        if (pListener instanceof NestedWidgets) {
            NestedWidgets nestedWidgets = (NestedWidgets)pListener;
            List<AbstractWidget> children = this.nestedWidgetMap.get(nestedWidgets);
            if (children != null) {
                for (AbstractWidget renderable : children) {
                    if (renderable == null) continue;
                    super.removeWidget((GuiEventListener)renderable);
                }
            }
            this.nestedWidgetMap.remove(nestedWidgets);
        }
        super.removeWidget(pListener);
    }
}

