/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.rendering.StatePos;
import com.hollingsworth.nuggets.client.rendering.TagPos;
import com.hollingsworth.nuggets.mixin.StructureTemplateAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructureRenderData {
    public ArrayList<StatePos> statePosCache;
    public BlockPos anchorPos;
    public BlockPos lastRenderPos;
    public double distanceFromCameraCast = 25.0;
    public StructureTemplate structureTemplate;
    public Rotation rotation;
    public Mirror mirror;
    public boolean flipped = false;
    public BoundingBox boundingBox;
    public StructurePlaceSettings structurePlaceSettings;

    public StructureRenderData(StructureTemplate template) {
        StructureTemplateAccessor accessor = (StructureTemplateAccessor)this.structureTemplate;
        List<StructureTemplate.Palette> palettes = accessor.getPalettes();
        if (palettes.isEmpty()) {
            return;
        }
        StructureTemplate.Palette palette = palettes.get(0);
        this.statePosCache = new ArrayList();
        this.structureTemplate = template;
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.blocks()) {
            this.statePosCache.add(new StatePos(blockInfo.state(), blockInfo.pos()));
        }
        this.structurePlaceSettings = new StructurePlaceSettings();
        this.boundingBox = this.structureTemplate.getBoundingBox(this.structurePlaceSettings, new BlockPos(0, 0, 0));
    }

    public void rotate(Rotation rotateBy) {
        this.rotation = this.rotation.getRotated(rotateBy);
        this.statePosCache = StatePos.rotate(this.statePosCache, new ArrayList<TagPos>(), rotateBy);
        this.boundingBox = this.structureTemplate.getBoundingBox(this.structurePlaceSettings.setRotation(this.rotation), new BlockPos(0, 0, 0));
    }

    public void mirror(boolean mirror) {
        this.mirror = mirror ? Mirror.FRONT_BACK : Mirror.NONE;
        this.boundingBox = this.structureTemplate.getBoundingBox(this.structurePlaceSettings.setMirror(this.mirror), new BlockPos(0, 0, 0));
    }

    public void flip() {
        this.flipped = !this.flipped;
        this.mirror(this.flipped);
    }
}

