/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.nuggets.client.area_capture;

import com.hollingsworth.nuggets.client.area_capture.PlaceSchematicScreen;
import com.hollingsworth.nuggets.client.area_capture.StructureRenderData;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;

public class RenderStructureHandler {
    private StructureRenderData placingData;
    private PlaceSchematicScreen schematicTools;

    public RenderStructureHandler(KeyMapping focusKey, StructureRenderData placingData, BiFunction<Player, StructureRenderData, List<PlaceSchematicScreen.ToolType>> setupTools) {
        this.placingData = placingData;
        this.schematicTools = new PlaceSchematicScreen(focusKey, this, placingData, setupTools);
    }

    public void tick() {
        if (this.placingData == null) {
            return;
        }
        this.schematicTools.update();
    }

    public void rightClickEvent() {
        if (this.placingData == null) {
            return;
        }
        this.schematicTools.getSelectedElement().onClick();
    }

    public void toolKeyHit(boolean keyPressed) {
        if (this.placingData == null) {
            return;
        }
        if (keyPressed && !this.schematicTools.focused) {
            this.schematicTools.focused = true;
        }
        if (!keyPressed && this.schematicTools.focused) {
            this.schematicTools.focused = false;
            this.schematicTools.onClose();
        }
    }

    public boolean mouseScrolled(double delta) {
        if (this.placingData == null) {
            return false;
        }
        return this.schematicTools.scroll(delta);
    }

    public void renderInstructions(GuiGraphics graphics, Window window) {
        if (this.placingData == null) {
            return;
        }
        this.schematicTools.renderPassive(graphics, 0.0f);
    }
}

