/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.BulkScorer;
import org.apache.lucene.ars_nouveau.search.Explanation;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.MatchAllDocsQuery;
import org.apache.lucene.ars_nouveau.search.Matches;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.ScorerSupplier;
import org.apache.lucene.ars_nouveau.search.Weight;

public final class IndexOrDocValuesQuery
extends Query {
    private final Query indexQuery;
    private final Query dvQuery;

    public IndexOrDocValuesQuery(Query indexQuery, Query dvQuery) {
        this.indexQuery = indexQuery;
        this.dvQuery = dvQuery;
    }

    public Query getIndexQuery() {
        return this.indexQuery;
    }

    public Query getRandomAccessQuery() {
        return this.dvQuery;
    }

    @Override
    public String toString(String field) {
        return "IndexOrDocValuesQuery(indexQuery=" + this.indexQuery.toString(field) + ", dvQuery=" + this.dvQuery.toString(field) + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        IndexOrDocValuesQuery that = (IndexOrDocValuesQuery)obj;
        return this.indexQuery.equals(that.indexQuery) && this.dvQuery.equals(that.dvQuery);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.indexQuery.hashCode();
        h = 31 * h + this.dvQuery.hashCode();
        return h;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query indexRewrite = this.indexQuery.rewrite(indexSearcher);
        Query dvRewrite = this.dvQuery.rewrite(indexSearcher);
        if (indexRewrite.getClass() == MatchAllDocsQuery.class || dvRewrite.getClass() == MatchAllDocsQuery.class) {
            return new MatchAllDocsQuery();
        }
        if (this.indexQuery != indexRewrite || this.dvQuery != dvRewrite) {
            return new IndexOrDocValuesQuery(indexRewrite, dvRewrite);
        }
        return this;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, this);
        this.indexQuery.visit(v);
        this.dvQuery.visit(v);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight indexWeight = this.indexQuery.createWeight(searcher, scoreMode, boost);
        final Weight dvWeight = this.dvQuery.createWeight(searcher, scoreMode, boost);
        return new Weight(this, this){

            @Override
            public Matches matches(LeafReaderContext context, int doc) throws IOException {
                return dvWeight.matches(context, doc);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return dvWeight.explain(context, doc);
            }

            @Override
            public int count(LeafReaderContext context) throws IOException {
                int count = indexWeight.count(context);
                if (count != -1) {
                    return count;
                }
                return dvWeight.count(context);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final ScorerSupplier indexScorerSupplier = indexWeight.scorerSupplier(context);
                final ScorerSupplier dvScorerSupplier = dvWeight.scorerSupplier(context);
                if (indexScorerSupplier == null || dvScorerSupplier == null) {
                    return null;
                }
                return new ScorerSupplier(this){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        long threshold = this.cost() >>> 3;
                        if (threshold <= leadCost) {
                            return indexScorerSupplier.get(leadCost);
                        }
                        return dvScorerSupplier.get(leadCost);
                    }

                    @Override
                    public BulkScorer bulkScorer() throws IOException {
                        return indexScorerSupplier.bulkScorer();
                    }

                    @Override
                    public long cost() {
                        return indexScorerSupplier.cost();
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return indexWeight.isCacheable(ctx);
            }
        };
    }
}

