/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.index.DocValues;
import org.apache.lucene.ars_nouveau.index.DocValuesSkipper;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.SortedDocValues;
import org.apache.lucene.ars_nouveau.index.SortedSetDocValues;
import org.apache.lucene.ars_nouveau.index.Terms;
import org.apache.lucene.ars_nouveau.index.TermsEnum;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.ConstantScoreQuery;
import org.apache.lucene.ars_nouveau.search.ConstantScoreScorer;
import org.apache.lucene.ars_nouveau.search.ConstantScoreWeight;
import org.apache.lucene.ars_nouveau.search.DisjunctionMatchesIterator;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.search.DocValuesRangeIterator;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.Matches;
import org.apache.lucene.ars_nouveau.search.MatchesUtils;
import org.apache.lucene.ars_nouveau.search.MultiTermQuery;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.ScorerSupplier;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;
import org.apache.lucene.ars_nouveau.search.Weight;
import org.apache.lucene.ars_nouveau.util.LongBitSet;

public final class DocValuesRewriteMethod
extends MultiTermQuery.RewriteMethod {
    @Override
    public Query rewrite(IndexSearcher indexSearcher, MultiTermQuery query) {
        return new ConstantScoreQuery(new MultiTermQueryDocValuesWrapper(query));
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass();
    }

    public int hashCode() {
        return 641;
    }

    static class MultiTermQueryDocValuesWrapper
    extends Query {
        protected final MultiTermQuery query;

        protected MultiTermQueryDocValuesWrapper(MultiTermQuery query) {
            this.query = query;
        }

        @Override
        public String toString(String field) {
            return this.query.toString(field);
        }

        @Override
        public final boolean equals(Object other) {
            return this.sameClassAs(other) && this.query.equals(((MultiTermQueryDocValuesWrapper)other).query);
        }

        @Override
        public final int hashCode() {
            return 31 * this.classHash() + this.query.hashCode();
        }

        public final String getField() {
            return this.query.getField();
        }

        @Override
        public void visit(QueryVisitor visitor) {
            if (visitor.acceptField(this.query.getField())) {
                visitor.getSubVisitor(BooleanClause.Occur.FILTER, this.query);
            }
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            return new ConstantScoreWeight(this, boost){

                @Override
                public Matches matches(LeafReaderContext context, int doc) throws IOException {
                    SortedSetDocValues values = DocValues.getSortedSet(context.reader(), query.field);
                    return MatchesUtils.forField(query.field, () -> DisjunctionMatchesIterator.fromTermsEnum(context, doc, query, query.field, this.getTermsEnum(values)));
                }

                private TermsEnum getTermsEnum(final SortedSetDocValues values) throws IOException {
                    return query.getTermsEnum(new Terms(this){

                        @Override
                        public TermsEnum iterator() throws IOException {
                            return values.termsEnum();
                        }

                        @Override
                        public long getSumTotalTermFreq() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public long getSumDocFreq() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public int getDocCount() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public long size() {
                            return -1L;
                        }

                        @Override
                        public boolean hasFreqs() {
                            return false;
                        }

                        @Override
                        public boolean hasOffsets() {
                            return false;
                        }

                        @Override
                        public boolean hasPositions() {
                            return false;
                        }

                        @Override
                        public boolean hasPayloads() {
                            return false;
                        }
                    });
                }

                @Override
                public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                    final SortedSetDocValues values = DocValues.getSortedSet(context.reader(), query.field);
                    if (values.getValueCount() == 0L) {
                        return null;
                    }
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            TermsEnum termsEnum = this.getTermsEnum(values);
                            assert (termsEnum != null);
                            if (termsEnum.next() == null) {
                                return new ConstantScoreScorer(this.score(), scoreMode, DocIdSetIterator.empty());
                            }
                            DocValuesSkipper skipper = context.reader().getDocValuesSkipper(query.field);
                            final LongBitSet termSet = new LongBitSet(values.getValueCount());
                            long minOrd = termsEnum.ord();
                            assert (minOrd >= 0L);
                            long maxOrd = -1L;
                            do {
                                long ord = termsEnum.ord();
                                assert (ord >= 0L && ord > maxOrd);
                                maxOrd = ord;
                                termSet.set(ord);
                            } while (termsEnum.next() != null);
                            if (skipper != null && (minOrd > skipper.maxValue() || maxOrd < skipper.minValue())) {
                                return new ConstantScoreScorer(this.score(), scoreMode, DocIdSetIterator.empty());
                            }
                            final SortedDocValues singleton = DocValues.unwrapSingleton(values);
                            final long max = maxOrd;
                            TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator(this, singleton){

                                @Override
                                public boolean matches() throws IOException {
                                    return termSet.get(singleton.ordValue());
                                }

                                @Override
                                public float matchCost() {
                                    return 3.0f;
                                }
                            } : new TwoPhaseIterator(values){

                                @Override
                                public boolean matches() throws IOException {
                                    for (int i = 0; i < values.docValueCount(); ++i) {
                                        long value = values.nextOrd();
                                        if (value > max) {
                                            return false;
                                        }
                                        if (!termSet.get(value)) continue;
                                        return true;
                                    }
                                    return false;
                                }

                                @Override
                                public float matchCost() {
                                    return 3.0f;
                                }
                            };
                            if (skipper != null) {
                                iterator = new DocValuesRangeIterator(iterator, skipper, minOrd, maxOrd, true);
                            }
                            return new ConstantScoreScorer(this.score(), scoreMode, iterator);
                        }

                        @Override
                        public long cost() {
                            return values.cost();
                        }
                    };
                }

                @Override
                public boolean isCacheable(LeafReaderContext ctx) {
                    return DocValues.isCacheable(ctx, query.field);
                }
            };
        }
    }
}

