/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.xml.builders;

import org.apache.lucene.ars_nouveau.queryparser.xml.DOMUtils;
import org.apache.lucene.ars_nouveau.queryparser.xml.ParserException;
import org.apache.lucene.ars_nouveau.queryparser.xml.QueryBuilder;
import org.apache.lucene.ars_nouveau.queryparser.xml.QueryBuilderFactory;
import org.apache.lucene.ars_nouveau.search.BoostQuery;
import org.apache.lucene.ars_nouveau.search.ConstantScoreQuery;
import org.apache.lucene.ars_nouveau.search.Query;
import org.w3c.dom.Element;

public class ConstantScoreQueryBuilder
implements QueryBuilder {
    private final QueryBuilderFactory queryFactory;

    public ConstantScoreQueryBuilder(QueryBuilderFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        Element queryElem = DOMUtils.getFirstChildOrFail(e);
        Query q = new ConstantScoreQuery(this.queryFactory.getQuery(queryElem));
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        if (boost != 1.0f) {
            q = new BoostQuery(q, boost);
        }
        return q;
    }
}

