/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.LightBlock;
import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.common.world.feature.LightFeature;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTrunkPlacer;
import com.hollingsworth.arsnouveau.common.world.tree.SupplierBlockStateProvider;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class WorldgenRegistry {
    public static final DeferredRegister<Feature<?>> FEAT_REG = DeferredRegister.create((Registry)BuiltInRegistries.FEATURE, (String)"ars_nouveau");
    public static final DeferredHolder<Feature<?>, LightFeature> LIGHT_FEATURE = FEAT_REG.register("light_feature", () -> new LightFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_CASCADING_TREE = WorldgenRegistry.registerConfKey("cascading_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_BLAZING_TREE = WorldgenRegistry.registerConfKey("blazing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_VEXING_TREE = WorldgenRegistry.registerConfKey("vexing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_FLOURISHING_TREE = WorldgenRegistry.registerConfKey("flourishing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_CONFIGURED_CASCADING_TREE = WorldgenRegistry.registerConfKey("natural_cascading_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_CONFIGURED_BLAZING_TREE = WorldgenRegistry.registerConfKey("natural_blazing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_CONFIGURED_VEXING_TREE = WorldgenRegistry.registerConfKey("natural_vexing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_CONFIGURED_FLOURISHING_TREE = WorldgenRegistry.registerConfKey("natural_flourishing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_BERRY_BUSH = WorldgenRegistry.registerConfKey("patch_berry");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_LIGHTS = WorldgenRegistry.registerConfKey("lights");
    public static final ResourceKey<PlacedFeature> PLACED_NATURAL_CASCADING_TREE = WorldgenRegistry.registerPlacedKey("placed_cascading_tree");
    public static final ResourceKey<PlacedFeature> PLACED_NATURAL_BLAZING_TREE = WorldgenRegistry.registerPlacedKey("placed_blazing_tree");
    public static final ResourceKey<PlacedFeature> PLACED_NATURAL_VEXING_TREE = WorldgenRegistry.registerPlacedKey("placed_vexing_tree");
    public static final ResourceKey<PlacedFeature> PLACED_NATURAL_FLOURISHING_TREE = WorldgenRegistry.registerPlacedKey("placed_flourishing_tree");
    public static final ResourceKey<PlacedFeature> PLACED_BERRY_BUSH = WorldgenRegistry.registerPlacedKey("placed_berry_bush");
    public static final ResourceKey<PlacedFeature> PLACED_MIX_ARCHWOODS = WorldgenRegistry.registerPlacedKey("placed_mixed_archwoods");
    public static final ResourceKey<PlacedFeature> PLACED_DENSE_ARCHWOODS = WorldgenRegistry.registerPlacedKey("placed_dense_archwoods");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MIXED_ARCHWOODS = WorldgenRegistry.registerConfKey("mixed_archwoods");
    public static final ResourceKey<PlacedFeature> PLACED_MOJANK_GRASS = WorldgenRegistry.registerPlacedKey("mojang_grass");
    public static final ResourceKey<PlacedFeature> PLACED_MOJANK_FLOWERS = WorldgenRegistry.registerPlacedKey("mojang_flowers");
    public static final ResourceKey<PlacedFeature> PLACED_LIGHTS = WorldgenRegistry.registerPlacedKey("placed_lights");

    public static ResourceKey<Feature<?>> registerFeatureKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.FEATURE, (ResourceLocation)ArsNouveau.prefix(name));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerConfKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ArsNouveau.prefix(name));
    }

    public static ResourceKey<PlacedFeature> registerPlacedKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ArsNouveau.prefix(name));
    }

    public static void bootstrapConfiguredFeatures(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placed = context.lookup(Registries.PLACED_FEATURE);
        context.register(CONFIGURED_CASCADING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)WorldgenRegistry.buildTree("blue_archwood_leaves", "blue_archwood_log", false, ArsNouveau.prefix("frostaya_pod"))));
        context.register(CONFIGURED_BLAZING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)WorldgenRegistry.buildTree("red_archwood_leaves", "red_archwood_log", false, ArsNouveau.prefix("bombegranate_pod"))));
        context.register(CONFIGURED_VEXING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)WorldgenRegistry.buildTree("purple_archwood_leaves", "purple_archwood_log", false, ArsNouveau.prefix("bastion_pod"))));
        context.register(CONFIGURED_FLOURISHING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)WorldgenRegistry.buildTree("green_archwood_leaves", "green_archwood_log", false, ArsNouveau.prefix("mendosteen_pod"))));
        context.register(NATURAL_CONFIGURED_CASCADING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)WorldgenRegistry.buildTree("blue_archwood_leaves", "blue_archwood_log", true, ArsNouveau.prefix("frostaya_pod"))));
        context.register(NATURAL_CONFIGURED_BLAZING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)WorldgenRegistry.buildTree("red_archwood_leaves", "red_archwood_log", true, ArsNouveau.prefix("bombegranate_pod"))));
        context.register(NATURAL_CONFIGURED_VEXING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)WorldgenRegistry.buildTree("purple_archwood_leaves", "purple_archwood_log", true, ArsNouveau.prefix("bastion_pod"))));
        context.register(NATURAL_CONFIGURED_FLOURISHING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)WorldgenRegistry.buildTree("green_archwood_leaves", "green_archwood_log", true, ArsNouveau.prefix("mendosteen_pod"))));
        context.register(PATCH_BERRY_BUSH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)BuiltInRegistries.BLOCK.get(ArsNouveau.prefix("sourceberry_bush"))).defaultBlockState().setValue((Property)SourceBerryBush.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK))));
        context.register(MIXED_ARCHWOODS, (Object)new ConfiguredFeature(Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{placed.getOrThrow(PLACED_NATURAL_CASCADING_TREE), placed.getOrThrow(PLACED_NATURAL_BLAZING_TREE), placed.getOrThrow(PLACED_NATURAL_VEXING_TREE), placed.getOrThrow(PLACED_NATURAL_FLOURISHING_TREE)}))));
        context.register(CONFIGURED_LIGHTS, (Object)new ConfiguredFeature((Feature)((LightFeature)((Object)LIGHT_FEATURE.get())), (FeatureConfiguration)new BlockStateConfiguration(((LightBlock)BlockRegistry.LIGHT_BLOCK.get()).defaultBlockState())));
    }

    public static void bootstrapPlacedFeatures(BootstrapContext<PlacedFeature> context) {
        HolderGetter features = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(PLACED_BERRY_BUSH, (Object)new PlacedFeature((Holder)features.get(PATCH_BERRY_BUSH).get(), List.of(RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome())));
        context.register(PLACED_NATURAL_CASCADING_TREE, (Object)new PlacedFeature((Holder)features.get(NATURAL_CONFIGURED_CASCADING_TREE).get(), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistry.CASCADING_SAPLING.get())))));
        context.register(PLACED_NATURAL_BLAZING_TREE, (Object)new PlacedFeature((Holder)features.get(NATURAL_CONFIGURED_BLAZING_TREE).get(), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistry.BLAZING_SAPLING.get())))));
        context.register(PLACED_NATURAL_VEXING_TREE, (Object)new PlacedFeature((Holder)features.get(NATURAL_CONFIGURED_VEXING_TREE).get(), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistry.VEXING_SAPLING.get())))));
        context.register(PLACED_NATURAL_FLOURISHING_TREE, (Object)new PlacedFeature((Holder)features.get(NATURAL_CONFIGURED_FLOURISHING_TREE).get(), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistry.FLOURISHING_SAPLING.get())))));
        context.register(PLACED_MIX_ARCHWOODS, (Object)new PlacedFeature((Holder)features.get(MIXED_ARCHWOODS).get(), VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)Config.TREE_SPAWN_RATE))));
        context.register(PLACED_MOJANK_GRASS, (Object)new PlacedFeature((Holder)features.get(VegetationFeatures.PATCH_GRASS).get(), VegetationPlacements.worldSurfaceSquaredWithCount((int)2)));
        context.register(PLACED_MOJANK_FLOWERS, (Object)new PlacedFeature((Holder)features.get(VegetationFeatures.FLOWER_DEFAULT).get(), List.of(RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
        context.register(PLACED_LIGHTS, (Object)new PlacedFeature((Holder)features.get(CONFIGURED_LIGHTS).get(), VegetationPlacements.worldSurfaceSquaredWithCount((int)1)));
        context.register(PLACED_DENSE_ARCHWOODS, (Object)new PlacedFeature((Holder)features.get(MIXED_ARCHWOODS).get(), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)7, (float)0.01f, (int)1))));
    }

    public static TreeConfiguration buildTree(String leaves, String log, boolean natural, ResourceLocation podRegistryName) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProvider(log), (TrunkPlacer)new MagicTrunkPlacer(9, 1, 0, natural, podRegistryName.toString()), (BlockStateProvider)new SupplierBlockStateProvider(leaves), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.of((int)0, (int)0), (IntProvider)UniformInt.of((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).build();
    }
}

