/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.documentation.DocCategory;
import com.hollingsworth.arsnouveau.api.documentation.DocPlayerData;
import com.hollingsworth.arsnouveau.api.documentation.ReloadDocumentationEvent;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.builder.DocEntryBuilder;
import com.hollingsworth.arsnouveau.api.documentation.entry.ApparatusEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.ArmorUpgradeEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.CraftingEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.EnchantmentEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.EntityEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.GlyphEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.GlyphRecipeEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.ImbuementRecipeEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.PerkDiagramEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.PotionRecipeEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.SpellWriteEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.TextEntry;
import com.hollingsworth.arsnouveau.api.documentation.search.ConnectedSearch;
import com.hollingsworth.arsnouveau.api.documentation.search.Search;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ArmorUpgradeRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantmentRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.common.perk.EmptyPerk;
import com.hollingsworth.arsnouveau.common.util.Log;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;

public class Documentation {
    static List<DocEntryBuilder> pendingBuilders = new ArrayList<DocEntryBuilder>();
    static Set<DocEntry> entries = new HashSet<DocEntry>();

    public static void initOnWorldReload() {
        DocEntry entry;
        ItemStack renderStack;
        long startTime = System.nanoTime();
        entries = new HashSet<DocEntry>();
        Search.connectedSearches = new ArrayList<ConnectedSearch>();
        DocPlayerData.previousScreen = null;
        pendingBuilders = new ArrayList<DocEntryBuilder>();
        Level level = ArsNouveau.proxy.getClientWorld();
        RecipeManager manager = level.getRecipeManager();
        Block SOURCESTONE = BlockRegistry.getBlock("sourcestone");
        DocCategory MACHINES = DocumentationRegistry.CRAFTING;
        DocCategory GETTING_STARTED = DocumentationRegistry.GETTING_STARTED;
        DocCategory SPELL_CASTING = DocumentationRegistry.SPELL_CASTING;
        DocCategory EQUIPMENT = DocumentationRegistry.ITEMS;
        DocCategory AUTOMATION = DocumentationRegistry.CRAFTING;
        DocCategory RESOURCES = DocumentationRegistry.FIELD_GUIDE;
        DocCategory SOURCE = DocumentationRegistry.SOURCE;
        DocCategory ARMOR = DocumentationRegistry.ARMOR;
        DocCategory RITUALS = DocumentationRegistry.RITUAL_INDEX;
        DocCategory ENCHANTMENTS = DocumentationRegistry.ENCHANTING;
        DocCategory FAMILIARS = DocumentationRegistry.FAMILIARS;
        DocCategory MOD_NEWS = DocumentationRegistry.GETTING_STARTED;
        for (AbstractSpellPart abstractSpellPart : GlyphRegistry.getSpellpartMap().values()) {
            renderStack = abstractSpellPart.glyphItem.getDefaultInstance();
            entry = new DocEntry(abstractSpellPart.getRegistryName(), renderStack, (Component)Component.literal((String)abstractSpellPart.getLocaleName()));
            entry.addPage(GlyphEntry.create(abstractSpellPart));
            entry.withSearchTag((Component)Component.translatable((String)"ars_nouveau.keyword.glyph"));
            for (SpellSchool spellSchool : abstractSpellPart.spellSchools) {
                entry.withSearchTag(spellSchool.getTextComponent());
            }
            List<SinglePageCtor> pages = Documentation.getRecipePages(renderStack, abstractSpellPart.getRegistryName());
            entry.addPages(pages);
            DocumentationRegistry.registerEntry(Documentation.glyphCategory(abstractSpellPart.getConfigTier()), entry);
        }
        for (RitualTablet ritualTablet : RitualRegistry.getRitualItemMap().values()) {
            renderStack = ritualTablet.getDefaultInstance();
            AbstractRitual ritual = ritualTablet.ritual;
            MutableComponent title = Component.translatable((String)("item." + ritual.getRegistryName().getNamespace() + "." + ritual.getRegistryName().getPath()));
            DocEntry entry2 = new DocEntry(ritual.getRegistryName(), renderStack, (Component)title);
            entry2.addPage(TextEntry.create((Component)Component.translatable((String)ritual.getDescriptionKey()), (Component)title, renderStack));
            List<SinglePageCtor> pages = Documentation.getRecipePages(renderStack, ritual.getRegistryName());
            entry2.addPages(pages).withSearchTag((Component)Component.translatable((String)"ars_nouveau.keyword.ritual"));
            DocumentationRegistry.registerEntry(DocumentationRegistry.RITUAL_INDEX, entry2);
        }
        for (PerkItem perkItem : PerkRegistry.getPerkItemMap().values()) {
            if (perkItem.perk instanceof EmptyPerk) continue;
            renderStack = perkItem.getDefaultInstance();
            entry = new DocEntry(perkItem.perk.getRegistryName(), renderStack, perkItem.perk.getPerkName());
            entry.addPage(TextEntry.create((Component)Component.translatable((String)perkItem.perk.getDescriptionKey()), (Component)Component.literal((String)perkItem.perk.getName()), renderStack));
            entry.addPages(Documentation.getRecipePages(renderStack, RegistryHelper.getRegistryName(perkItem)));
            entry.withSearchTag((Component)Component.translatable((String)"ars_nouveau.keyword.thread"));
            DocumentationRegistry.registerEntry(DocumentationRegistry.ARMOR, entry);
        }
        for (AbstractFamiliarHolder abstractFamiliarHolder : FamiliarRegistry.getFamiliarHolderMap().values()) {
            ItemStack renderstack = abstractFamiliarHolder.getOutputItem();
            entry = new DocEntry(abstractFamiliarHolder.getRegistryName(), renderstack, (Component)Component.translatable((String)("entity.ars_nouveau." + abstractFamiliarHolder.getRegistryName().getPath())));
            entry.addPage(TextEntry.create(abstractFamiliarHolder.getLangDescription(), renderstack.getHoverName(), renderstack));
            entry.withSearchTag((Component)Component.translatable((String)"ars_nouveau.keyword.familiar"));
            DocumentationRegistry.registerEntry(DocumentationRegistry.FAMILIARS, entry);
        }
        DocEntry dowsingRod = Documentation.addBasicItem(ItemsRegistry.DOWSING_ROD, EQUIPMENT);
        DocEntry docEntry = Documentation.addPage(new DocEntryBuilder(MACHINES, BlockRegistry.IMBUEMENT_BLOCK).withSortNum(1).withIntroPage().withCraftingPages().withCraftingPages(ResourceLocation.tryParse((String)"ars_nouveau:imbuement_lapis"), ItemsRegistry.SOURCE_GEM).withCraftingPages(ResourceLocation.tryParse((String)"ars_nouveau:imbuement_amethyst"), ItemsRegistry.SOURCE_GEM).withCraftingPages(ResourceLocation.tryParse((String)"ars_nouveau:imbuement_amethyst_block"), BlockRegistry.SOURCE_GEM_BLOCK).withCraftingPages(ResourceLocation.tryParse((String)("ars_nouveau:imbuement_" + ItemsRegistry.FIRE_ESSENCE.getRegistryName())), ItemsRegistry.FIRE_ESSENCE).withCraftingPages(ResourceLocation.tryParse((String)("ars_nouveau:imbuement_" + ItemsRegistry.EARTH_ESSENCE.getRegistryName())), ItemsRegistry.EARTH_ESSENCE).withCraftingPages(ResourceLocation.tryParse((String)("ars_nouveau:imbuement_" + ItemsRegistry.WATER_ESSENCE.getRegistryName())), ItemsRegistry.WATER_ESSENCE).withCraftingPages(ResourceLocation.tryParse((String)("ars_nouveau:imbuement_" + ItemsRegistry.AIR_ESSENCE.getRegistryName())), ItemsRegistry.AIR_ESSENCE).withCraftingPages(ResourceLocation.tryParse((String)("ars_nouveau:imbuement_" + ItemsRegistry.ABJURATION_ESSENCE.getRegistryName())), ItemsRegistry.ABJURATION_ESSENCE).withCraftingPages(ResourceLocation.tryParse((String)("ars_nouveau:imbuement_" + ItemsRegistry.CONJURATION_ESSENCE.getRegistryName())), ItemsRegistry.CONJURATION_ESSENCE).withCraftingPages(ResourceLocation.tryParse((String)("ars_nouveau:imbuement_" + ItemsRegistry.MANIPULATION_ESSENCE.getRegistryName())), ItemsRegistry.MANIPULATION_ESSENCE));
        DocEntry enchantingApparatus = Documentation.addPage(new DocEntryBuilder(MACHINES, BlockRegistry.ENCHANTING_APP_BLOCK).withSortNum(2).withIntroPage().withPage(Documentation.getRecipePages(BlockRegistry.ARCANE_PEDESTAL, BlockRegistry.ARCANE_PLATFORM)).withPage(Documentation.getRecipePages(BlockRegistry.ENCHANTING_APP_BLOCK, BlockRegistry.ARCANE_CORE_BLOCK)).addConnectedSearch(BlockRegistry.ARCANE_CORE_BLOCK));
        DocEntry drygmyCharm = Documentation.addPage(new DocEntryBuilder(AUTOMATION, ItemsRegistry.DRYGMY_CHARM).withIntroPage().withCraftingPages(ItemsRegistry.DRYGMY_CHARM).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_DRYGMY.get()), Documentation.getLangPath("drygmy_charm", 2))).withPage(TextEntry.create(Documentation.getLangPath("drygmy_charm", 3), (Component)Component.translatable((String)"ars_nouveau.summoning"))).withPage(TextEntry.create(Documentation.getLangPath("drygmy_charm", 4), (Component)Component.translatable((String)"ars_nouveau.happiness"))).withPage(TextEntry.create(Documentation.getLangPath("drygmy_charm", 5), (Component)Component.translatable((String)"ars_nouveau.production"))).withCraftingPages(ItemsRegistry.GREATER_EXPERIENCE_GEM).addConnectedSearch(ItemsRegistry.DRYGMY_SHARD).addConnectedSearch(ItemsRegistry.EXPERIENCE_GEM).addConnectedSearch(ItemsRegistry.GREATER_EXPERIENCE_GEM));
        DocEntry mobJar = Documentation.addPage(new DocEntryBuilder(MACHINES, "mob_jar").withIcon(BlockRegistry.MOB_JAR).withIntroPage().withPage(TextEntry.create("ars_nouveau.page2.mob_jar", "ars_nouveau.title.mob_jar")).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.VILLAGER, (Component)Component.translatable((String)"mob_jar.villager"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.PIGLIN, (Component)Component.translatable((String)"mob_jar.piglin"))).withPage(TextEntry.create("mob_jar.allay", "mob_jar.allay.title")).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.ALLAY)).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.ENDER_DRAGON, (Component)Component.translatable((String)"mob_jar.ender_dragon"), 1.5f, -30)).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.SHEEP, (Component)Component.translatable((String)"mob_jar.sheep"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.CHICKEN, (Component)Component.translatable((String)"mob_jar.chicken"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.ARMADILLO, (Component)Component.translatable((String)"mob_jar.armadillo"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.SNIFFER, (Component)Component.translatable((String)"mob_jar.sniffer"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.COW, (Component)Component.translatable((String)"mob_jar.cow"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.MOOSHROOM, (Component)Component.translatable((String)"mob_jar.mooshroom"), 0.7f)).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.PUFFERFISH, (Component)Component.translatable((String)"mob_jar.pufferfish"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.FROG, (Component)Component.translatable((String)"mob_jar.frog"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.PANDA, (Component)Component.translatable((String)"mob_jar.panda"), 0.7f)).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.CAT, (Component)Component.translatable((String)"mob_jar.cat"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.BREEZE, (Component)Component.translatable((String)"mob_jar.breeze"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)EntityType.SNOW_GOLEM, (Component)Component.translatable((String)"mob_jar.snow_golem"))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_DUMMY.get()), (Component)Component.translatable((String)"mob_jar.dummy"))).withCraftingPages(BlockRegistry.MOB_JAR)).withRelation(ArsNouveau.prefix(RitualLib.CONTAINMENT)).withRelation(drygmyCharm);
        drygmyCharm.withRelation(mobJar);
        DocEntry amuletOfManaBoost = Documentation.addBasicItem(ItemsRegistry.AMULET_OF_MANA_BOOST, EQUIPMENT);
        DocEntry amuletOfRegen = Documentation.addBasicItem(ItemsRegistry.AMULET_OF_MANA_REGEN, EQUIPMENT);
        DocEntry beltOfLevitation = Documentation.addBasicItem(ItemsRegistry.BELT_OF_LEVITATION, EQUIPMENT);
        Documentation.addBasicItem(ItemsRegistry.BELT_OF_UNSTABLE_GIFTS, EQUIPMENT);
        DocEntry jarOfLight = Documentation.addBasicItem(ItemsRegistry.JAR_OF_LIGHT, EQUIPMENT);
        DocEntry starby = Documentation.addPage(new DocEntryBuilder(AUTOMATION, ItemsRegistry.STARBUNCLE_CHARM).withIntroPage().withCraftingPages(ItemsRegistry.STARBUNCLE_CHARM).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.STARBUNCLE_TYPE.get()), Documentation.getLangPath("starbuncle_charm", 2))).withPage(TextEntry.create(Documentation.getLangPath("starbuncle_charm", 3), (Component)Component.translatable((String)"ars_nouveau.summoning"))).withPage(TextEntry.create(Documentation.getLangPath("starbuncle_charm", 4), (Component)Component.translatable((String)"ars_nouveau.item_transport"))).withPage(TextEntry.create(Documentation.getLangPath("starbuncle_charm", 5), (Component)Component.translatable((String)"ars_nouveau.filtering"))).withPage(TextEntry.create(Documentation.getLangPath("starbuncle_charm", 6), (Component)Component.translatable((String)"ars_nouveau.pathing"))).withPage(TextEntry.create(Documentation.getLangPath("starbuncle_charm", 7), (Component)Component.translatable((String)"ars_nouveau.starbuncle_bed"))).withPage(TextEntry.create(Documentation.getLangPath("starbuncle_charm", 8), (Component)Component.translatable((String)"ars_nouveau.starbuncle_stacking"))).addConnectedSearch(ItemsRegistry.STARBUNCLE_SHARD));
        Documentation.addPage(new DocEntryBuilder(EQUIPMENT, ItemsRegistry.DULL_TRINKET).withCraftingPages(ItemsRegistry.DULL_TRINKET, ItemsRegistry.MUNDANE_BELT).withCraftingPages(ItemsRegistry.RING_OF_POTENTIAL));
        DocEntry magebloom = Documentation.addPage(new DocEntryBuilder(RESOURCES, BlockRegistry.MAGE_BLOOM_CROP).withPage(TextEntry.create((Component)Component.translatable((String)"ars_nouveau.page.magebloom_crop"), BlockRegistry.MAGE_BLOOM_CROP.asItem().getDescription(), BlockRegistry.MAGE_BLOOM_CROP.asItem().getDefaultInstance())).withCraftingPages(BlockRegistry.MAGE_BLOOM_CROP).withCraftingPages(ItemsRegistry.MAGE_FIBER, BlockRegistry.MAGEBLOOM_BLOCK));
        Documentation.addPage(new DocEntryBuilder(EQUIPMENT, ItemsRegistry.POTION_FLASK).withIntroPage().withCraftingPages(ItemsRegistry.POTION_FLASK).withLocalizedText(ItemsRegistry.POTION_FLASK_EXTEND_TIME).withCraftingPages(ItemsRegistry.POTION_FLASK_EXTEND_TIME).withLocalizedText(ItemsRegistry.POTION_FLASK_AMPLIFY).withCraftingPages(ItemsRegistry.POTION_FLASK_AMPLIFY));
        RecipeHolder enchantmentRecipeRecipeHolder = manager.byKeyTyped((RecipeType)RecipeRegistry.REACTIVE_TYPE.get(), ArsNouveau.prefix(EnchantmentRegistry.REACTIVE_ENCHANTMENT.location().getPath() + "_1"));
        DocEntry annotatedCodex = Documentation.addBasicItem(ItemsRegistry.ANNOTATED_CODEX, SPELL_CASTING);
        Documentation.addPage(new DocEntryBuilder(ENCHANTMENTS, "reactive_enchantment").withIcon((ItemLike)Items.ENCHANTED_BOOK).withSortNum(2).withIntroPage().withPage(EnchantmentEntry.create((RecipeHolder<? extends EnchantmentRecipe>)enchantmentRecipeRecipeHolder)).withLocalizedText().withPage(EnchantmentEntry.create(ArsNouveau.prefix(EnchantmentRegistry.REACTIVE_ENCHANTMENT.location().getPath() + "_2"))).withPage(EnchantmentEntry.create(ArsNouveau.prefix(EnchantmentRegistry.REACTIVE_ENCHANTMENT.location().getPath() + "_3"))).withPage(EnchantmentEntry.create(ArsNouveau.prefix(EnchantmentRegistry.REACTIVE_ENCHANTMENT.location().getPath() + "_4"))).withLocalizedText().withPage(SpellWriteEntry.create(ResourceLocation.parse((String)"ars_nouveau:spell_write"))));
        DocEntry discountRing = Documentation.addBasicItem(ItemsRegistry.RING_OF_GREATER_DISCOUNT, EQUIPMENT);
        Documentation.addBasicItem(ItemsRegistry.RING_OF_LESSER_DISCOUNT, EQUIPMENT);
        DocEntry turrets = Documentation.addPage(new DocEntryBuilder(AUTOMATION, BlockRegistry.BASIC_SPELL_TURRET).withIntroPage().withCraftingPages(BlockRegistry.BASIC_SPELL_TURRET, BlockRegistry.ROTATING_TURRET).withLocalizedText(BlockRegistry.ENCHANTED_SPELL_TURRET).withCraftingPages(BlockRegistry.ENCHANTED_SPELL_TURRET).withLocalizedText(BlockRegistry.TIMER_SPELL_TURRET).withCraftingPages(BlockRegistry.TIMER_SPELL_TURRET).withLocalizedText());
        Documentation.addBasicItem(ItemsRegistry.SUMMONING_FOCUS, SPELL_CASTING);
        Documentation.addBasicItem(ItemsRegistry.VOID_JAR, EQUIPMENT);
        Documentation.addBasicItem(ItemsRegistry.WAND, SPELL_CASTING);
        Documentation.addPage(new DocEntryBuilder(AUTOMATION, ItemsRegistry.WHIRLISPRIG_CHARM).withIntroPage().withCraftingPages(ItemsRegistry.WHIRLISPRIG_CHARM).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.WHIRLISPRIG_TYPE.get()), Documentation.getLangPath("whirlisprig_charm", 2))).withPage(TextEntry.create(Documentation.getLangPath("whirlisprig_charm", 3), (Component)Component.translatable((String)"ars_nouveau.summoning"))).withPage(TextEntry.create(Documentation.getLangPath("whirlisprig_charm", 4), (Component)Component.translatable((String)"ars_nouveau.happiness"))).withPage(TextEntry.create(Documentation.getLangPath("whirlisprig_charm", 5), (Component)Component.translatable((String)"ars_nouveau.important"))).withPage(TextEntry.create(Documentation.getLangPath("whirlisprig_charm", 6), (Component)Component.translatable((String)"ars_nouveau.production"))).addConnectedSearch(ItemsRegistry.WHIRLISPRIG_SHARDS));
        DocEntry wixie = Documentation.addPage(new DocEntryBuilder(AUTOMATION, ItemsRegistry.WIXIE_CHARM).withIntroPage().withCraftingPages(ItemsRegistry.WIXIE_CHARM).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_WIXIE_TYPE.get()), Documentation.getLangPath("wixie_charm", 2), 0.95f, -15)).withPage(TextEntry.create(Documentation.getLangPath("wixie_charm", 3), (Component)Component.translatable((String)"ars_nouveau.item_crafting"))).withPage(TextEntry.create(Documentation.getLangPath("wixie_charm", 4), (Component)Component.translatable((String)"ars_nouveau.item_crafting_setting"))).withPage(TextEntry.create(Documentation.getLangPath("wixie_charm", 7), (Component)Component.translatable((String)"ars_nouveau.binding_inventories"))).withPage(TextEntry.create(Documentation.getLangPath("wixie_charm", 5), (Component)Component.translatable((String)"ars_nouveau.potion_crafting"))).withPage(TextEntry.create(Documentation.getLangPath("wixie_charm", 6))).addConnectedSearch(ItemsRegistry.WIXIE_SHARD));
        DocEntry archwood = Documentation.addPage(new DocEntryBuilder(RESOURCES, "archwood").withIcon(BlockRegistry.CASCADING_SAPLING).withIntroPage().withPage(TextEntry.create((Component)Component.translatable((String)"ars_nouveau.page.bombegrante"), (Component)Component.translatable((String)"block.ars_nouveau.bombegranate_pod"), BlockRegistry.BOMBEGRANTE_POD)).withCraftingPages(BlockRegistry.BOMBEGRANTE_POD).withPage(Documentation.getForPotionRecipes(BlockRegistry.BOMBEGRANTE_POD.asItem().getDefaultInstance())).withPage(TextEntry.create((Component)Component.translatable((String)"ars_nouveau.page.mendosteen"), (Component)Component.translatable((String)"block.ars_nouveau.mendosteen_pod"), BlockRegistry.MENDOSTEEN_POD)).withCraftingPages(BlockRegistry.MENDOSTEEN_POD).withPage(Documentation.getForPotionRecipes(BlockRegistry.MENDOSTEEN_POD.asItem().getDefaultInstance())).withPage(TextEntry.create((Component)Component.translatable((String)"ars_nouveau.page.frostaya"), (Component)Component.translatable((String)"block.ars_nouveau.frostaya_pod"), BlockRegistry.FROSTAYA_POD)).withCraftingPages(BlockRegistry.FROSTAYA_POD).withPage(Documentation.getForPotionRecipes(BlockRegistry.FROSTAYA_POD.asItem().getDefaultInstance())).withPage(TextEntry.create((Component)Component.translatable((String)"ars_nouveau.page.bastion_fruit"), (Component)Component.translatable((String)"block.ars_nouveau.bastion_pod"), BlockRegistry.BASTION_POD)).withCraftingPages(BlockRegistry.BASTION_POD).withPage(Documentation.getForPotionRecipes(BlockRegistry.BASTION_POD.asItem().getDefaultInstance())).addConnectedSearch(BlockRegistry.BOMBEGRANTE_POD).addConnectedSearch(BlockRegistry.MENDOSTEEN_POD).addConnectedSearch(BlockRegistry.FROSTAYA_POD).addConnectedSearch(BlockRegistry.BASTION_POD));
        Documentation.addPage(new DocEntryBuilder(RESOURCES, "decorative").withIcon((ItemLike)SOURCESTONE).withCraftingPages((ItemLike)SOURCESTONE).withIntroPage());
        DocEntry sourceberry = Documentation.addPage(new DocEntryBuilder(RESOURCES, BlockRegistry.SOURCEBERRY_BUSH).withIntroPage().withCraftingPages(ItemsRegistry.SOURCE_BERRY_PIE, ItemsRegistry.SOURCE_BERRY_ROLL));
        int walkerOffset = -20;
        Documentation.addPage(new DocEntryBuilder(RESOURCES, "weald_walker").withIcon((ItemLike)RitualRegistry.getRitualItemMap().get(ArsNouveau.prefix(RitualLib.AWAKENING))).withIntroPage().withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_BLAZING_WEALD.get()), Documentation.getLangPath("weald_walker", 2))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_CASCADING_WEALD.get()), Documentation.getLangPath("weald_walker", 3))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_FLOURISHING_WEALD.get()), Documentation.getLangPath("weald_walker", 4))).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_VEXING_WEALD.get()), Documentation.getLangPath("weald_walker", 5))));
        Documentation.addPage(new DocEntryBuilder(RESOURCES, "wilden").withIcon(ItemsRegistry.WILDEN_SPIKE).withIntroPage().withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.WILDEN_HUNTER.get()), Documentation.getLangPath("wilden", 3), 0.55f)).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.WILDEN_STALKER.get()), Documentation.getLangPath("wilden", 4), 0.55f)).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.WILDEN_GUARDIAN.get()), Documentation.getLangPath("wilden", 5), 0.55f)).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.WILDEN_BOSS.get()), Documentation.getLangPath("wilden", 6), 0.55f)).withPage(TextEntry.create(Documentation.getLangPath("wilden", 7))).addConnectedSearch(ItemsRegistry.WILDEN_SPIKE).addConnectedSearch(ItemsRegistry.WILDEN_WING).addConnectedSearch(ItemsRegistry.WILDEN_HORN).addConnectedSearch(ItemsRegistry.WILDEN_TRIBUTE));
        final DocEntry denyScroll = Documentation.addPage(new DocEntryBuilder(AUTOMATION, ItemsRegistry.DENY_ITEM_SCROLL).withIntroPage().withCraftingPages(ItemsRegistry.BLANK_PARCHMENT, ItemsRegistry.DENY_ITEM_SCROLL));
        final DocEntry mimicScroll = Documentation.addPage(new DocEntryBuilder(AUTOMATION, ItemsRegistry.MIMIC_ITEM_SCROLL).withIntroPage().withPage(Documentation.getRecipePages(ItemsRegistry.BLANK_PARCHMENT, ItemsRegistry.MIMIC_ITEM_SCROLL)));
        final DocEntry allowScroll = Documentation.addPage(new DocEntryBuilder(AUTOMATION, ItemsRegistry.ALLOW_ITEM_SCROLL).withIntroPage().withPage(Documentation.getRecipePages(ItemsRegistry.BLANK_PARCHMENT, ItemsRegistry.ALLOW_ITEM_SCROLL)));
        DocEntry dominionWand = Documentation.addBasicItem(ItemsRegistry.DOMINION_ROD, AUTOMATION);
        DocEntry prisms = Documentation.addBasicItem(BlockRegistry.SPELL_PRISM, AUTOMATION);
        Documentation.addPage(new DocEntryBuilder(RESOURCES, BlockRegistry.MAGELIGHT_TORCH).withIntroPage().withPage(Documentation.getRecipePages(BlockRegistry.GOLD_SCONCE_BLOCK, BlockRegistry.SOURCESTONE_SCONCE_BLOCK)).withPage(Documentation.getRecipePages(BlockRegistry.POLISHED_SCONCE_BLOCK, BlockRegistry.ARCHWOOD_SCONCE_BLOCK)).withCraftingPages(BlockRegistry.MAGELIGHT_TORCH));
        DocEntry spellBooks = Documentation.addPage(new DocEntryBuilder(SPELL_CASTING, "spell_books").withSortNum(1).withIcon(ItemsRegistry.ARCHMAGE_SPELLBOOK).withIntroPage().withPage(Documentation.getRecipePages(RegistryHelper.getRegistryName(ItemsRegistry.NOVICE_SPELLBOOK.asItem()), ArsNouveau.prefix("apprentice_book_upgrade"))).withCraftingPages(ArsNouveau.prefix("archmage_book_upgrade"), ItemsRegistry.ARCHMAGE_SPELLBOOK));
        Documentation.addBasicItem(ItemsRegistry.ENCHANTERS_MIRROR, SPELL_CASTING);
        Documentation.addBasicItem(ItemsRegistry.ENCHANTERS_SHIELD, SPELL_CASTING);
        Documentation.addBasicItem(ItemsRegistry.ENCHANTERS_SWORD, SPELL_CASTING);
        Documentation.addPage(new DocEntryBuilder(SPELL_CASTING, ItemsRegistry.SPELL_BOW).withIntroPage().withCraftingPages(ItemsRegistry.SPELL_BOW).withCraftingPages("ars_nouveau:imbuement_amplify_arrow", ItemsRegistry.AMPLIFY_ARROW).withCraftingPages("ars_nouveau:imbuement_pierce_arrow", ItemsRegistry.PIERCE_ARROW).withCraftingPages("ars_nouveau:imbuement_split_arrow", ItemsRegistry.SPLIT_ARROW));
        Documentation.addPage(new DocEntryBuilder(SPELL_CASTING, ItemsRegistry.SPELL_CROSSBOW).withIntroPage().withCraftingPages(ItemsRegistry.SPELL_CROSSBOW).withCraftingPages("ars_nouveau:imbuement_amplify_arrow", ItemsRegistry.AMPLIFY_ARROW).withCraftingPages("ars_nouveau:imbuement_pierce_arrow", ItemsRegistry.PIERCE_ARROW).withCraftingPages("ars_nouveau:imbuement_split_arrow", ItemsRegistry.SPLIT_ARROW));
        Documentation.addBasicItem(ItemsRegistry.RUNIC_CHALK, SPELL_CASTING);
        DocEntry potionJar = Documentation.addBasicItem(BlockRegistry.POTION_JAR, MACHINES);
        DocEntry melder = Documentation.addBasicItem(BlockRegistry.POTION_MELDER, MACHINES);
        DocEntry diffuser = Documentation.addBasicItem(BlockRegistry.POTION_DIFFUSER, MACHINES);
        wixie.withRelation(potionJar).withRelation(melder).withRelation(diffuser);
        potionJar.withRelation(melder).withRelation(diffuser).withRelation(wixie);
        melder.withRelation(potionJar).withRelation(diffuser).withRelation(wixie);
        diffuser.withRelation(potionJar).withRelation(melder).withRelation(wixie);
        DocEntry ritualBrazier = Documentation.addBasicItem(BlockRegistry.RITUAL_BLOCK, MACHINES);
        Documentation.addBasicItem(BlockRegistry.BRAZIER_RELAY, MACHINES);
        DocEntry scribesTable = Documentation.addPage(new DocEntryBuilder(MACHINES, BlockRegistry.SCRIBES_BLOCK).withPage(TextEntry.create(Documentation.getLangPath("scribes_table", 1), (Component)Component.translatable((String)"ars_nouveau.glyph_crafting"), BlockRegistry.SCRIBES_BLOCK.asItem().getDefaultInstance())).withPage(TextEntry.create(Documentation.getLangPath("scribes_table", 2), (Component)Component.translatable((String)"ars_nouveau.scribing"))).withPage(Documentation.getRecipePages(ItemsRegistry.BLANK_PARCHMENT, BlockRegistry.SCRIBES_BLOCK)));
        DocEntry portal = Documentation.addPage(new DocEntryBuilder(MACHINES, "warp_portal").withIcon(ItemsRegistry.WARP_SCROLL).withIntroPage().withLocalizedText());
        DocEntry scroll = Documentation.addBasicItem(ItemsRegistry.WARP_SCROLL, EQUIPMENT);
        DocEntry stableScroll = Documentation.addBasicItem(ItemsRegistry.STABLE_WARP_SCROLL, EQUIPMENT);
        stableScroll.withRelation(scroll).withRelation(portal);
        scroll.withRelation(stableScroll).withRelation(portal);
        portal.withRelation(scroll).withRelation(stableScroll);
        DocEntry agronomic = Documentation.addBasicItem(BlockRegistry.AGRONOMIC_SOURCELINK, SOURCE);
        DocEntry alchemical = Documentation.addBasicItem(BlockRegistry.ALCHEMICAL_BLOCK, SOURCE).withRelation(wixie).withRelation(melder);
        DocEntry mycelial = Documentation.addBasicItem(BlockRegistry.MYCELIAL_BLOCK, SOURCE);
        DocEntry relay = Documentation.addBasicItem(BlockRegistry.RELAY, SOURCE, CraftingEntry.create((RecipeHolder<CraftingRecipe>)manager.byKeyTyped(RecipeType.CRAFTING, RegistryHelper.getRegistryName((Block)BlockRegistry.RELAY.get())), (Component)Component.translatable((String)"ars_nouveau.page2.relay"))).withRelation(dominionWand);
        Documentation.addBasicItem(BlockRegistry.RELAY_DEPOSIT, SOURCE);
        Documentation.addBasicItem(BlockRegistry.RELAY_SPLITTER, SOURCE);
        Documentation.addBasicItem(BlockRegistry.RELAY_WARP, SOURCE);
        Documentation.addBasicItem(BlockRegistry.RELAY_COLLECTOR, SOURCE);
        Documentation.addBasicItem(BlockRegistry.VITALIC_BLOCK, SOURCE);
        DocEntry volcanic = Documentation.addPage(new DocEntryBuilder(SOURCE, BlockRegistry.VOLCANIC_BLOCK).withIntroPage().withPage(TextEntry.create(Documentation.getLangPath("volcanic_sourcelink", 2), (Component)Component.translatable((String)"ars_nouveau.active_generation"))).withCraftingPages(BlockRegistry.VOLCANIC_BLOCK));
        Documentation.addPage(new DocEntryBuilder(ENCHANTMENTS, "how_to_enchant").withIcon(BlockRegistry.ENCHANTING_APP_BLOCK).withSortNum(-1).withIntroPage().withLocalizedText()).withRelation(enchantingApparatus);
        DocEntry sourceJar = Documentation.addBasicItem(BlockRegistry.SOURCE_JAR, SOURCE, 0).withRelation(relay).withRelation(agronomic).withRelation(volcanic);
        Documentation.addPage(new DocEntryBuilder(RITUALS, "performing_rituals").withSortNum(-1).withIcon(BlockRegistry.RITUAL_BLOCK).withIntroPage().withLocalizedText().withCraftingPages((ItemLike)RitualRegistry.getRitualItemMap().get(ArsNouveau.prefix(RitualLib.SUNRISE)))).withRelation(ritualBrazier);
        Documentation.addPage(new DocEntryBuilder(FAMILIARS, "summoning_familiars").withSortNum(-1).withIcon((ItemLike)RitualRegistry.getRitualItemMap().get(ArsNouveau.prefix(RitualLib.BINDING))).withIntroPage().withLocalizedText().withCraftingPages((ItemLike)RitualRegistry.getRitualItemMap().get(ArsNouveau.prefix(RitualLib.BINDING)))).withRelations(ritualBrazier).withRelation(ArsNouveau.prefix(RitualLib.BINDING));
        Documentation.addPage(new DocEntryBuilder(AUTOMATION, ItemsRegistry.AMETHYST_GOLEM_CHARM).withIntroPage().withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.AMETHYST_GOLEM.get()), Documentation.getLangPath("amethyst_golem_charm", 2), 0.75f)).withPage(TextEntry.create(Documentation.getLangPath("amethyst_golem_charm", 3), (Component)Component.translatable((String)"ars_nouveau.summoning"))).withPage(TextEntry.create(Documentation.getLangPath("amethyst_golem_charm", 4), (Component)Component.translatable((String)"ars_nouveau.amethyst_farming"))).withPage(TextEntry.create(Documentation.getLangPath("amethyst_golem_charm", 5), (Component)Component.translatable((String)"ars_nouveau.amethyst_storage"))));
        DocEntry starbyBed = Documentation.addPage(new DocEntryBuilder(AUTOMATION, BlockRegistry.ORANGE_SBED).withName("ars_nouveau.summon_bed").withIntroPage("summon_bed").withPage(Documentation.getRecipePages(BlockRegistry.ORANGE_SBED, BlockRegistry.BLUE_SBED)).withPage(Documentation.getRecipePages(BlockRegistry.GREEN_SBED, BlockRegistry.YELLOW_SBED)).withPage(Documentation.getRecipePages(BlockRegistry.RED_SBED, BlockRegistry.PURPLE_SBED)));
        DocEntry scryCaster = Documentation.addBasicItem(ItemsRegistry.SCRY_CASTER, SPELL_CASTING);
        DocEntry scryCrystal = Documentation.addBasicItem(BlockRegistry.SCRYERS_CRYSTAL, MACHINES);
        DocEntry oculus = Documentation.addBasicItem(BlockRegistry.SCRYERS_OCULUS, MACHINES);
        DocEntry scryScroll = Documentation.addBasicItem(ItemsRegistry.SCRYER_SCROLL, MACHINES);
        scryCrystal.withRelation(scryCaster).withRelation(scryScroll).withRelation(oculus);
        scryCaster.withRelation(scryCrystal);
        oculus.withRelation(scryScroll).withRelation(scryCrystal);
        scryScroll.withRelation(scryCaster).withRelation(oculus).withRelation(scryCrystal);
        DocEntry starbyShades = Documentation.addBasicItem(ItemsRegistry.STARBUNCLE_SHADES, AUTOMATION);
        DocEntry wixieHat = Documentation.addBasicItem(ItemsRegistry.WIXIE_HAT, AUTOMATION);
        Documentation.addPage(new DocEntryBuilder(SPELL_CASTING, ItemsRegistry.SHAPERS_FOCUS).withIntroPage().withCraftingPages(ItemsRegistry.SHAPERS_FOCUS).withPage(TextEntry.create(Documentation.getLangPath("shapers_focus", 2), (Component)Component.translatable((String)"ars_nouveau.shapers_focus.blocks"))).withPage(TextEntry.create(Documentation.getLangPath("shapers_focus", 3), (Component)Component.translatable((String)"ars_nouveau.shapers_focus.entities"))).withPage(TextEntry.create(Documentation.getLangPath("shapers_focus", 4), (Component)Component.translatable((String)"ars_nouveau.shapers_focus.examples"))));
        Documentation.addBasicItem(ItemsRegistry.ALCHEMISTS_CROWN, EQUIPMENT);
        Documentation.addPage(new DocEntryBuilder(EQUIPMENT, "flask_cannons").withIcon(ItemsRegistry.SPLASH_LAUNCHER).withIntroPage().withCraftingPages(ItemsRegistry.SPLASH_LAUNCHER).withCraftingPages(ItemsRegistry.LINGERING_LAUNCHER));
        DocEntryBuilder ARMOR_ENTRY = new DocEntryBuilder(ARMOR, "armor").withIcon(ItemsRegistry.SORCERER_ROBES).withSortNum(0).withIntroPage().withPage(TextEntry.create("ars_nouveau.page.threads", "ars_nouveau.threads")).withPage(PerkDiagramEntry.create(ItemsRegistry.SORCERER_HOOD, ItemsRegistry.SORCERER_ROBES, ItemsRegistry.SORCERER_LEGGINGS, ItemsRegistry.SORCERER_BOOTS)).withPage(PerkDiagramEntry.create(ItemsRegistry.ARCANIST_HOOD, ItemsRegistry.ARCANIST_ROBES, ItemsRegistry.ARCANIST_LEGGINGS, ItemsRegistry.ARCANIST_BOOTS)).withPage(PerkDiagramEntry.create(ItemsRegistry.BATTLEMAGE_HOOD, ItemsRegistry.BATTLEMAGE_ROBES, ItemsRegistry.BATTLEMAGE_LEGGINGS, ItemsRegistry.BATTLEMAGE_BOOTS)).withCraftingPages(ItemsRegistry.SORCERER_HOOD).withCraftingPages(ItemsRegistry.SORCERER_ROBES).withCraftingPages(ItemsRegistry.SORCERER_LEGGINGS).withCraftingPages(ItemsRegistry.SORCERER_BOOTS).withCraftingPages(ItemsRegistry.ARCANIST_HOOD).withCraftingPages(ItemsRegistry.ARCANIST_ROBES).withCraftingPages(ItemsRegistry.ARCANIST_LEGGINGS).withCraftingPages(ItemsRegistry.ARCANIST_BOOTS).withCraftingPages(ItemsRegistry.BATTLEMAGE_HOOD).withCraftingPages(ItemsRegistry.BATTLEMAGE_ROBES).withCraftingPages(ItemsRegistry.BATTLEMAGE_LEGGINGS).withCraftingPages(ItemsRegistry.BATTLEMAGE_BOOTS);
        DocEntry armorEntry = Documentation.addPage(ARMOR_ENTRY.withCategory(ARMOR));
        DocEntry alteraitonTable = Documentation.addPage(new DocEntryBuilder(ARMOR, "alteration_table").withIcon(BlockRegistry.ALTERATION_TABLE).withIntroPage().withPage(Documentation.getRecipePages(BlockRegistry.ALTERATION_TABLE, (ItemLike)ItemsRegistry.BLANK_THREAD)).withSortNum(3)).withRelation(armorEntry);
        RecipeHolder firstUpgrade = manager.byKeyTyped((RecipeType)RecipeRegistry.ARMOR_UPGRADE_TYPE.get(), ArsNouveau.prefix("first_armor_upgrade"));
        RecipeHolder secondUpgrade = manager.byKeyTyped((RecipeType)RecipeRegistry.ARMOR_UPGRADE_TYPE.get(), ArsNouveau.prefix("second_armor_upgrade"));
        DocEntry armorUpgrade = Documentation.addPage(new DocEntryBuilder(ARMOR, "armor_upgrading").withIcon(ItemsRegistry.ARCANIST_HOOD).withIntroPage().withPage(TextEntry.create(Documentation.getLangPath("armor_upgrading", 2), (Component)Component.translatable((String)"ars_nouveau.armor_tiers"))).withPage(ArmorUpgradeEntry.create((RecipeHolder<ArmorUpgradeRecipe>)firstUpgrade)).withPage(ArmorUpgradeEntry.create((RecipeHolder<ArmorUpgradeRecipe>)secondUpgrade)).withSortNum(1)).withRelations(alteraitonTable, armorEntry);
        armorEntry.withRelation(armorUpgrade);
        alteraitonTable.withRelation(armorUpgrade);
        Documentation.addPage(new DocEntryBuilder(ARMOR, "applying_perks").withIcon((ItemLike)ItemsRegistry.BLANK_THREAD).withIntroPage().withLocalizedText().withSortNum(2)).withRelations(armorEntry, alteraitonTable);
        Documentation.addPage(new DocEntryBuilder(ARMOR, "alteration_table").withIcon(BlockRegistry.ALTERATION_TABLE).withIntroPage().withPage(Documentation.getRecipePages(BlockRegistry.ALTERATION_TABLE, (ItemLike)ItemsRegistry.BLANK_THREAD)).withSortNum(2)).withRelations(armorEntry, armorUpgrade);
        DocEntry voidPrism = Documentation.addBasicItem(BlockRegistry.VOID_PRISM, AUTOMATION);
        turrets.withRelation(prisms).withRelation(voidPrism);
        prisms.withRelation(turrets).withRelation(voidPrism);
        voidPrism.withRelation(turrets).withRelation(prisms);
        Documentation.addPage(new DocEntryBuilder(RESOURCES, "illusion_blocks").withIcon(BlockRegistry.GHOST_WEAVE).withLocalizedText(BlockRegistry.MIRROR_WEAVE).withCraftingPages(BlockRegistry.MIRROR_WEAVE).withLocalizedText(BlockRegistry.FALSE_WEAVE).withCraftingPages(BlockRegistry.FALSE_WEAVE).withLocalizedText(BlockRegistry.GHOST_WEAVE).withCraftingPages(BlockRegistry.GHOST_WEAVE).withLocalizedText(BlockRegistry.SKY_WEAVE).withCraftingPages(BlockRegistry.SKY_WEAVE));
        DocEntry bookwyrm = Documentation.addPage(new DocEntryBuilder(MACHINES, ItemsRegistry.BOOKWYRM_CHARM).withIntroPage().withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_BOOKWYRM_TYPE.get()), Documentation.getLangPath("bookwyrm_charm", 2))));
        DocEntry storageLectern = Documentation.addPage(new DocEntryBuilder(MACHINES, BlockRegistry.CRAFTING_LECTERN).withIntroPage().withPage(TextEntry.create(Documentation.getLangPath("storage", 2), (Component)Component.translatable((String)"ars_nouveau.storage"))).withPage(TextEntry.create(Documentation.getLangPath("storage", 3), (Component)Component.translatable((String)"ars_nouveau.storage_tabs"))).withCraftingPages(BlockRegistry.CRAFTING_LECTERN));
        bookwyrm.withRelation(storageLectern);
        DocEntry displayCase = Documentation.addPage(new DocEntryBuilder(MACHINES, BlockRegistry.ITEM_DETECTOR).withIntroPage().withLocalizedText().withCraftingPages(BlockRegistry.ITEM_DETECTOR));
        DocEntry repository = Documentation.addPage(new DocEntryBuilder(MACHINES, BlockRegistry.REPOSITORY).withIntroPage().withCraftingPages(BlockRegistry.REPOSITORY, BlockRegistry.ARCHWOOD_CHEST));
        ArrayList<DocEntry> scrollRelations = new ArrayList<DocEntry>(){
            {
                this.add(denyScroll);
                this.add(mimicScroll);
                this.add(allowScroll);
            }
        };
        storageLectern.withRelation(bookwyrm).withRelation(displayCase).withRelation(repository);
        repository.withRelations(storageLectern);
        starby.withRelations(scrollRelations.stream().map(DocEntry::id).toList()).withRelation(dominionWand).withRelation(storageLectern).withRelation(starbyShades).withRelation(wixieHat).withRelation(starbyBed);
        denyScroll.withRelation(mimicScroll).withRelation(allowScroll).withRelation(dominionWand).withRelation(starby).withRelation(storageLectern).withRelation(displayCase);
        mimicScroll.withRelation(denyScroll).withRelation(allowScroll).withRelation(dominionWand).withRelation(starby).withRelation(storageLectern).withRelation(displayCase);
        allowScroll.withRelation(denyScroll).withRelation(mimicScroll).withRelation(dominionWand).withRelation(starby).withRelation(storageLectern).withRelation(displayCase);
        displayCase.withRelation(bookwyrm).withRelation(storageLectern).withRelation(dominionWand).withEntryRelations((List<DocEntry>)scrollRelations);
        dominionWand.withRelation(storageLectern).withRelation(displayCase).withRelation(starby);
        Documentation.addBasicItem(BlockRegistry.SPELL_SENSOR, AUTOMATION);
        Documentation.addBasicItem(ItemsRegistry.JUMP_RING, EQUIPMENT);
        Documentation.addBasicItem(BlockRegistry.REDSTONE_RELAY, AUTOMATION);
        Documentation.addPage(new DocEntryBuilder(AUTOMATION, BlockRegistry.ARCHWOOD_GRATE).withIntroPage().withCraftingPages(BlockRegistry.ARCHWOOD_GRATE, BlockRegistry.GOLD_GRATE).withCraftingPages(BlockRegistry.SMOOTH_SOURCESTONE_GRATE, BlockRegistry.SOURCESTONE_GRATE));
        Documentation.addBasicItem(BlockRegistry.SOURCE_LAMP, AUTOMATION);
        Documentation.addPage(new DocEntryBuilder(AUTOMATION, ItemsRegistry.ALAKARKINOS_CHARM).withIntroPage().withCraftingPages(ItemsRegistry.ALAKARKINOS_CHARM).withPage(EntityEntry.create((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ALAKARKINOS_TYPE.get()), Documentation.getLangPath("alakarkinos_charm", 2), 0.5f, -10)).withPage(TextEntry.create(Documentation.getLangPath("alakarkinos_charm", 3), (Component)Component.translatable((String)"ars_nouveau.summoning"))).withPage(TextEntry.create(Documentation.getLangPath("alakarkinos_charm", 4), (Component)Component.translatable((String)"ars_nouveau.sifting"))).addConnectedSearch(ItemsRegistry.ALAKARKINOS_SHARD));
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "spell_casting").withIcon(ItemsRegistry.NOVICE_SPELLBOOK).withSortNum(1).withIntroPage().withLocalizedText().withLocalizedText().withCraftingPages(ItemsRegistry.NOVICE_SPELLBOOK));
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "spell_mana").withSortNum(2).withIcon(ItemsRegistry.NOVICE_SPELLBOOK).withIntroPage().withLocalizedText());
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "obtaining_gems").withIcon(BlockRegistry.IMBUEMENT_BLOCK).withSortNum(3).withIntroPage()).withRelation(dowsingRod).withRelation(docEntry);
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "new_glyphs").withIcon(ItemsRegistry.BLANK_GLYPH).withSortNum(4).withIntroPage()).withRelations(scribesTable, annotatedCodex);
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "source").withSortNum(5).withIcon(BlockRegistry.SOURCE_JAR).withIntroPage()).withRelations(sourceJar, agronomic, relay);
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "apparatus_crafting").withSortNum(6).withIcon(BlockRegistry.ENCHANTING_APP_BLOCK).withIntroPage()).withRelations(enchantingApparatus, magebloom);
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "better_casting").withSortNum(7).withIcon(ItemsRegistry.SORCERER_ROBES).withIntroPage()).withRelations(enchantingApparatus, armorEntry, armorUpgrade);
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "world_generation").withSortNum(8).withIcon(ItemsRegistry.SOURCE_GEM).withIntroPage()).withRelations(docEntry, archwood, sourceberry, dowsingRod);
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "upgrades").withSortNum(9).withIcon(ItemsRegistry.ARCHMAGE_SPELLBOOK).withIntroPage()).withRelations(spellBooks, armorEntry);
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "starting_automation").withSortNum(10).withIcon(BlockRegistry.BASIC_SPELL_TURRET).withIntroPage()).withRelations(turrets, prisms, starby, wixie, drygmyCharm);
        Documentation.addPage(new DocEntryBuilder(GETTING_STARTED, "trinkets").withIcon(ItemsRegistry.WARP_SCROLL).withSortNum(11).withIntroPage()).withRelations(jarOfLight, amuletOfRegen, discountRing, beltOfLevitation, stableScroll);
        ArrayList<RecipeHolder> enchantmentRecipes = new ArrayList<RecipeHolder>(manager.getAllRecipesFor((RecipeType)RecipeRegistry.ENCHANTMENT_TYPE.get()));
        enchantmentRecipes.sort(Comparator.comparingInt(a -> a.value() == null ? -1 : ((EnchantmentRecipe)a.value()).enchantLevel));
        HashMap enchantmentMap = new HashMap();
        for (RecipeHolder recipeHolder : enchantmentRecipes) {
            EnchantmentRecipe recipe1 = (EnchantmentRecipe)recipeHolder.value();
            if (recipe1 == null) continue;
            ResourceKey<Enchantment> key = recipe1.enchantmentKey;
            if (!enchantmentMap.containsKey(key)) {
                enchantmentMap.put(key, new ArrayList());
            }
            ((List)enchantmentMap.get(key)).add(recipeHolder);
        }
        for (Map.Entry entry2 : enchantmentMap.entrySet()) {
            ResourceKey enchantment = (ResourceKey)entry2.getKey();
            List minMax = (List)entry2.getValue();
            if (level.holder(enchantment).isEmpty()) break;
            DocEntryBuilder builder = new DocEntryBuilder(ENCHANTMENTS, enchantment.location().getPath()).withIcon((ItemLike)Items.ENCHANTED_BOOK);
            builder.entryId = enchantment.location();
            builder.title = ((Enchantment)level.holderOrThrow(enchantment).value()).description();
            for (RecipeHolder max : minMax) {
                builder.withPage(EnchantmentEntry.create((RecipeHolder<? extends EnchantmentRecipe>)max));
            }
            Documentation.addPage(builder);
        }
        for (DocEntryBuilder docEntryBuilder : pendingBuilders) {
            Documentation.addPage(docEntryBuilder);
        }
        pendingBuilders = new ArrayList<DocEntryBuilder>();
        NeoForge.EVENT_BUS.post((Event)new ReloadDocumentationEvent.AddEntries());
        NeoForge.EVENT_BUS.post((Event)new ReloadDocumentationEvent.Post());
        Search.initSearchIndex();
        long endTime = System.nanoTime();
        Log.getLogger().info("Documentation loaded in {}ms", (Object)((endTime - startTime) / 1000000L));
    }

    public static DocEntry addPage(DocEntryBuilder builder) {
        DocEntry entry = DocumentationRegistry.registerEntry(builder.category, builder.build());
        if (entries.contains(entry)) {
            throw new IllegalStateException("Entry already exists: " + String.valueOf(entry));
        }
        return entry;
    }

    public static DocEntryBuilder buildPage(DocEntryBuilder builder) {
        pendingBuilders.add(builder);
        return builder;
    }

    public static DocEntryBuilder buildBasicItem(ItemLike item, DocCategory category) {
        Item asItem = item.asItem();
        ResourceLocation registryName = RegistryHelper.getRegistryName(asItem);
        DocEntryBuilder builder = new DocEntryBuilder(category, asItem.getDescriptionId()).withIcon((ItemLike)asItem).withPage(TextEntry.create((Component)Component.translatable((String)(registryName.getNamespace() + ".page." + registryName.getPath())))).withCraftingPages(item);
        pendingBuilders.add(builder);
        return builder;
    }

    public static DocEntry addBasicItem(ItemLike item, DocCategory category) {
        return Documentation.addBasicItem(item, category, 100);
    }

    public static DocEntry addBasicItem(ItemLike item, DocCategory category, int order) {
        ItemStack stack = new ItemStack(item);
        ResourceLocation registryName = RegistryHelper.getRegistryName(item.asItem());
        return Documentation.addPage(new DocEntryBuilder(category, stack.getDescriptionId()).withIcon(item).withSortNum(order).withPage(TextEntry.create((Component)Component.translatable((String)(registryName.getNamespace() + ".page." + registryName.getPath())), stack.getItem().getDescription(), stack)).withCraftingPages(item));
    }

    public static DocEntry addBasicItem(ItemLike item, DocCategory category, ResourceLocation recipeId) {
        ResourceLocation registryName = RegistryHelper.getRegistryName(item.asItem());
        return Documentation.addPage(new DocEntryBuilder(category, item.asItem().getDescriptionId()).withIcon((ItemLike)item.asItem()).withPage(TextEntry.create((Component)Component.translatable((String)(registryName.getNamespace() + ".page." + RegistryHelper.getRegistryName(item.asItem()).getPath())))).withPage(Documentation.getRecipePages(recipeId)));
    }

    public static DocEntry addBasicItem(ItemLike item, DocCategory category, SinglePageCtor recipePage) {
        Item item1 = item.asItem();
        ResourceLocation registryName = RegistryHelper.getRegistryName(item1);
        return Documentation.addPage(new DocEntryBuilder(category, item1.getDescriptionId()).withIcon(item).withPage(TextEntry.create((Component)Component.translatable((String)(registryName.getNamespace() + ".page." + registryName.getPath())), item1.getDescription(), new ItemStack((ItemLike)item1))).withPage(recipePage));
    }

    public static List<SinglePageCtor> getRecipePages(ItemLike stack1, ItemLike stack2) {
        ResourceLocation key1 = RegistryHelper.getRegistryName(stack1.asItem());
        ResourceLocation key2 = RegistryHelper.getRegistryName(stack2.asItem());
        return Documentation.getRecipePages(key1, key2);
    }

    public static List<SinglePageCtor> getRecipePages(ResourceLocation key1, ResourceLocation key2) {
        Level level = ArsNouveau.proxy.getClientWorld();
        RecipeManager manager = level.getRecipeManager();
        RecipeHolder recipe1 = manager.byKeyTyped(RecipeType.CRAFTING, key1);
        RecipeHolder recipe2 = manager.byKeyTyped(RecipeType.CRAFTING, key2);
        ArrayList<SinglePageCtor> pages = new ArrayList<SinglePageCtor>();
        if (recipe1 != null && recipe2 != null) {
            pages.add(CraftingEntry.create((RecipeHolder<CraftingRecipe>)recipe1, (RecipeHolder<CraftingRecipe>)recipe2));
            return pages;
        }
        pages.addAll(Documentation.getRecipePages(key1));
        pages.addAll(Documentation.getRecipePages(key2));
        return pages;
    }

    public static List<SinglePageCtor> getRecipePages(ItemStack stack, ResourceLocation recipeId) {
        return Documentation.getRecipePages(recipeId);
    }

    public static List<SinglePageCtor> getRecipePages(ResourceLocation recipeId) {
        Level level = ArsNouveau.proxy.getClientWorld();
        RecipeManager manager = level.getRecipeManager();
        ArrayList<SinglePageCtor> pages = new ArrayList<SinglePageCtor>();
        RecipeHolder glyphRecipe = manager.byKeyTyped((RecipeType)RecipeRegistry.GLYPH_TYPE.get(), recipeId);
        if (glyphRecipe != null) {
            pages.add(GlyphRecipeEntry.create((RecipeHolder<GlyphRecipe>)glyphRecipe));
            return pages;
        }
        RecipeHolder recipe = manager.byKeyTyped(RecipeType.CRAFTING, recipeId);
        if (recipe != null) {
            pages.add(CraftingEntry.create((RecipeHolder<CraftingRecipe>)recipe));
            return pages;
        }
        RecipeHolder apparatusRecipe = manager.byKeyTyped((RecipeType)RecipeRegistry.APPARATUS_TYPE.get(), recipeId);
        if (apparatusRecipe != null) {
            pages.add(ApparatusEntry.create((RecipeHolder<? extends EnchantingApparatusRecipe>)apparatusRecipe));
            return pages;
        }
        RecipeHolder imbuementRecipe = manager.byKeyTyped((RecipeType)RecipeRegistry.IMBUEMENT_TYPE.get(), recipeId);
        if (imbuementRecipe != null) {
            pages.add(ImbuementRecipeEntry.create((RecipeHolder<ImbuementRecipe>)imbuementRecipe));
            return pages;
        }
        return pages;
    }

    public static List<SinglePageCtor> getForPotionRecipes(ItemStack stack) {
        List<BrewingRecipe> brewingRecipes = ArsNouveauAPI.getInstance().getAllPotionRecipes((Level)Minecraft.getInstance().level);
        ArrayList<SinglePageCtor> pages = new ArrayList<SinglePageCtor>();
        ArrayList<BrewingRecipe> matchingRecipes = new ArrayList<BrewingRecipe>();
        for (BrewingRecipe recipe : brewingRecipes) {
            if (!recipe.isInput(stack) && !recipe.isIngredient(stack) && !ItemStack.isSameItem((ItemStack)stack, (ItemStack)recipe.getOutput())) continue;
            matchingRecipes.add(recipe);
        }
        BrewingRecipe recipe1 = null;
        for (BrewingRecipe matchingRecipe : matchingRecipes) {
            if (recipe1 == null) {
                recipe1 = matchingRecipe;
                continue;
            }
            pages.add(PotionRecipeEntry.create(recipe1, matchingRecipe));
            recipe1 = null;
        }
        if (recipe1 != null) {
            pages.add(PotionRecipeEntry.create(recipe1, null));
        }
        return pages;
    }

    public static Component getLangPath(String name, int count) {
        return Component.translatable((String)("ars_nouveau.page" + count + "." + name));
    }

    public static Component getLangPath(String namespace, String name, int count) {
        return Component.translatable((String)(namespace + ".page" + count + "." + name));
    }

    public static DocCategory glyphCategory(SpellTier tier) {
        return switch (tier.value) {
            case 1 -> DocumentationRegistry.GLYPH_TIER_ONE;
            case 2 -> DocumentationRegistry.GLYPH_TIER_TWO;
            case 3, 99 -> DocumentationRegistry.GLYPH_TIER_THREE;
            default -> DocumentationRegistry.GLYPH_TIER_ONE;
        };
    }
}

