/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.DispenserRitualBehavior;
import com.hollingsworth.arsnouveau.common.block.CreativeSourceJar;
import com.hollingsworth.arsnouveau.common.block.MobJar;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.util.Log;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class DispenserBehaviorRegistry {
    public static void register() {
        for (RitualTablet tablet : RitualRegistry.getRitualItemMap().values()) {
            DispenserBlock.registerBehavior((ItemLike)tablet, (DispenseItemBehavior)new DispenserRitualBehavior());
        }
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)BlockRegistry.SOURCE_JAR.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            @NotNull
            protected ItemStack execute(@NotNull BlockSource blockSource, @NotNull ItemStack item) {
                ServerLevel level = blockSource.level();
                BlockPos pos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                SourceJar jar = (SourceJar)((Object)BlockRegistry.SOURCE_JAR.get());
                BlockItem blockItem = (BlockItem)jar.asItem();
                try {
                    this.setSuccess(blockItem.place((BlockPlaceContext)new UnbiasedDirectionalPlaceContext((Level)level, pos, Direction.DOWN, item, Direction.UP)).consumesAction());
                }
                catch (Exception exception) {
                    Log.getLogger().error("Error trying to place source jar at {}", (Object)pos, (Object)exception);
                }
                return item;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)BlockRegistry.CREATIVE_SOURCE_JAR.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            @NotNull
            protected ItemStack execute(@NotNull BlockSource blockSource, @NotNull ItemStack item) {
                ServerLevel level = blockSource.level();
                BlockPos pos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                CreativeSourceJar jar = (CreativeSourceJar)((Object)BlockRegistry.CREATIVE_SOURCE_JAR.get());
                BlockItem blockItem = (BlockItem)jar.asItem();
                try {
                    this.setSuccess(blockItem.place((BlockPlaceContext)new UnbiasedDirectionalPlaceContext((Level)level, pos, Direction.DOWN, item, Direction.UP)).consumesAction());
                }
                catch (Exception exception) {
                    Log.getLogger().error("Error trying to place creative source jar at {}", (Object)pos, (Object)exception);
                }
                return item;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)BlockRegistry.MOB_JAR.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            @NotNull
            protected ItemStack execute(@NotNull BlockSource blockSource, @NotNull ItemStack item) {
                ServerLevel level = blockSource.level();
                Direction direction = ((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING)).getOpposite();
                BlockPos pos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                MobJar jar = (MobJar)BlockRegistry.MOB_JAR.get();
                BlockItem blockItem = (BlockItem)jar.asItem();
                try {
                    this.setSuccess(blockItem.place((BlockPlaceContext)new UnbiasedDirectionalPlaceContext((Level)level, pos, direction, item, direction)).consumesAction());
                }
                catch (Exception exception) {
                    Log.getLogger().error("Error trying to place containment jar at {}", (Object)pos, (Object)exception);
                }
                return item;
            }
        });
    }

    public static class UnbiasedDirectionalPlaceContext
    extends DirectionalPlaceContext {
        private final Direction direction;

        public UnbiasedDirectionalPlaceContext(Level level, BlockPos pos, Direction direction, ItemStack itemStack, Direction face) {
            super(level, pos, direction, itemStack, face);
            this.direction = direction;
        }

        @NotNull
        public Direction getNearestLookingDirection() {
            return this.direction;
        }

        public Direction @NotNull [] getNearestLookingDirections() {
            Direction[] directionArray;
            switch (this.direction) {
                default: {
                    Direction[] directionArray2 = new Direction[6];
                    directionArray2[0] = Direction.DOWN;
                    directionArray2[1] = Direction.NORTH;
                    directionArray2[2] = Direction.EAST;
                    directionArray2[3] = Direction.SOUTH;
                    directionArray2[4] = Direction.WEST;
                    directionArray = directionArray2;
                    directionArray2[5] = Direction.UP;
                    break;
                }
                case UP: {
                    Direction[] directionArray3 = new Direction[6];
                    directionArray3[0] = Direction.UP;
                    directionArray3[1] = Direction.DOWN;
                    directionArray3[2] = Direction.NORTH;
                    directionArray3[3] = Direction.EAST;
                    directionArray3[4] = Direction.SOUTH;
                    directionArray = directionArray3;
                    directionArray3[5] = Direction.WEST;
                    break;
                }
                case NORTH: {
                    Direction[] directionArray4 = new Direction[6];
                    directionArray4[0] = Direction.NORTH;
                    directionArray4[1] = Direction.DOWN;
                    directionArray4[2] = Direction.EAST;
                    directionArray4[3] = Direction.WEST;
                    directionArray4[4] = Direction.UP;
                    directionArray = directionArray4;
                    directionArray4[5] = Direction.SOUTH;
                    break;
                }
                case SOUTH: {
                    Direction[] directionArray5 = new Direction[6];
                    directionArray5[0] = Direction.SOUTH;
                    directionArray5[1] = Direction.DOWN;
                    directionArray5[2] = Direction.EAST;
                    directionArray5[3] = Direction.WEST;
                    directionArray5[4] = Direction.UP;
                    directionArray = directionArray5;
                    directionArray5[5] = Direction.NORTH;
                    break;
                }
                case WEST: {
                    Direction[] directionArray6 = new Direction[6];
                    directionArray6[0] = Direction.WEST;
                    directionArray6[1] = Direction.DOWN;
                    directionArray6[2] = Direction.SOUTH;
                    directionArray6[3] = Direction.UP;
                    directionArray6[4] = Direction.NORTH;
                    directionArray = directionArray6;
                    directionArray6[5] = Direction.EAST;
                    break;
                }
                case EAST: {
                    Direction[] directionArray7 = new Direction[6];
                    directionArray7[0] = Direction.EAST;
                    directionArray7[1] = Direction.DOWN;
                    directionArray7[2] = Direction.SOUTH;
                    directionArray7[3] = Direction.UP;
                    directionArray7[4] = Direction.NORTH;
                    directionArray = directionArray7;
                    directionArray7[5] = Direction.WEST;
                }
            }
            return directionArray;
        }
    }
}

