/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.container.AbstractStorageTerminalScreen;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class ServerToClientStoragePacket
extends AbstractPacket {
    public String searchString;
    public List<String> tabNames;
    public static final CustomPacketPayload.Type<ServerToClientStoragePacket> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("server_to_client_storage"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerToClientStoragePacket> CODEC = StreamCodec.ofMember(ServerToClientStoragePacket::toBytes, ServerToClientStoragePacket::new);

    public ServerToClientStoragePacket(String searchString, List<String> tabNames) {
        this.searchString = searchString == null ? "" : searchString;
        this.tabNames = tabNames;
    }

    public ServerToClientStoragePacket(RegistryFriendlyByteBuf pb) {
        this.searchString = (String)ByteBufCodecs.STRING_UTF8.decode((Object)pb);
        this.tabNames = (List)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()).decode((Object)pb);
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf pb) {
        ByteBufCodecs.STRING_UTF8.encode((Object)pb, (Object)this.searchString);
        ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()).encode((Object)pb, this.tabNames);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Screen screen = minecraft.screen;
        if (screen instanceof AbstractStorageTerminalScreen) {
            AbstractStorageTerminalScreen terminalScreen = (AbstractStorageTerminalScreen)screen;
            terminalScreen.receiveServerSettings(this.searchString, this.tabNames);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

