/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.network.ChangeBiomePacket;
import com.hollingsworth.arsnouveau.common.network.ClientSearchPacket;
import com.hollingsworth.arsnouveau.common.network.ClientSlotClick;
import com.hollingsworth.arsnouveau.common.network.ClientTransferHandlerPacket;
import com.hollingsworth.arsnouveau.common.network.HighlightAreaPacket;
import com.hollingsworth.arsnouveau.common.network.NotEnoughManaPacket;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.network.PacketAddFadingLight;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import com.hollingsworth.arsnouveau.common.network.PacketClientDelayEffect;
import com.hollingsworth.arsnouveau.common.network.PacketClientRewindEffect;
import com.hollingsworth.arsnouveau.common.network.PacketConsumePotion;
import com.hollingsworth.arsnouveau.common.network.PacketDismountCamera;
import com.hollingsworth.arsnouveau.common.network.PacketDispelFamiliars;
import com.hollingsworth.arsnouveau.common.network.PacketExportDocs;
import com.hollingsworth.arsnouveau.common.network.PacketGenericClientMessage;
import com.hollingsworth.arsnouveau.common.network.PacketGetPersistentData;
import com.hollingsworth.arsnouveau.common.network.PacketHotkeyPressed;
import com.hollingsworth.arsnouveau.common.network.PacketInitDocs;
import com.hollingsworth.arsnouveau.common.network.PacketJoinedServer;
import com.hollingsworth.arsnouveau.common.network.PacketMountCamera;
import com.hollingsworth.arsnouveau.common.network.PacketNoSpamChatMessage;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.common.network.PacketOpenGlyphCraft;
import com.hollingsworth.arsnouveau.common.network.PacketOpenSpellBook;
import com.hollingsworth.arsnouveau.common.network.PacketQuickCast;
import com.hollingsworth.arsnouveau.common.network.PacketReactiveSpell;
import com.hollingsworth.arsnouveau.common.network.PacketSetCameraView;
import com.hollingsworth.arsnouveau.common.network.PacketSetCasterSlot;
import com.hollingsworth.arsnouveau.common.network.PacketSetLauncher;
import com.hollingsworth.arsnouveau.common.network.PacketSetScribeRecipe;
import com.hollingsworth.arsnouveau.common.network.PacketSetSound;
import com.hollingsworth.arsnouveau.common.network.PacketSummonDog;
import com.hollingsworth.arsnouveau.common.network.PacketSummonFamiliar;
import com.hollingsworth.arsnouveau.common.network.PacketSyncLitEntities;
import com.hollingsworth.arsnouveau.common.network.PacketSyncPlayerCap;
import com.hollingsworth.arsnouveau.common.network.PacketSyncTag;
import com.hollingsworth.arsnouveau.common.network.PacketTimedEvent;
import com.hollingsworth.arsnouveau.common.network.PacketToggleFamiliar;
import com.hollingsworth.arsnouveau.common.network.PacketToggleLight;
import com.hollingsworth.arsnouveau.common.network.PacketUnsummonDog;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateBookGUI;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateCaster;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateDominionWand;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateFlight;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateGlowColor;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateMana;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateSpellColorAll;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateSpellColors;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateSpellSoundAll;
import com.hollingsworth.arsnouveau.common.network.PacketWarpPosition;
import com.hollingsworth.arsnouveau.common.network.PotionSyncPacket;
import com.hollingsworth.arsnouveau.common.network.ServerToClientStoragePacket;
import com.hollingsworth.arsnouveau.common.network.SetTerminalSettingsPacket;
import com.hollingsworth.arsnouveau.common.network.UpdateStorageItemsPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class Networking {
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar reg = event.registrar("1");
        reg.playToClient(PacketOpenSpellBook.TYPE, PacketOpenSpellBook.CODEC, Networking::handle);
        reg.playToClient(ChangeBiomePacket.TYPE, ChangeBiomePacket.CODEC, Networking::handle);
        reg.playToServer(PacketSetLauncher.TYPE, PacketSetLauncher.CODEC, Networking::handle);
        reg.playToServer(ClientSearchPacket.TYPE, ClientSearchPacket.CODEC, Networking::handle);
        reg.playToServer(ClientSlotClick.TYPE, ClientSlotClick.STREAM_CODEC, Networking::handle);
        reg.playToServer(ClientTransferHandlerPacket.TYPE, ClientTransferHandlerPacket.CODEC, Networking::handle);
        reg.playBidirectional(SetTerminalSettingsPacket.TYPE, SetTerminalSettingsPacket.CODEC, (IPayloadHandler)new DirectionalPayloadHandler((msg, ctx) -> ClientMessageHandler.handleClient(msg, ctx), (msg, ctx) -> msg.onServerReceived(ctx.player().getServer(), (ServerPlayer)ctx.player())));
        reg.playToClient(HighlightAreaPacket.TYPE, HighlightAreaPacket.CODEC, Networking::handle);
        reg.playToClient(NotEnoughManaPacket.TYPE, NotEnoughManaPacket.CODEC, Networking::handle);
        reg.playToClient(PacketAddFadingLight.TYPE, PacketAddFadingLight.CODEC, Networking::handle);
        reg.playToClient(PacketANEffect.TYPE, PacketANEffect.CODEC, Networking::handle);
        reg.playToClient(PacketClientDelayEffect.TYPE, PacketClientDelayEffect.CODEC, Networking::handle);
        reg.playToClient(PacketClientRewindEffect.TYPE, PacketClientRewindEffect.CODEC, Networking::handle);
        reg.playToServer(PacketConsumePotion.TYPE, PacketConsumePotion.CODEC, Networking::handle);
        reg.playToServer(PacketDismountCamera.TYPE, PacketDismountCamera.CODEC, Networking::handle);
        reg.playToServer(PacketDispelFamiliars.TYPE, PacketDispelFamiliars.CODEC, Networking::handle);
        reg.playToClient(PacketAnimEntity.TYPE, PacketAnimEntity.CODEC, Networking::handle);
        reg.playToClient(PacketGetPersistentData.TYPE, PacketGetPersistentData.CODEC, Networking::handle);
        reg.playToServer(PacketHotkeyPressed.TYPE, PacketHotkeyPressed.CODEC, Networking::handle);
        reg.playToClient(PacketJoinedServer.TYPE, PacketJoinedServer.CODEC, Networking::handle);
        reg.playToClient(PacketInitDocs.TYPE, PacketInitDocs.CODEC, Networking::handle);
        reg.playToClient(PacketExportDocs.TYPE, PacketExportDocs.CODEC, Networking::handle);
        reg.playToServer(PacketGenericClientMessage.TYPE, PacketGenericClientMessage.CODEC, Networking::handle);
        reg.playToServer(PacketMountCamera.TYPE, PacketMountCamera.CODEC, Networking::handle);
        reg.playToClient(PacketNoSpamChatMessage.TYPE, PacketNoSpamChatMessage.CODEC, Networking::handle);
        reg.playToClient(PacketOneShotAnimation.TYPE, PacketOneShotAnimation.CODEC, Networking::handle);
        reg.playToClient(PacketOpenGlyphCraft.TYPE, PacketOpenGlyphCraft.CODEC, Networking::handle);
        reg.playToServer(PacketQuickCast.TYPE, PacketQuickCast.CODEC, Networking::handle);
        reg.playToServer(PacketReactiveSpell.TYPE, PacketReactiveSpell.CODEC, Networking::handle);
        reg.playToServer(PacketSetCasterSlot.TYPE, PacketSetCasterSlot.CODEC, Networking::handle);
        reg.playToClient(PacketSetCameraView.TYPE, PacketSetCameraView.CODEC, Networking::handle);
        reg.playToServer(PacketSetScribeRecipe.TYPE, PacketSetScribeRecipe.CODEC, Networking::handle);
        reg.playToServer(PacketSetSound.TYPE, PacketSetSound.CODEC, Networking::handle);
        reg.playToServer(PacketSummonFamiliar.TYPE, PacketSummonFamiliar.CODEC, Networking::handle);
        reg.playToServer(PacketSummonDog.TYPE, PacketSummonDog.CODEC, Networking::handle);
        reg.playToClient(PacketSyncLitEntities.TYPE, PacketSyncLitEntities.CODEC, Networking::handle);
        reg.playToClient(PacketSyncPlayerCap.TYPE, PacketSyncPlayerCap.CODEC, Networking::handle);
        reg.playToClient(PacketSyncTag.TYPE, PacketSyncTag.CODEC, Networking::handle);
        reg.playToClient(PacketTimedEvent.TYPE, PacketTimedEvent.CODEC, Networking::handle);
        reg.playToServer(PacketToggleFamiliar.TYPE, PacketToggleFamiliar.CODEC, Networking::handle);
        reg.playToClient(PacketToggleLight.TYPE, PacketToggleLight.CODEC, Networking::handle);
        reg.playToServer(PacketUnsummonDog.TYPE, PacketUnsummonDog.CODEC, Networking::handle);
        reg.playToClient(PacketUpdateBookGUI.TYPE, PacketUpdateBookGUI.CODEC, Networking::handle);
        reg.playToServer(PacketUpdateCaster.TYPE, PacketUpdateCaster.CODEC, Networking::handle);
        reg.playToClient(PacketUpdateFlight.TYPE, PacketUpdateFlight.CODEC, Networking::handle);
        reg.playToClient(PacketUpdateMana.TYPE, PacketUpdateMana.CODEC, Networking::handle);
        reg.playToServer(PacketUpdateSpellColorAll.TYPE, PacketUpdateSpellColorAll.CODEC, Networking::handle);
        reg.playToServer(PacketUpdateSpellColors.TYPE, PacketUpdateSpellColors.CODEC, Networking::handle);
        reg.playToServer(PacketUpdateSpellSoundAll.TYPE, PacketUpdateSpellSoundAll.CODEC, Networking::handle);
        reg.playToClient(PacketWarpPosition.TYPE, PacketWarpPosition.CODEC, Networking::handle);
        reg.playToClient(PotionSyncPacket.TYPE, PotionSyncPacket.CODEC, Networking::handle);
        reg.playToClient(ServerToClientStoragePacket.TYPE, ServerToClientStoragePacket.CODEC, Networking::handle);
        reg.playToClient(UpdateStorageItemsPacket.TYPE, UpdateStorageItemsPacket.CODEC, Networking::handle);
        reg.playToClient(PacketUpdateGlowColor.TYPE, PacketUpdateGlowColor.CODEC, Networking::handle);
        reg.playToServer(PacketUpdateDominionWand.TYPE, PacketUpdateDominionWand.CODEC, Networking::handle);
    }

    public static <T extends AbstractPacket> void handle(T message, IPayloadContext ctx) {
        if (ctx.flow().getReceptionSide() == LogicalSide.SERVER) {
            Networking.handleServer(message, ctx);
        } else {
            ClientMessageHandler.handleClient(message, ctx);
        }
    }

    private static <T extends AbstractPacket> void handleServer(T message, IPayloadContext ctx) {
        MinecraftServer server = ctx.player().getServer();
        message.onServerReceived(server, (ServerPlayer)ctx.player());
    }

    public static void sendToNearbyClient(Level world, BlockPos pos, CustomPacketPayload toSend) {
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)ws, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)toSend, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToNearbyClient(Level world, Entity e, CustomPacketPayload toSend) {
        Networking.sendToNearbyClient(world, e.blockPosition(), toSend);
    }

    public static void sendToPlayerClient(CustomPacketPayload msg, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(CustomPacketPayload msg) {
        PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static class ClientMessageHandler {
        private ClientMessageHandler() {
        }

        public static <T extends AbstractPacket> void handleClient(T message, IPayloadContext ctx) {
            Minecraft minecraft = Minecraft.getInstance();
            message.onClientReceived(minecraft, (Player)minecraft.player);
        }
    }
}

