/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.summon_charms;

import com.hollingsworth.arsnouveau.api.item.AbstractSummonCharm;
import com.hollingsworth.arsnouveau.client.jei.AliasProvider;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.items.data.StarbuncleCharmData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class StarbuncleCharm
extends AbstractSummonCharm
implements AliasProvider {
    public StarbuncleCharm() {
        super(StarbuncleCharm.defaultProps().component(DataComponentRegistry.STARBUNCLE_DATA, (Object)new StarbuncleCharmData()));
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context, Level world, BlockPos pos) {
        Starbuncle carbuncle = new Starbuncle(world, true);
        StarbuncleCharmData data = (StarbuncleCharmData)context.getItemInHand().getOrDefault(DataComponentRegistry.STARBUNCLE_DATA, (Object)new StarbuncleCharmData());
        pos = pos.relative(context.getClickedFace());
        carbuncle.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        carbuncle.data = data.mutable();
        world.addFreshEntity((Entity)carbuncle);
        carbuncle.restoreFromTag();
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult useOnSummonTile(UseOnContext context, Level world, SummoningTile tile, BlockPos pos) {
        return this.useOnBlock(context, world, pos);
    }

    @Override
    public Collection<AliasProvider.Alias> getAliases() {
        return List.of(new AliasProvider.Alias("hopper", "Hopper"), new AliasProvider.Alias("pipe", "Pipe"), new AliasProvider.Alias("item_transporter", "Item Transporter"));
    }
}

