/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.common.items.data.PerkMap;
import com.hollingsworth.arsnouveau.common.perk.StarbunclePerk;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public abstract class StackPerkHolder<T>
implements IPerkHolder<T> {
    public static Codec<IPerk> PERK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("perk").forGetter(IPerk::getRegistryName)).apply((Applicative)instance, name -> PerkRegistry.getPerkMap().getOrDefault(name, StarbunclePerk.INSTANCE)));
    private List<IPerk> perks;
    private int tier;
    private PerkMap perkTags;

    public StackPerkHolder(List<IPerk> perks, int tier, Map<IPerk, CompoundTag> perkTags) {
        this(perks, tier, new PerkMap(Map.copyOf(perkTags)));
    }

    public StackPerkHolder(List<IPerk> perks, int tier, PerkMap perkTags) {
        this.perks = List.copyOf(perks);
        this.tier = tier;
        this.perkTags = perkTags;
    }

    @Override
    public List<IPerk> getPerks() {
        return this.perks;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public PerkMap getPerkTags() {
        return this.perkTags;
    }

    @Override
    @Nullable
    public CompoundTag getTagForPerk(IPerk perk) {
        return this.perkTags.map().getOrDefault(perk, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackPerkHolder that = (StackPerkHolder)o;
        return this.tier == that.tier && Objects.equals(this.perks, that.perks) && Objects.equals(this.perkTags, that.perkTags);
    }

    public int hashCode() {
        return Objects.hash(this.perks, this.tier, this.perkTags);
    }
}

