/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.client.jei.AliasProvider;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.ItemScrollData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ItemScroll
extends ModItem
implements IScribeable,
AliasProvider {
    public ItemScroll() {
        super(ItemsRegistry.defaultItemProperties().component(DataComponentRegistry.ITEM_SCROLL_DATA, (Object)new ItemScrollData(List.of())));
    }

    public ItemScroll(Item.Properties properties) {
        super(properties);
    }

    public abstract SortPref getSortPref(ItemStack var1, ItemStack var2, IItemHandler var3);

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        if (pUsedHand == InteractionHand.MAIN_HAND && !pLevel.isClientSide) {
            ItemStack thisStack = pPlayer.getItemInHand(pUsedHand);
            ItemStack otherStack = pPlayer.getItemInHand(InteractionHand.OFF_HAND);
            if (!otherStack.isEmpty()) {
                this.onScribe(pLevel, pPlayer.blockPosition(), pPlayer, InteractionHand.OFF_HAND, thisStack);
                return InteractionResultHolder.success((Object)thisStack);
            }
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack thisStack) {
        ItemStack stackToWrite = player.getItemInHand(handIn);
        ItemScrollData existingList = (ItemScrollData)thisStack.getOrDefault(DataComponentRegistry.ITEM_SCROLL_DATA, (Object)new ItemScrollData(List.of()));
        ItemScrollData.Mutable mutable = existingList.mutable();
        boolean success = mutable.writeWithFeedback(player, stackToWrite);
        thisStack.set(DataComponentRegistry.ITEM_SCROLL_DATA, (Object)mutable.toImmutable());
        return success;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        stack.addToTooltip(DataComponentRegistry.ITEM_SCROLL_DATA, context, tooltip2::add, flagIn);
    }

    @Override
    public Collection<AliasProvider.Alias> getAliases() {
        return List.of(new AliasProvider.Alias("filter", "Filter"));
    }

    public static enum SortPref {
        INVALID,
        LOW,
        HIGH,
        HIGHEST;

    }
}

