/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.CodexData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AnnotatedCodex
extends ModItem {
    public AnnotatedCodex(Item.Properties properties) {
        super(properties);
    }

    public AnnotatedCodex() {
        this(ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.CODEX_DATA, (Object)new CodexData(Optional.empty(), null, List.of())));
    }

    public int getUnlockLevelCost(Collection<AbstractSpellPart> spellParts) {
        int expPerGlyph = (Integer)ServerConfig.CODEX_COST_PER_GLYPH.get();
        return ScribesTile.getLevelsFromExp(expPerGlyph * spellParts.size());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        if (pPlayer.level.isClientSide) {
            return super.use(pLevel, pPlayer, pUsedHand);
        }
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        CodexData data = (CodexData)stack.get(DataComponentRegistry.CODEX_DATA);
        ANPlayerDataCap playerCap = CapabilityRegistry.getPlayerDataCap((LivingEntity)pPlayer);
        if (data == null || playerCap == null) {
            return super.use(pLevel, pPlayer, pUsedHand);
        }
        Collection<AbstractSpellPart> known = playerCap.getKnownGlyphs();
        List<AbstractSpellPart> storedGlyphs = data.glyphIds().stream().map(GlyphRegistry::getSpellPart).toList();
        if (!data.wasRecorded()) {
            int levelCost = this.getUnlockLevelCost(playerCap.getKnownGlyphs());
            int expCost = ScribesTile.getExperienceForLevel(levelCost);
            if (expCost > ScribesTile.getTotalPlayerExperience(pPlayer)) {
                PortUtil.sendMessageNoSpam((Entity)pPlayer, (Component)Component.translatable((String)"ars_nouveau.codex_not_enough_exp", (Object[])new Object[]{levelCost}));
            } else {
                CodexData newData = new CodexData(pPlayer.getUUID(), pPlayer.getName().getString(), playerCap.getKnownGlyphs().stream().map(AbstractSpellPart::getRegistryName).toList());
                stack.set(DataComponentRegistry.CODEX_DATA, (Object)newData);
                PortUtil.sendMessageNoSpam((Entity)pPlayer, (Component)Component.translatable((String)"ars_nouveau.recorded_codex"));
                pPlayer.giveExperiencePoints(-expCost);
            }
        } else if (pPlayer.getUUID().equals(data.uuid().orElse(null))) {
            ArrayList<AbstractSpellPart> difference = new ArrayList<AbstractSpellPart>();
            for (AbstractSpellPart spellPart : known) {
                if (storedGlyphs.contains(spellPart)) continue;
                difference.add(spellPart);
            }
            int levelCost = this.getUnlockLevelCost(difference);
            if (!difference.isEmpty()) {
                int expCost = ScribesTile.getExperienceForLevel(levelCost);
                if (expCost > ScribesTile.getTotalPlayerExperience(pPlayer)) {
                    PortUtil.sendMessageNoSpam((Entity)pPlayer, (Component)Component.translatable((String)"ars_nouveau.codex_not_enough_exp", (Object[])new Object[]{levelCost}));
                } else {
                    pPlayer.giveExperiencePoints(-expCost);
                    CodexData newData = new CodexData(pPlayer.getUUID(), pPlayer.getName().getString(), playerCap.getKnownGlyphs().stream().map(AbstractSpellPart::getRegistryName).toList());
                    stack.set(DataComponentRegistry.CODEX_DATA, (Object)newData);
                    PortUtil.sendMessageNoSpam((Entity)pPlayer, (Component)Component.translatable((String)"ars_nouveau.updated_codex"));
                }
            } else {
                PortUtil.sendMessageNoSpam((Entity)pPlayer, (Component)Component.translatable((String)"ars_nouveau.codex_up_to_date"));
            }
        } else {
            int numUnlocked = 0;
            for (AbstractSpellPart storedPart : storedGlyphs) {
                if (known.contains(storedPart)) continue;
                playerCap.unlockGlyph(storedPart);
                ++numUnlocked;
            }
            if (numUnlocked > 0) {
                if (!pPlayer.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                PortUtil.sendMessageNoSpam((Entity)pPlayer, (Component)Component.translatable((String)"ars_nouveau.consumed_codex", (Object[])new Object[]{numUnlocked}));
                CapabilityRegistry.EventHandler.syncPlayerCap(pPlayer);
            } else {
                PortUtil.sendMessageNoSpam((Entity)pPlayer, (Component)Component.translatable((String)"ars_nouveau.codex_no_use"));
            }
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        stack.addToTooltip(DataComponentRegistry.CODEX_DATA, context, tooltip2::add, flagIn);
    }
}

