/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.DecideStarbyActionState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.TravelToPosState;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class DepositItemState
extends TravelToPosState {
    public DepositItemState(Starbuncle starbuncle, StarbyTransportBehavior behavior, BlockPos target) {
        super(starbuncle, behavior, target, new DecideStarbyActionState(starbuncle, behavior));
    }

    @Override
    public StarbyState onDestinationReached() {
        this.starbuncle.getNavigation().stop();
        Level world = this.starbuncle.level;
        BlockEntity tileEntity = world.getBlockEntity(this.targetPos);
        if (tileEntity == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("missing_tile", "store pos broken " + this.targetPos.toString()));
            this.starbuncle.setBackOff(5 + this.starbuncle.level.random.nextInt(20));
            return this.nextState;
        }
        IItemHandler iItemHandler = this.behavior.getItemCapFromTile(this.targetPos, (Direction)this.behavior.TO_DIRECTION_MAP.get(this.targetPos.hashCode()));
        if (iItemHandler == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("NoItemHandler", "No item handler at " + this.targetPos.toString()));
            return this.nextState;
        }
        boolean didDeposit = this.depositStack(iItemHandler);
        if (!didDeposit) {
            this.starbuncle.setBackOff(5 + this.starbuncle.level.random.nextInt(20));
            this.starbuncle.addGoalDebug(this, new DebugEvent("no_room", this.targetPos.toString()));
            return this.nextState;
        }
        OpenChestEvent event = new OpenChestEvent((ServerLevel)this.starbuncle.level, this.targetPos, 20);
        event.open();
        EventQueue.getServerInstance().addEvent(event);
        ItemStack left = this.starbuncle.getHeldStack();
        this.starbuncle.addGoalDebug(this, new DebugEvent("stored_item", "successful at " + this.targetPos.toString() + "set stack to " + left.getCount() + "x " + left.getHoverName().getString()));
        boolean fetchPassengerStack = left.isEmpty();
        while (fetchPassengerStack) {
            fetchPassengerStack = false;
            this.starbuncle.getNextItemFromPassengers();
            if (this.starbuncle.getHeldStack().isEmpty()) continue;
            fetchPassengerStack = this.depositStack(iItemHandler) && this.starbuncle.getHeldStack().isEmpty();
        }
        return this.nextState;
    }

    public boolean depositStack(IItemHandler iItemHandler) {
        ItemStack oldStack = new ItemStack((ItemLike)this.starbuncle.getHeldStack().getItem(), this.starbuncle.getHeldStack().getCount());
        ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)this.starbuncle.getHeldStack(), (boolean)false);
        this.starbuncle.setHeldStack(left);
        return !left.equals(oldStack);
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return this.behavior.sortPrefForStack(pos, this.starbuncle.getHeldStack()) != ItemScroll.SortPref.INVALID;
    }
}

