/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.IStateEvent;
import com.hollingsworth.arsnouveau.common.entity.statemachine.SimpleStateMachine;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.DecideStarbyActionState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.util.ItemUtil;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class StarbyTransportBehavior
extends StarbyListBehavior {
    public static Cache<BlockPos, List<ItemEntity>> frameCache = CacheBuilder.newBuilder().expireAfterAccess(20L, TimeUnit.SECONDS).build();
    public static final ResourceLocation TRANSPORT_ID = ArsNouveau.prefix("starby_transport");
    public ItemStack itemScroll = ItemStack.EMPTY;
    public SimpleStateMachine<StarbyState, IStateEvent> stateMachine = new SimpleStateMachine(new DecideStarbyActionState(this.starbuncle, this));
    public int berryBackoff;
    public int nextBerryBackoff = 20;
    public int findItemBackoff;
    public int takeItemBackoff;

    public StarbyTransportBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (!entity.isTamed()) {
            return;
        }
        this.itemScroll = ItemStack.parseOptional((HolderLookup.Provider)entity.level.registryAccess(), (CompoundTag)tag.getCompound("itemScroll"));
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.starbuncle.isEffectiveAi()) {
            return;
        }
        if (!this.level.isClientSide) {
            if (this.berryBackoff > 0) {
                --this.berryBackoff;
            }
            if (this.findItemBackoff > 0) {
                --this.findItemBackoff;
            }
            if (this.takeItemBackoff > 0) {
                --this.takeItemBackoff;
            }
            this.stateMachine.tick();
        }
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof ItemScroll) {
            ItemScroll scroll = (ItemScroll)item;
            this.itemScroll = stack.copy();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.filter_set"));
            this.syncTag();
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void pickUpItem(ItemEntity itemEntity) {
        super.pickUpItem(itemEntity);
        if (this.getValidStorePos(itemEntity.getItem()) == null || this.isPickupDisabled()) {
            return;
        }
        Starbuncle starbuncleWithRoom = this.starbuncle.getStarbuncleWithSpace();
        starbuncleWithRoom.setHeldStack(itemEntity.getItem());
        itemEntity.remove(Entity.RemovalReason.DISCARDED);
        this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_PICKUP, this.starbuncle.getSoundSource(), 1.0f, 1.0f);
        for (ItemEntity i : this.level.getEntitiesOfClass(ItemEntity.class, this.starbuncle.getBoundingBox().inflate(3.0))) {
            if (itemEntity.getItem().getCount() >= itemEntity.getItem().getMaxStackSize()) break;
            int maxTake = starbuncleWithRoom.getHeldStack().getMaxStackSize() - starbuncleWithRoom.getHeldStack().getCount();
            if (!ItemStack.isSameItemSameComponents((ItemStack)i.getItem(), (ItemStack)starbuncleWithRoom.getHeldStack())) continue;
            int toTake = Math.min(i.getItem().getCount(), maxTake);
            i.getItem().shrink(toTake);
            starbuncleWithRoom.getHeldStack().grow(toTake);
        }
    }

    public BlockPos getValidStorePos(ItemStack stack) {
        if (this.TO_LIST.isEmpty() || stack.isEmpty()) {
            return null;
        }
        BlockPos returnPos = null;
        ItemScroll.SortPref foundPref = ItemScroll.SortPref.INVALID;
        for (BlockPos b : this.TO_LIST) {
            ItemScroll.SortPref pref = this.sortPrefForStack(b, stack);
            if (pref.ordinal() <= foundPref.ordinal()) continue;
            foundPref = pref;
            returnPos = b;
            if (foundPref != ItemScroll.SortPref.HIGHEST) continue;
            return returnPos;
        }
        return returnPos;
    }

    public ItemScroll.SortPref sortPrefForStack(@Nullable BlockPos b, ItemStack stack) {
        if (stack == null || stack.isEmpty() || b == null || !this.level.isLoaded(b)) {
            return ItemScroll.SortPref.INVALID;
        }
        return this.canDepositItem(b, stack);
    }

    public boolean isPickupDisabled() {
        return this.starbuncle.getCosmeticItem().getItem() == ItemsRegistry.STARBUNCLE_SHADES.get();
    }

    @Nullable
    public IItemHandler getItemCapFromTile(BlockPos pos, @Nullable Direction face) {
        return (IItemHandler)this.starbuncle.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)face);
    }

    @Nullable
    public BlockPos getValidTakePos() {
        if (this.FROM_LIST.isEmpty()) {
            return null;
        }
        for (BlockPos p : this.FROM_LIST) {
            if (!this.isPositionValidTake(p)) continue;
            return p;
        }
        return null;
    }

    public boolean isPositionValidTake(BlockPos p) {
        if (p == null || !this.level.isLoaded(p)) {
            return false;
        }
        Direction face = (Direction)this.FROM_DIRECTION_MAP.get(p.hashCode());
        IItemHandler iItemHandler = this.getItemCapFromTile(p, face);
        if (iItemHandler == null) {
            return false;
        }
        for (int j = 0; j < iItemHandler.getSlots(); ++j) {
            ItemStack stack = iItemHandler.getStackInSlot(j);
            if (stack.isEmpty() || this.getValidStorePos(stack) == null) continue;
            return true;
        }
        return false;
    }

    public int getMaxTake(ItemStack stack) {
        if (this.getValidStorePos(stack) == null) {
            return -1;
        }
        BlockPos validStorePos = this.getValidStorePos(stack);
        if (validStorePos == null) {
            return -1;
        }
        IItemHandler handler = this.getItemCapFromTile(validStorePos, (Direction)this.FROM_DIRECTION_MAP.get(validStorePos.hashCode()));
        if (handler == null) {
            return -1;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack simStack;
            int originalCount;
            int maxRoom;
            ItemStack handlerStack = handler.getStackInSlot(i);
            if (handlerStack.isEmpty()) {
                return handler.getSlotLimit(i);
            }
            if (!ItemUtil.canStack(handler.getStackInSlot(i), stack) || (maxRoom = (originalCount = stack.getCount()) - (simStack = handler.insertItem(i, stack, true)).getCount()) <= 0) continue;
            return Math.min(maxRoom, handler.getSlotLimit(i));
        }
        return -1;
    }

    private ItemScroll.SortPref canDepositItem(BlockPos pos, ItemStack stack) {
        ItemScroll scrollItem;
        Item item;
        ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
        if (pos == null || stack == null || stack.isEmpty()) {
            return ItemScroll.SortPref.INVALID;
        }
        IItemHandler handler = this.getItemCapFromTile(pos, (Direction)this.TO_DIRECTION_MAP.get(pos.hashCode()));
        if (handler == null) {
            return ItemScroll.SortPref.INVALID;
        }
        for (ItemFrame i : this.level.getEntitiesOfClass(ItemFrame.class, new AABB(pos).inflate(1.0))) {
            BlockEntity adjTile = this.level.getBlockEntity(i.blockPosition().relative(i.getDirection().getOpposite()));
            if (adjTile == null || !adjTile.equals(this.level.getBlockEntity(pos)) || i.getItem().isEmpty()) continue;
            ItemStack stackInFrame = i.getItem();
            Item item2 = stackInFrame.getItem();
            if (item2 instanceof ItemScroll) {
                ItemScroll scrollItem2 = (ItemScroll)item2;
                pref = scrollItem2.getSortPref(stack, stackInFrame, handler);
                continue;
            }
            if (i.getItem().getItem() != stack.getItem()) {
                return ItemScroll.SortPref.INVALID;
            }
            if (i.getItem().getItem() != stack.getItem()) continue;
            pref = ItemScroll.SortPref.HIGHEST;
        }
        if (this.itemScroll != null && (item = this.itemScroll.getItem()) instanceof ItemScroll && (scrollItem = (ItemScroll)item).getSortPref(stack, this.itemScroll, handler) == ItemScroll.SortPref.INVALID) {
            return ItemScroll.SortPref.INVALID;
        }
        return !ItemStack.matches((ItemStack)ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack.copy(), (boolean)true), (ItemStack)stack) ? pref : ItemScroll.SortPref.INVALID;
    }

    @Override
    public boolean canGoToBed() {
        return this.isBedPowered() || this.getValidTakePos() == null && (this.starbuncle.getHeldStack().isEmpty() || this.getValidStorePos(this.starbuncle.getHeldStack()) == null);
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, side, storedEntity, playerEntity);
        if (storedPos == null) {
            return;
        }
        IItemHandler cap = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, storedPos, (Object)side);
        if (cap != null) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.store"));
            this.addToPos(storedPos, side);
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, storedEntity, playerEntity);
        if (storedPos == null) {
            return;
        }
        IItemHandler cap = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, storedPos, (Object)side);
        if (cap != null) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.take"));
            this.addFromPos(storedPos, side);
        }
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.itemScroll = ItemStack.EMPTY;
        super.onWanded(playerEntity);
    }

    @Override
    public CompoundTag toTag(CompoundTag tag) {
        super.toTag(tag);
        if (!this.itemScroll.isEmpty()) {
            tag.put("itemScroll", this.itemScroll.save((HolderLookup.Provider)this.level.registryAccess()));
        }
        return tag;
    }

    @Override
    public void getTooltip(Consumer<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.storing", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.taking", (Object[])new Object[]{this.FROM_LIST.size()}));
        if (!this.itemScroll.isEmpty()) {
            tooltip.accept((Component)Component.translatable((String)"ars_nouveau.filtering_with", (Object[])new Object[]{this.itemScroll.getHoverName().getString()}));
        }
    }

    @Override
    public ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }
}

