/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.bookwyrm;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.goal.bookwyrm.TransferTask;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TransferGoal
extends Goal {
    public int time;
    public TransferTask task;
    public boolean isDone;
    public boolean reachedFrom;
    public EntityBookwyrm bookwyrm;

    public TransferGoal(EntityBookwyrm bookwyrm) {
        this.bookwyrm = bookwyrm;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public void start() {
        this.isDone = false;
        this.time = 0;
        this.reachedFrom = false;
    }

    public boolean canContinueToUse() {
        return this.task != null && !this.isDone;
    }

    public boolean canUse() {
        if (this.bookwyrm.level.getGameTime() % 2L != 0L && this.bookwyrm.getRandom().nextInt(10) != 0) {
            return false;
        }
        this.task = this.bookwyrm.getTransferTask();
        return this.task != null;
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        ++this.time;
        if (this.task == null || this.isDone || this.time > 200) {
            this.isDone = true;
            this.bookwyrm.setHeldStack(ItemStack.EMPTY);
            return;
        }
        if (!this.reachedFrom) {
            Vec3 vec3 = new Vec3(this.task.from.x, this.task.from.y(), this.task.from.z());
            if (BlockUtil.distanceFrom(this.bookwyrm.position(), vec3) <= 1.5) {
                this.reachedFrom = true;
                if (this.task != null) {
                    this.bookwyrm.setHeldStack(this.task.stack);
                    this.bookwyrm.level.playSound(null, this.bookwyrm.getX(), this.bookwyrm.getY(), this.bookwyrm.getZ(), SoundEvents.ITEM_PICKUP, this.bookwyrm.getSoundSource(), 0.3f + (float)ParticleUtil.inRange(-0.1, 0.1), 1.0f + (float)ParticleUtil.inRange(-0.1, 0.1));
                    Level level = this.bookwyrm.level;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        OpenChestEvent event = new OpenChestEvent(serverLevel, BlockPos.containing((Position)this.task.from.subtract(0.0, 1.0, 0.0)), 20);
                        event.open();
                        EventQueue.getServerInstance().addEvent(event);
                    }
                }
            } else {
                this.bookwyrm.getNavigation().moveTo(this.task.from.x(), this.task.from.y(), this.task.from.z(), 1.3);
                if (this.bookwyrm.getNavigation().getPath() == null) {
                    this.isDone = true;
                }
            }
        } else {
            Vec3 vec3 = new Vec3(this.task.to.x(), this.task.to.y(), this.task.to.z());
            if (BlockUtil.distanceFrom(this.bookwyrm.position(), vec3) <= 1.5) {
                this.isDone = true;
                this.bookwyrm.setHeldStack(ItemStack.EMPTY);
                Object event = this.bookwyrm.level;
                if (event instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)event;
                    event = new OpenChestEvent(serverLevel, BlockPos.containing((Position)this.task.to.subtract(0.0, 1.0, 0.0)), 20);
                    ((OpenChestEvent)event).open();
                    EventQueue.getServerInstance().addEvent((ITimedEvent)event);
                }
            } else {
                this.bookwyrm.getNavigation().moveTo(this.task.to.x(), this.task.to.y(), this.task.to.z(), 1.3);
                if (this.bookwyrm.getNavigation().getPath() == null) {
                    this.isDone = true;
                }
            }
        }
    }
}

