/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.common.entity.goal.ConditionalMeleeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraDiveGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraLeapRamGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraRageGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraRamGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraSpikeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraSummonGoal;
import com.hollingsworth.arsnouveau.common.potions.SnareEffect;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WildenChimera
extends Monster
implements GeoEntity {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true).setCreateWorldFog(true);
    public static final EntityDataAccessor<Boolean> HAS_SPIKES = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> HAS_HORNS = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> HAS_WINGS = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DEFENSIVE_MODE = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> PHASE_SWAPPING = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> IS_HOWLING = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> IS_DIVING = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> IS_RAMMING = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> RAM_PREP = SynchedEntityData.defineId(WildenChimera.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public boolean initMusic;
    public boolean isRamGoal;
    public int summonCooldown;
    public int diveCooldown;
    public int spikeCooldown;
    public int ramCooldown;
    public int rageTimer;
    public boolean diving;
    public int swapTicks;
    public FlyingPathNavigation flyingNavigator;
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    AnimationController<WildenChimera> crouchController;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public Vec3 orbitOffset = Vec3.ZERO;

    public WildenChimera(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.moveControl = new ChimeraMoveController(this, true);
        this.setPersistenceRequired();
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigator.setCanOpenDoors(true);
        flyingpathnavigator.setCanFloat(false);
        flyingpathnavigator.setCanPassDoors(true);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.flyingNavigator = flyingpathnavigator;
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
        this.rageTimer = 300;
        this.xpReward = 75;
    }

    public WildenChimera(Level level) {
        this((EntityType<? extends Monster>)((EntityType)ModEntities.WILDEN_BOSS.get()), level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new ConditionalMeleeGoal((PathfinderMob)this, 1.2, true, () -> !this.isHowling() && !this.isFlying() && !this.isDefensive() && !this.isDiving() && !this.getPhaseSwapping() && !this.isRamming() && !this.isRamPrep()));
        this.goalSelector.addGoal(3, (Goal)new ChimeraSummonGoal(this));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(1, (Goal)new ChimeraRageGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ChimeraLeapRamGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ChimeraRamGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ChimeraDiveGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ChimeraSpikeGoal(this));
    }

    public boolean isPushedByFluid() {
        return !this.isSwimming();
    }

    public boolean isPushedByFluid(FluidType type) {
        return !this.isSwimming();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        animatableManager.add(new AnimationController((GeoAnimatable)this, "walkController", 1, e -> {
            if (!(this.isDefensive() || !e.isMoving() || this.isFlying() || this.isHowling() || this.isSwimming() || this.isRamPrep() || this.isRamming())) {
                e.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        this.crouchController = new AnimationController((GeoAnimatable)this, "crouchController", 1, event -> {
            if (this.isDefensive() && !this.isFlying() && !this.isHowling()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("defending"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        });
        animatableManager.add(this.crouchController);
        animatableManager.add(new AnimationController((GeoAnimatable)this, "idleController", 1, event -> {
            if (!(event.isMoving() || this.isDefensive() || this.isFlying() || this.isHowling() || this.isRamPrep() || this.isRamming())) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "flyController", 1, event -> {
            if (this.isFlying() && !this.isDiving()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("fly_rising"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "diveController", 1, event -> {
            if (this.isDiving()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("dive"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "howlController", 1, e -> {
            if (this.isHowling()) {
                e.getController().setAnimation(RawAnimation.begin().thenPlay("roar"));
                return PlayState.CONTINUE;
            }
            e.getController().forceAnimationReset();
            return PlayState.STOP;
        }));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "swimController", 1, e -> {
            if (!this.isDefensive() && e.isMoving() && !this.isFlying() && !this.isHowling() && this.isSwimming()) {
                e.getController().setAnimation(RawAnimation.begin().thenPlay("swim"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "ramController", 1, event -> {
            if (this.isRamming() && !this.isRamPrep()) {
                if (!this.hasWings()) {
                    event.getController().setAnimation(RawAnimation.begin().thenPlay("charge"));
                }
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "ramPrep", 1, event -> {
            if (this.isRamPrep() && !this.isRamming()) {
                if (this.hasWings()) {
                    event.getController().setAnimation(RawAnimation.begin().thenPlay("wing_charge_prep"));
                } else {
                    event.getController().setAnimation(RawAnimation.begin().thenPlay("charge_prep"));
                }
                return PlayState.CONTINUE;
            }
            event.getController().forceAnimationReset();
            return PlayState.STOP;
        }));
    }

    public void updateSwimming() {
        if (!this.level.isClientSide) {
            if (this.isEffectiveAi() && this.isInWater() && this.wantsToSwim()) {
                this.navigation = this.waterNavigation;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigation;
                this.setSwimming(false);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide && !this.initMusic) {
            this.initMusic = true;
            ((Runnable)() -> ChimeraMusic.play(this)).run();
        }
        if (!this.level.isClientSide && this.isDefensive()) {
            this.getNavigation().stop();
        }
        if (this.level.isClientSide && this.isFlying() && this.random.nextInt(18) == 0) {
            this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.BAT_LOOP, this.getSoundSource(), 0.95f + this.random.nextFloat() * 0.05f, 0.3f + this.random.nextFloat() * 0.05f, false);
        }
        if (!this.level.isClientSide && this.isInLava() && this.level.getGameTime() % 10L == 0L) {
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 20, 4));
            this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 20, 3));
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 20));
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 20, 3));
        }
        if (this.isFlying()) {
            this.navigation.stop();
            this.flyingNavigator.tick();
        }
        if (!this.level.isClientSide) {
            if (this.summonCooldown > 0) {
                --this.summonCooldown;
            }
            if (this.diveCooldown > 0) {
                --this.diveCooldown;
                if (this.isInLava() || this.isInWater()) {
                    this.spikeCooldown -= 2;
                }
            }
            if (this.spikeCooldown > 0) {
                --this.spikeCooldown;
            }
            if (this.ramCooldown > 0) {
                --this.ramCooldown;
            }
        }
        if (!this.level.isClientSide && this.getPhaseSwapping() && !this.dead) {
            if (this.swapTicks < 60) {
                ++this.swapTicks;
                this.navigation.stop();
            } else {
                this.removeAllEffects();
                this.setPhaseSwapping(false);
                for (LivingEntity e : this.level.getEntitiesOfClass(Player.class, new AABB(this.blockPosition()).inflate(5.0))) {
                    EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(this.level, new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectKnockback.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2), (LivingEntity)this, new LivingCaster((LivingEntity)this)));
                    resolver.onCastOnEntity(ItemStack.EMPTY, (Entity)e, InteractionHand.MAIN_HAND);
                }
                this.getRandomUpgrade();
                ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition().above());
                if (this.getPhase() == 1) {
                    this.rageTimer = 200;
                }
                this.swapTicks = 0;
            }
        }
        if (this.getPhaseSwapping() && this.level.isClientSide) {
            WildenChimera.spawnPhaseParticles(this.blockPosition(), this.level, this.getPhase());
        }
    }

    public static void spawnPhaseParticles(BlockPos pos, Level level, int multiplier) {
        if (!level.isClientSide) {
            return;
        }
        int baseAge = 40;
        float scaleAge = (float)ParticleUtil.inRange(0.1, 0.2);
        for (int i = 0; i < 10 * Math.min(1, multiplier); ++i) {
            Vec3 particlePos = new Vec3((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ()).add(0.5, 0.5, 0.5);
            particlePos = particlePos.add(ParticleUtil.pointInSphere().multiply(3.0, 3.0, 3.0));
            level.addParticle(ParticleLineData.createData(ParticleColor.makeRandomColor(255, 255, 255, level.random), scaleAge, baseAge + level.random.nextInt(20)), particlePos.x(), particlePos.y(), particlePos.z(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        }
    }

    protected void dropCustomDeathLoot(ServerLevel p_348683_, DamageSource p_21385_, boolean p_21387_) {
        super.dropCustomDeathLoot(p_348683_, p_21385_, p_21387_);
        ItemEntity itementity = this.spawnAtLocation((ItemLike)ItemsRegistry.WILDEN_TRIBUTE.get());
        if (itementity != null) {
            itementity.setExtendedLifetime();
        }
    }

    protected void playStepSound(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.playSound(SoundEvents.POLAR_BEAR_STEP, 0.15f + this.random.nextFloat() * 0.3f, 0.8f + this.random.nextFloat() * 0.1f);
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.HOSTILE_SWIM;
    }

    public boolean isSilent() {
        return false;
    }

    protected SoundEvent getHurtSound(DamageSource p_184601_1_) {
        return SoundEvents.POLAR_BEAR_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.POLAR_BEAR_DEATH;
    }

    public void resetCooldowns() {
        this.spikeCooldown = 0;
        this.ramCooldown = 0;
        this.diveCooldown = 0;
        this.summonCooldown = 0;
    }

    public void heal(float p_70691_1_) {
        this.setHealth(this.getHealth() + p_70691_1_);
    }

    public boolean canDive() {
        return !this.isRamGoal && this.diveCooldown <= 0 && this.hasWings() && !this.getPhaseSwapping() && !this.isFlying() && this.onGround() && !this.isDefensive();
    }

    public boolean canSpike() {
        return !this.isRamGoal && this.spikeCooldown <= 0 && this.hasSpikes() && !this.getPhaseSwapping() && !this.isFlying() && this.onGround() && this.getTarget() != null;
    }

    public boolean canRam(boolean withWings) {
        if (withWings != this.hasWings()) {
            return false;
        }
        return !this.isRamGoal && this.ramCooldown <= 0 && this.hasHorns() && !this.getPhaseSwapping() && !this.isFlying() && !this.isDefensive() && this.getTarget() != null && this.getTarget().onGround() && this.onGround();
    }

    public boolean canSummon() {
        return !this.isRamGoal && this.getTarget() != null && this.summonCooldown <= 0 && !this.isFlying() && !this.getPhaseSwapping() && !this.isDefensive() && this.onGround();
    }

    public boolean canAttack() {
        return !this.isRamGoal && this.getTarget() != null && this.getHealth() >= 1.0f && !this.getPhaseSwapping() && !this.isFlying() && !this.isDefensive();
    }

    public boolean canRage() {
        return !this.getPhaseSwapping() && !this.isRamGoal;
    }

    public void getRandomUpgrade() {
        ArrayList<Integer> upgrades = new ArrayList<Integer>();
        if (!this.hasWings()) {
            upgrades.add(0);
        }
        if (!this.hasSpikes()) {
            upgrades.add(1);
        }
        if (!this.hasHorns()) {
            upgrades.add(2);
        }
        if (upgrades.isEmpty()) {
            return;
        }
        int upgrade = (Integer)upgrades.get(this.random.nextInt(upgrades.size()));
        switch (upgrade) {
            case 0: {
                this.setWings(true);
                break;
            }
            case 1: {
                this.setSpikes(true);
                break;
            }
            case 2: {
                this.setHorns(true);
            }
        }
    }

    public void travel(Vec3 pTravelVector) {
        if (this.isEffectiveAi() && this.isInWater() && this.wantsToSwim()) {
            this.moveRelative(0.01f, pTravelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(pTravelVector);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.CACTUS) || source.is(DamageTypes.SWEET_BERRY_BUSH) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.LAVA) || source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.type().msgId().equals("cold")) {
            amount /= 2.0f;
        }
        if (this.getPhaseSwapping()) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity1 = (LivingEntity)entity;
            if (!entity.equals((Object)this)) {
                if (this.isDefensive() && !source.type().msgId().equals("thorns") && !source.is(DamageTypeTags.BYPASSES_ARMOR) && BlockUtil.distanceFrom(entity.position, this.position) <= 3.0) {
                    entity.hurt(this.level.damageSources().thorns((Entity)this), 6.0f);
                }
                if (entity1 instanceof WildenStalker || entity1 instanceof WildenGuardian || entity instanceof WildenHunter || entity instanceof ISummon && ((ISummon)entity).getOwnerUUID() != null && ((ISummon)entity).getOwnerUUID().equals(this.getUUID()) || entity1 instanceof SummonWolf && ((SummonWolf)entity1).isWildenSummon) {
                    return false;
                }
            }
        }
        if (this.isDefensive()) {
            return false;
        }
        float threshold = this.getMaxHealth() / 4.0f;
        float nextMin = this.getMaxHealth() - threshold * (float)(1 + this.getPhase());
        boolean res = super.hurt(source, amount);
        if (!this.level.isClientSide && this.getHealth() <= nextMin && this.getPhase() < 3) {
            this.setPhaseSwapping(true);
            this.setPhase(this.getPhase() + 1);
            this.getNavigation().stop();
            this.setHealth(nextMin);
            this.dead = false;
            this.setFlying(false);
            this.setDefensiveMode(false);
            this.isRamGoal = false;
        }
        return res;
    }

    public boolean isDeadOrDying() {
        return this.getPhase() >= 3 && this.getHealth() <= 0.0f;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    protected boolean canRide(Entity p_184228_1_) {
        return false;
    }

    public void checkDespawn() {
        if (this.level.getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            this.noActionTime = 0;
        }
    }

    public void startSeenByPlayer(ServerPlayer p_184178_1_) {
        super.startSeenByPlayer(p_184178_1_);
        this.bossEvent.addPlayer(p_184178_1_);
    }

    public void stopSeenByPlayer(ServerPlayer p_184203_1_) {
        super.stopSeenByPlayer(p_184203_1_);
        this.bossEvent.removePlayer(p_184203_1_);
    }

    public boolean canChangeDimensions() {
        return false;
    }

    public boolean canBeAffected(MobEffectInstance instance) {
        MobEffect effect = (MobEffect)instance.getEffect().value();
        if (instance.getEffect() instanceof SnareEffect) {
            return false;
        }
        if (effect == MobEffects.MOVEMENT_SLOWDOWN) {
            instance = new MobEffectInstance(instance.getEffect(), 1, 0);
        }
        if (effect == ModPotions.GRAVITY_EFFECT.get()) {
            instance = new MobEffectInstance(instance.getEffect(), Math.min(instance.getDuration(), 100), 0);
        }
        return super.canBeAffected(instance);
    }

    public int getCooldownModifier() {
        return 300 / (this.getPhase() + 1);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(HAS_HORNS, (Object)false);
        pBuilder.define(HAS_SPIKES, (Object)false);
        pBuilder.define(HAS_WINGS, (Object)false);
        pBuilder.define(PHASE, (Object)1);
        pBuilder.define(DEFENSIVE_MODE, (Object)false);
        pBuilder.define(PHASE_SWAPPING, (Object)false);
        pBuilder.define(IS_FLYING, (Object)false);
        pBuilder.define(IS_HOWLING, (Object)false);
        pBuilder.define(IS_DIVING, (Object)false);
        pBuilder.define(IS_RAMMING, (Object)false);
        pBuilder.define(RAM_PREP, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.entityData.set(IS_FLYING, (Object)flying);
    }

    public boolean isHowling() {
        return (Boolean)this.entityData.get(IS_HOWLING) != false || this.getPhaseSwapping();
    }

    public void setHowling(boolean howling) {
        this.entityData.set(IS_HOWLING, (Object)howling);
    }

    public boolean hasHorns() {
        return (Boolean)this.entityData.get(HAS_HORNS);
    }

    public void setHorns(boolean hasHorns) {
        this.entityData.set(HAS_HORNS, (Object)hasHorns);
    }

    public boolean hasSpikes() {
        return (Boolean)this.entityData.get(HAS_SPIKES);
    }

    public void setSpikes(boolean hasSpikes) {
        this.entityData.set(HAS_SPIKES, (Object)hasSpikes);
    }

    public boolean hasWings() {
        return (Boolean)this.entityData.get(HAS_WINGS);
    }

    public void setWings(boolean hasWings) {
        this.entityData.set(HAS_WINGS, (Object)hasWings);
    }

    public boolean isDefensive() {
        return (Boolean)this.entityData.get(DEFENSIVE_MODE);
    }

    public void setDefensiveMode(boolean defensiveMode) {
        this.entityData.set(DEFENSIVE_MODE, (Object)defensiveMode);
    }

    public int getPhase() {
        return (Integer)this.entityData.get(PHASE);
    }

    public void setPhase(int phase) {
        this.entityData.set(PHASE, (Object)phase);
    }

    public boolean getPhaseSwapping() {
        return (Boolean)this.entityData.get(PHASE_SWAPPING);
    }

    public void setPhaseSwapping(boolean swapping) {
        this.entityData.set(PHASE_SWAPPING, (Object)swapping);
    }

    public void setDiving(boolean diving) {
        this.entityData.set(IS_DIVING, (Object)diving);
    }

    public boolean isDiving() {
        return (Boolean)this.entityData.get(IS_DIVING);
    }

    public boolean isRamming() {
        return (Boolean)this.entityData.get(IS_RAMMING);
    }

    public void setRamming(boolean ramming) {
        this.entityData.set(IS_RAMMING, (Object)ramming);
    }

    public boolean isRamPrep() {
        return (Boolean)this.entityData.get(RAM_PREP);
    }

    public void setRamPrep(boolean ramPrep) {
        this.entityData.set(RAM_PREP, (Object)ramPrep);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.setHorns(tag.getBoolean("horns"));
        this.setSpikes(tag.getBoolean("spikes"));
        this.setWings(tag.getBoolean("wings"));
        this.setPhase(tag.getInt("phase"));
        this.setDefensiveMode(tag.getBoolean("defensive"));
        this.setPhaseSwapping(tag.getBoolean("swapping"));
        this.summonCooldown = tag.getInt("summonCooldown");
        this.diveCooldown = tag.getInt("diveCooldown");
        this.spikeCooldown = tag.getInt("spikeCooldown");
        this.ramCooldown = tag.getInt("ramCooldown");
        this.rageTimer = tag.getInt("rage");
        this.swapTicks = tag.getInt("swapTicks");
    }

    public boolean save(CompoundTag tag) {
        tag.putBoolean("spikes", this.hasSpikes());
        tag.putBoolean("horns", this.hasHorns());
        tag.putBoolean("wings", this.hasWings());
        tag.putInt("phase", this.getPhase());
        tag.putBoolean("defensive", this.isDefensive());
        tag.putInt("summonCooldown", this.summonCooldown);
        tag.putInt("diveCooldown", this.diveCooldown);
        tag.putInt("spikeCooldown", this.spikeCooldown);
        tag.putInt("ramCooldown", this.ramCooldown);
        tag.putBoolean("swapping", this.getPhaseSwapping());
        tag.putInt("rage", this.rageTimer);
        tag.putInt("swapTicks", this.swapTicks);
        return super.save(tag);
    }

    protected void checkFallDamage(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        super.checkFallDamage(p_184231_1_, p_184231_3_, p_184231_4_, p_184231_5_);
        if (this.hasWings()) {
            this.fallDistance = 0.0f;
        }
        this.fallDistance = Math.min(this.fallDistance, 10.0f);
    }

    public boolean wantsToSwim() {
        LivingEntity livingentity = this.getTarget();
        return livingentity != null && livingentity.isInWater();
    }

    public PathNavigation getNavigation() {
        return this.isFlying() ? this.flyingNavigator : super.getNavigation();
    }

    public static void faceBlock(BlockPos block, LivingEntity citizen) {
        double xDifference = block.getX() - citizen.blockPosition().getX();
        double zDifference = block.getZ() - citizen.blockPosition().getZ();
        double yDifference = (float)block.getY() - ((float)citizen.blockPosition().getY() + citizen.getEyeHeight());
        double squareDifference = Math.sqrt(xDifference * xDifference + zDifference * zDifference);
        double intendedRotationYaw = Math.atan2(zDifference, xDifference) * 180.0 / Math.PI - 90.0;
        double intendedRotationPitch = -(Math.atan2(yDifference, squareDifference) * 180.0 / Math.PI);
        citizen.yRot = (float)(WildenChimera.updateRotation(citizen.getYRot(), intendedRotationYaw, 360.0) % 360.0);
        citizen.xRot = (float)(WildenChimera.updateRotation(citizen.getXRot(), intendedRotationPitch, 360.0) % 360.0);
    }

    public static double updateRotation(double currentRotation, double intendedRotation, double maxIncrement) {
        double wrappedAngle = Mth.wrapDegrees((double)(intendedRotation - currentRotation));
        if (wrappedAngle > maxIncrement) {
            wrappedAngle = maxIncrement;
        }
        if (wrappedAngle < -maxIncrement) {
            wrappedAngle = -maxIncrement;
        }
        return currentRotation + wrappedAngle;
    }

    protected float getWaterSlowDown() {
        return this.isSwimming() ? super.getWaterSlowDown() : 0.8f;
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public static AttributeSupplier.Builder getModdedAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1000.0).add(Attributes.MOVEMENT_SPEED, 0.33).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.6f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ARMOR, 6.0).add(Attributes.FOLLOW_RANGE, 100.0).add(Attributes.FLYING_SPEED, (double)0.4f).add(Attributes.STEP_HEIGHT, 3.0).add(Attributes.ENTITY_INTERACTION_RANGE, 10.0);
    }

    public boolean isWithinMeleeAttackRange(LivingEntity pEntity) {
        return super.isWithinMeleeAttackRange(pEntity);
    }

    public static class ChimeraMoveController
    extends MoveControl {
        private final boolean hoversInPlace;
        private final WildenChimera chimera;

        public ChimeraMoveController(WildenChimera chimera, boolean hoversInPlace) {
            super((Mob)chimera);
            this.hoversInPlace = hoversInPlace;
            this.chimera = chimera;
        }

        public void tick() {
            WildenChimera chimera = (WildenChimera)this.mob;
            if (chimera.isFlying()) {
                if (chimera.diving) {
                    this.diveTick();
                } else {
                    this.flyTick();
                }
            } else if (this.chimera.wantsToSwim() && this.chimera.isInWater()) {
                this.swimTick();
            } else {
                super.tick();
            }
        }

        public void swimTick() {
            LivingEntity livingentity = this.chimera.getTarget();
            if (livingentity != null && livingentity.getY() > this.chimera.getY()) {
                this.chimera.setDeltaMovement(this.chimera.getDeltaMovement().add(0.0, 0.02, 0.0));
            }
            if (this.operation != MoveControl.Operation.MOVE_TO || this.chimera.getNavigation().isDone()) {
                this.chimera.setSpeed(0.0f);
                return;
            }
            double d0 = this.wantedX - this.chimera.getX();
            double d1 = this.wantedY - this.chimera.getY();
            double d2 = this.wantedZ - this.chimera.getZ();
            double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            d1 /= d3;
            float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            this.chimera.setYRot(this.rotlerp(this.chimera.getYRot(), f, 90.0f));
            this.chimera.yBodyRot = this.chimera.getYRot();
            float f1 = (float)(this.speedModifier * this.chimera.getAttributeValue(Attributes.MOVEMENT_SPEED));
            float f2 = Mth.lerp((float)0.25f, (float)this.chimera.getSpeed(), (float)f1);
            this.chimera.setSpeed(f2);
            this.chimera.setDeltaMovement(this.chimera.getDeltaMovement().add((double)f2 * d0 * 0.08, (double)f2 * d1 * 0.13, (double)f2 * d2 * 0.08));
        }

        public void flyTick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                this.operation = MoveControl.Operation.WAIT;
                this.mob.setNoGravity(true);
                double d0 = this.wantedX - this.mob.getX();
                double d1 = this.wantedY - this.mob.getY();
                double d2 = this.wantedZ - this.mob.getZ();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setYya(0.0f);
                    this.mob.setZza(0.0f);
                    return;
                }
                float f1 = this.mob.onGround() ? (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)) : (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED));
                this.mob.setSpeed(f1);
                this.mob.setYya(d1 > 0.0 ? f1 : -f1);
            } else {
                if (!this.hoversInPlace) {
                    this.mob.setNoGravity(false);
                }
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
            }
        }

        public void diveTick() {
            WildenChimera mob = (WildenChimera)this.mob;
            double posX = mob.getX();
            double posY = mob.getY();
            double posZ = mob.getZ();
            double motionX = mob.getDeltaMovement().x;
            double motionY = mob.getDeltaMovement().y;
            double motionZ = mob.getDeltaMovement().z;
            BlockPos dest = BlockPos.containing((Position)mob.orbitOffset);
            double speedMod = 1.3;
            if (dest.getX() != 0 || dest.getY() != 0 || dest.getZ() != 0) {
                double targetX = (double)dest.getX() + 0.5;
                double targetY = (double)dest.getY() + 0.5;
                double targetZ = (double)dest.getZ() + 0.5;
                Vec3 targetVector = new Vec3(targetX - posX, targetY - posY, targetZ - posZ);
                double length = targetVector.length();
                targetVector = targetVector.scale(0.3 / length);
                double weight = 0.0;
                if (length <= 3.0) {
                    weight = 0.9 * ((3.0 - length) / 3.0);
                }
                motionX = (0.9 - weight) * motionX + (speedMod + weight) * targetVector.x;
                motionY = (0.9 - weight) * motionY + (speedMod + weight) * targetVector.y;
                motionZ = (0.9 - weight) * motionZ + (speedMod + weight) * targetVector.z;
            }
            mob.setDeltaMovement(motionX, motionY, motionZ);
            WildenChimera.faceBlock(BlockPos.containing((Position)mob.orbitOffset), (LivingEntity)mob);
        }
    }

    private static class ChimeraMusic
    extends AbstractTickableSoundInstance {
        private final WildenChimera chimera;

        private ChimeraMusic(WildenChimera chimera) {
            super((SoundEvent)SoundRegistry.WILD_HUNT.get(), SoundSource.RECORDS, SoundInstance.createUnseededRandom());
            this.chimera = chimera;
            this.x = chimera.getX();
            this.y = chimera.getY();
            this.z = chimera.getZ();
            this.looping = true;
        }

        public static void play(WildenChimera chimera) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new ChimeraMusic(chimera));
        }

        public void tick() {
            if (!this.chimera.isAlive()) {
                this.stop();
            } else {
                this.x = this.chimera.getX();
                this.y = this.chimera.getY();
                this.z = this.chimera.getZ();
            }
        }
    }

    public static enum Animations {
        ATTACK,
        HOWL,
        CHARGE,
        FLYING,
        DIVE_BOMB;

    }
}

