/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.DrygmyTile;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.entity.goal.UntamedFindItemGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.drygmy.CollectEssenceGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig.FollowMobGoalBackoff;
import com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig.FollowPlayerGoal;
import com.hollingsworth.arsnouveau.common.items.data.ICharmSerializable;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityDrygmy
extends PathfinderMob
implements GeoEntity,
ITooltipProvider,
IDispellable,
ICharmSerializable {
    public static final EntityDataAccessor<Boolean> CHANNELING = SynchedEntityData.defineId(EntityDrygmy.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.defineId(EntityDrygmy.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> BEING_TAMED = SynchedEntityData.defineId(EntityDrygmy.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> HOLDING_ESSENCE = SynchedEntityData.defineId(EntityDrygmy.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> CHANNELING_ENTITY = SynchedEntityData.defineId(EntityDrygmy.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.defineId(EntityDrygmy.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public int channelCooldown;
    private boolean setBehaviors;
    public BlockPos homePos;
    public int tamingTime;
    public static String[] COLORS = new String[]{"brown", "cyan", "orange"};
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static Map<String, ResourceLocation> TEXTURES = new HashMap<String, ResourceLocation>();

    protected int getBaseExperienceReward() {
        return 0;
    }

    public EntityDrygmy(EntityType<? extends PathfinderMob> p_i48575_1_, Level p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
        this.addGoalsAfterConstructor();
    }

    public EntityDrygmy(Level world, boolean tamed) {
        super((EntityType)ModEntities.ENTITY_DRYGMY.get(), world);
        this.setTamed(tamed);
        this.addGoalsAfterConstructor();
    }

    @Nullable
    public DrygmyTile getHome() {
        if (this.homePos == null || !(this.level.getBlockEntity(this.homePos) instanceof DrygmyTile)) {
            return null;
        }
        return (DrygmyTile)this.level.getBlockEntity(this.homePos);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return SummonUtil.canSummonTakeDamage(pSource) && super.hurt(pSource, pAmount);
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        if (!level.isClientSide && this.isTamed()) {
            ItemStack stack = new ItemStack(ItemsRegistry.DRYGMY_CHARM);
            stack.set(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            level.addFreshEntity((Entity)new ItemEntity((Level)level, this.getX(), this.getY(), this.getZ(), stack));
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.level.isClientSide || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (player.getMainHandItem().is(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.entityData.get(COLOR)).equals(color.getName()) || !Arrays.asList(COLORS).contains(color.getName())) {
                return InteractionResult.SUCCESS;
            }
            this.entityData.set(COLOR, (Object)color.getName());
            if (!player.hasInfiniteMaterials()) {
                player.getMainHandItem().shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        super.tick();
        SummonUtil.healOverTime((LivingEntity)this);
        if (!this.level.isClientSide && this.channelCooldown > 0) {
            --this.channelCooldown;
        }
        if (!this.level.isClientSide && this.level.getGameTime() % 60L == 0L && this.isTamed() && this.homePos != null && !(this.level.getBlockEntity(this.homePos) instanceof DrygmyTile)) {
            this.hurt(this.level.damageSources().playerAttack((Player)ANFakePlayer.getPlayer((ServerLevel)this.level)), 99.0f);
            return;
        }
        if (this.level.isClientSide && this.isChanneling() && this.getChannelEntity() != -1) {
            Entity entity = this.level.getEntity(this.getChannelEntity());
            if (entity == null || entity.isRemoved()) {
                return;
            }
            Vec3 vec = entity.position;
            this.level.addAlwaysVisibleParticle(GlowParticleData.createData(new ParticleColor(50, 255, 20)), false, (double)((float)vec.x) - Math.sin((double)ClientInfo.ticksInGame / 8.0), (double)((float)vec.y) + Math.sin((double)ClientInfo.ticksInGame / 5.0) / 8.0 + 0.5, (double)((float)vec.z) - Math.cos((double)ClientInfo.ticksInGame / 8.0), 0.0, 0.0, 0.0);
        }
        if (!this.isTamed() && !((Boolean)this.entityData.get(BEING_TAMED)).booleanValue() && this.level.getGameTime() % 40L == 0L) {
            for (ItemEntity itementity : this.level.getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(1.0))) {
                this.pickUpItem(itementity);
            }
        }
        if (!this.isTamed() && ((Boolean)this.entityData.get(BEING_TAMED)).booleanValue()) {
            ++this.tamingTime;
            if (this.tamingTime % 20 == 0 && !this.level.isClientSide()) {
                Networking.sendToNearbyClient(this.level, (Entity)this, (CustomPacketPayload)new PacketANEffect(PacketANEffect.EffectType.TIMED_HELIX, this.blockPosition(), ParticleColor.ORANGE, new int[0]));
            }
            if (this.tamingTime > 60 && !this.level.isClientSide) {
                ItemStack stack = new ItemStack(ItemsRegistry.DRYGMY_SHARD, 1 + this.level.random.nextInt(2));
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY() + 0.5, this.getZ(), stack));
                this.remove(Entity.RemovalReason.DISCARDED);
                this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    private PlayState animationPredicate(AnimationState<?> event) {
        if (this.isChanneling() || ((Boolean)this.entityData.get(BEING_TAMED)).booleanValue() || this.level.isClientSide && PatchouliHandler.isPatchouliWorld()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("channel"));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected void addGoalsAfterConstructor() {
        if (this.level.isClientSide()) {
            return;
        }
        for (WrappedGoal goal : this.getGoals()) {
            this.goalSelector.addGoal(goal.getPriority(), goal.getGoal());
        }
    }

    public List<WrappedGoal> getGoals() {
        return (Boolean)this.entityData.get(TAMED) != false ? this.getTamedGoals() : this.getUntamedGoals();
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(CHANNELING, (Object)false);
        pBuilder.define(TAMED, (Object)false);
        pBuilder.define(HOLDING_ESSENCE, (Object)false);
        pBuilder.define(CHANNELING_ENTITY, (Object)-1);
        pBuilder.define(BEING_TAMED, (Object)false);
        pBuilder.define(COLOR, (Object)"brown");
    }

    public void setHoldingEssence(boolean holdingEssence) {
        this.entityData.set(HOLDING_ESSENCE, (Object)holdingEssence);
    }

    public boolean isTamed() {
        return (Boolean)this.entityData.get(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.entityData.set(TAMED, (Object)tamed);
    }

    public boolean isChanneling() {
        return (Boolean)this.entityData.get(CHANNELING);
    }

    public void setChanneling(boolean channeling) {
        this.entityData.set(CHANNELING, (Object)channeling);
    }

    public int getChannelEntity() {
        return (Integer)this.entityData.get(CHANNELING_ENTITY);
    }

    public void setChannelingEntity(int entityID) {
        this.entityData.set(CHANNELING_ENTITY, (Object)entityID);
    }

    protected void registerGoals() {
    }

    public List<WrappedGoal> getTamedGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(3, (Goal)new RandomLookAroundGoal((Mob)this)));
        list.add(new WrappedGoal(2, (Goal)new CollectEssenceGoal(this)));
        list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        return list;
    }

    public List<WrappedGoal> getUntamedGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(3, (Goal)new FollowMobGoalBackoff((Mob)this, 1.0, 3.0f, 7.0f, 0.5f)));
        list.add(new WrappedGoal(5, (Goal)new FollowPlayerGoal((Mob)this, 1.0, 3.0f, 7.0f)));
        list.add(new WrappedGoal(2, (Goal)new RandomLookAroundGoal((Mob)this)));
        list.add(new WrappedGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0)));
        list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        list.add(new WrappedGoal(1, (Goal)new UntamedFindItemGoal((Mob)this, () -> !this.isTamed() && (Boolean)this.entityData.get(BEING_TAMED) == false, itemEntity -> !itemEntity.hasPickUpDelay() && itemEntity.isAlive() && itemEntity.getItem().is(ItemTagProvider.WILDEN_DROP_TAG))));
        return list;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        animatableManager.add(new AnimationController((GeoAnimatable)this, "walkController", 20, this::animationPredicate));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "idleController", 20, this::idlePredicate));
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        if (!this.isTamed() && !((Boolean)this.entityData.get(BEING_TAMED)).booleanValue() && itemEntity.getItem().is(ItemTagProvider.WILDEN_DROP_TAG)) {
            this.entityData.set(BEING_TAMED, (Object)true);
            itemEntity.getItem().shrink(1);
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_PICKUP, this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.isRemoved()) {
            return false;
        }
        if (!this.level.isClientSide && this.isTamed()) {
            ItemStack stack = new ItemStack(ItemsRegistry.DRYGMY_CHARM);
            stack.set(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return this.isTamed();
    }

    private PlayState idlePredicate(AnimationState<?> event) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        NBTUtil.storeBlockPos(tag, "home", this.homePos);
        tag.putBoolean("tamed", ((Boolean)this.entityData.get(TAMED)).booleanValue());
        tag.putInt("cooldown", this.channelCooldown);
        tag.putInt("taming", this.tamingTime);
        tag.putBoolean("beingTamed", ((Boolean)this.entityData.get(BEING_TAMED)).booleanValue());
        if (this.entityData.get(COLOR) != null) {
            tag.putString("color", (String)this.entityData.get(COLOR));
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (NBTUtil.hasBlockPos(tag, "home")) {
            this.homePos = NBTUtil.getBlockPos(tag, "home");
        }
        this.setTamed(tag.getBoolean("tamed"));
        if (!this.setBehaviors) {
            this.tryResetGoals();
            this.setBehaviors = true;
        }
        this.channelCooldown = tag.getInt("cooldown");
        this.tamingTime = tag.getInt("taming");
        this.entityData.set(BEING_TAMED, (Object)tag.getBoolean("beingTamed"));
        if (tag.contains("color")) {
            this.entityData.set(COLOR, (Object)tag.getString("color"));
        }
    }

    public void tryResetGoals() {
        this.goalSelector.availableGoals = new LinkedHashSet();
        this.addGoalsAfterConstructor();
    }

    public ResourceLocation getTexture() {
        String color = this.getColor().toLowerCase();
        if (color.isEmpty()) {
            color = "brown";
        }
        return TEXTURES.computeIfAbsent(color, c -> ArsNouveau.prefix("textures/entity/drygmy_" + c + ".png"));
    }

    @Override
    public void fromCharmData(PersistentFamiliarData data) {
        this.getEntityData().set(COLOR, (Object)data.color());
        this.setCustomName(data.name());
    }

    @Override
    public String getColor() {
        return (String)this.getEntityData().get(COLOR);
    }
}

